/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.Output;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.support.AMXAttributeNameMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXAttributeNameMapperImpl
implements AMXAttributeNameMapper {
    final Map<String, String> mDerivedToOriginal = new HashMap<String, String>();
    final Map<String, String> mOriginalToDerived = new HashMap<String, String>();
    final Set<String> mDerivedNames = new HashSet<String>();
    final Map<String, String> mUnmappedOriginals = new HashMap<String, String>();
    private Output mDebug = null;
    private static final char DASH_CHAR = '-';
    private static final String DASH = "-";

    public void setDebugOutput(Output debugOutput) {
        this.mDebug = debugOutput;
    }

    protected final void debug(Object o) {
        if (this.mDebug != null) {
            this.mDebug.println(o);
        }
    }

    private String stripDashes(String name) {
        String result = name;
        if (name.indexOf(DASH) >= 0) {
            StringBuilder builder = new StringBuilder();
            int length = name.length();
            boolean upperNext = false;
            for (int i = 0; i < length; ++i) {
                char c = name.charAt(i);
                if (c == '-') {
                    upperNext = true;
                    continue;
                }
                if (upperNext) {
                    builder.append(("" + c).toUpperCase());
                    upperNext = false;
                    continue;
                }
                builder.append(c);
            }
            result = builder.toString();
        }
        return result;
    }

    private String normalize(String s) {
        return this.stripDashes(s).toLowerCase();
    }

    private Map<String, String> normalize(Set<String> s) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : s) {
            result.put(this.normalize(name), name);
        }
        return result;
    }

    @Override
    public String matchName(String derivedName, String[] candidates) {
        String result = null;
        String existingOriginal = this.derivedToOriginal(derivedName);
        if (existingOriginal != null) {
            throw new IllegalArgumentException("Already mapped: " + derivedName + " => " + existingOriginal);
        }
        if (this.mUnmappedOriginals.keySet().size() == 0) {
            throw new IllegalArgumentException("There are no unmapped originals, existing mappings: " + MapUtil.toString(this.mOriginalToDerived, ", "));
        }
        for (String candidate : candidates) {
            String candidateNormalized = this.normalize(candidate);
            if (!this.mUnmappedOriginals.keySet().contains(candidateNormalized)) continue;
            result = this.mUnmappedOriginals.get(candidateNormalized);
            this.mUnmappedOriginals.remove(candidateNormalized);
            this.addMapping(result, derivedName);
            break;
        }
        if (result == null) {
            String msg = derivedName + " can't be matched to " + StringUtil.toString(", ", (Object[])candidates) + ", unmapped originals: " + CollectionUtil.toString(this.mUnmappedOriginals.values(), ", ") + ",  mapped originals: {" + MapUtil.toString(this.mDerivedToOriginal, ", ") + "}";
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    @Override
    public String matchName(String derivedName, String candidate1, String candidate2) {
        return this.matchName(derivedName, new String[]{candidate1, candidate2});
    }

    @Override
    public String matchName(String derivedName, String candidate1) {
        return this.matchName(derivedName, new String[]{candidate1});
    }

    @Override
    public void matchNames(String[] derivedNames, String[] originalNames) {
        Set<String> originals = GSetUtil.newSet(originalNames);
        Set<String> deriveds = GSetUtil.newSet(derivedNames);
        for (String original : originalNames) {
            if (!deriveds.contains(original)) continue;
            this.addMapping(original, original);
            originals.remove(original);
            deriveds.remove(original);
        }
        if (originals.size() != 0) {
            Map<String, String> originalsMap = this.normalize(originals);
            Map<String, String> derivedsMap = this.normalize(deriveds);
            for (String originalLowerCase : originalsMap.keySet()) {
                String original = originalsMap.get(originalLowerCase);
                String derived = derivedsMap.get(originalLowerCase);
                if (derived != null) {
                    this.addMapping(original, derived);
                    continue;
                }
                this.mUnmappedOriginals.put(this.normalize(original), original);
            }
        }
    }

    @Override
    public Set<String> getUnmappedOriginals() {
        Set<String> unmapped = Collections.emptySet();
        if (this.mUnmappedOriginals.keySet().size() != 0) {
            unmapped = new HashSet<String>(this.mUnmappedOriginals.values());
        }
        return unmapped;
    }

    public void addMapping(String originalName, String derivedName) {
        this.mDerivedToOriginal.put(derivedName, originalName);
        this.mOriginalToDerived.put(originalName, derivedName);
        if (this.mUnmappedOriginals.keySet().contains(originalName)) {
            this.mUnmappedOriginals.remove(originalName);
        }
        this.mDerivedNames.add(derivedName);
    }

    public void dontMap(String originalName) {
        this.addMapping(originalName, originalName);
    }

    @Override
    public String originalToDerived(String originalName) {
        String derivedName = this.mOriginalToDerived.get(originalName);
        return derivedName;
    }

    @Override
    public String derivedToOriginal(String derivedName) {
        String original = this.mDerivedToOriginal.get(derivedName);
        return original;
    }

    @Override
    public Set<String> getDerivedNames() {
        return this.mDerivedNames;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String LINE_SEPARATOR = System.getProperty("line.separator");
        for (String name : this.getDerivedNames()) {
            builder.append(name);
            builder.append(" => ");
            builder.append(this.derivedToOriginal(name));
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

