/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MailResourceConfigFactory
extends ResourceFactoryImplBase {
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("StoreProtocol", "StoreProtocolClass", "TransportProtocol", "TransportProtocolClass", "Debug", "Description", "Enabled");
    public static final String HOST_KEY = "Host";
    public static final String USER_KEY = "User";
    public static final String FROM_KEY = "From";

    public MailResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("MailResourceConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createMailResource(translatedAttrs);
        return objectName;
    }

    public ObjectName create(String jndiName, String host, String user, String from, Map<String, String> optional) {
        String[] requiredParams = new String[]{HOST_KEY, host, USER_KEY, user, FROM_KEY, from};
        Map<String, String> params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    @Override
    protected final void removeByName(String name) {
        Set<ResourceRefConfig> refs = this.findAllRefConfigs("X-MailResourceConfig", name);
        if (refs.size() == 0) {
            this.getOldResourcesMBean().removeMailResourceByJndiName(name);
        } else {
            for (ResourceRefConfig ref : refs) {
                String target = ref.getContainer().getName();
                this.getOldResourcesMBean().deleteMailResource(name, target);
            }
        }
    }
}

