/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCConnectionPoolConfigFactory
extends ResourceFactoryImplBase {
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("ConnectionValidationMethod", "ValidationTableName", "FailAllConnections", "IdleTimeoutInSeconds", "IsConnectionValidationRequired", "IsIsolationLevelGuaranteed", "TransactionIsolationLevel", "MaxPoolSize", "MaxWaitTimeInMillis", "PoolResizeQuantity", "ResType", "SteadyPoolSize", "NonTransactionalConnections", "AllowNonComponentCallers", "property.DatabaseName", "property.User", "property.Password");

    public JDBCConnectionPoolConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("JDBCConnectionPoolConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createJdbcConnectionPool(translatedAttrs);
        return objectName;
    }

    public ObjectName create(String name, String datasourceClassname, Map<String, String> optional) {
        String[] requiredParams = new String[]{"DatasourceClassname", datasourceClassname};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    public ObjectName create(String name, String connectionValidationMethod, String datasourceClassname, boolean failAllConnections, int idleTimeoutSeconds, boolean connectionValidationRequired, boolean isolationLevelGuaranteed, String transactionIsolationLevel, int maxPoolSize, int maxWaitTimeMillis, int poolResizeQuantity, String resType, int steadyPoolSize, String databaseName, String databaseUserName, String databasePassword, Map<String, String> reserved) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        optionalParams.put("ConnectionValidationMethod", connectionValidationMethod);
        optionalParams.put("FailAllConnections", Boolean.toString(failAllConnections));
        optionalParams.put("IdleTimeoutInSeconds", Integer.toString(idleTimeoutSeconds));
        optionalParams.put("IsConnectionValidationRequired", Boolean.toString(connectionValidationRequired));
        optionalParams.put("IsIsolationLevelGuaranteed", Boolean.toString(isolationLevelGuaranteed));
        optionalParams.put("TransactionIsolationLevel", transactionIsolationLevel);
        optionalParams.put("MaxPoolSize", Integer.toString(maxPoolSize));
        optionalParams.put("MaxWaitTimeInMillis", Integer.toString(maxWaitTimeMillis));
        optionalParams.put("PoolResizeQuantity", Integer.toString(poolResizeQuantity));
        optionalParams.put("ResType", resType);
        optionalParams.put("SteadyPoolSize", Integer.toString(steadyPoolSize));
        optionalParams.put("property.DatabaseName", databaseName);
        optionalParams.put("property.User", databaseUserName);
        optionalParams.put("property.Password", databasePassword);
        optionalParams.putAll(reserved);
        ObjectName amxName = this.create(name, datasourceClassname, optionalParams);
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        this.getOldResourcesMBean().removeJdbcConnectionPoolByName(name);
    }
}

