/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class RNGValidator {
    RNGValidator() {
    }

    void validate(InputSource schema, InputSource src, Writer w) throws VerifierConfigurationException, SAXException, IOException {
        this.validate(schema, src, new MyErrorHandler(w));
    }

    void validate(InputSource schema, InputSource src, XMLReader rdr, Writer w) throws VerifierConfigurationException, SAXException, IOException {
        this.validate(schema, src, rdr, new MyErrorHandler(w));
    }

    void validate(InputSource schema, InputSource src, ErrorHandler eh) throws VerifierConfigurationException, SAXException, IOException {
        this.getVerifier(schema, eh).verify(src);
    }

    void validate(InputSource schema, InputSource src, XMLReader rdr, ErrorHandler errorHandler) throws VerifierConfigurationException, SAXException, IOException {
        rdr.setContentHandler((ContentHandler)this.getVerifier(schema, rdr.getEntityResolver(), errorHandler).getVerifierHandler());
        rdr.parse(src);
    }

    private Verifier getVerifier(InputSource schema, ErrorHandler eh) throws VerifierConfigurationException, SAXException, IOException {
        return this.getVerifier(schema, null, eh);
    }

    private Verifier getVerifier(InputSource schema, EntityResolver er, ErrorHandler eh) throws VerifierConfigurationException, SAXException, IOException {
        TheFactoryImpl f = new TheFactoryImpl();
        Verifier verifier = f.newVerifier(schema);
        verifier.setErrorHandler(eh);
        verifier.setEntityResolver(er);
        return verifier;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        MyErrorHandler(Writer out) {
            this.out = new PrintWriter(out);
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            this.out.println(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

