/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.util.LocalStringManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Localiser
extends DefaultHandler {
    private final LocalStringManager lsm;
    private final Writer out;
    private final Logger logger;
    private final String prefix;
    private String message_id;
    private ArrayList params = new ArrayList(5);
    private StringBuffer textBuffer;

    Localiser(LocalStringManager lsm, Writer out, String prefix) {
        this(lsm, out, null, prefix);
    }

    Localiser(LocalStringManager lsm, Writer out, Logger logger) {
        this(lsm, out, logger, null);
    }

    Localiser(LocalStringManager lsm, Writer out) {
        this(lsm, out, null, null);
    }

    Localiser(LocalStringManager lsm, Writer out, Logger logger, String prefix) {
        this.lsm = lsm;
        this.out = out;
        this.logger = logger;
        this.prefix = prefix == null ? "" : prefix + ".";
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("location")) {
            this.startLocation();
        } else if (localName.equals("message")) {
            this.startMessage(atts);
        } else if (localName.equals("param")) {
            this.startParam(atts);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (null != this.textBuffer) {
            this.textBuffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("location")) {
            this.endLocation();
        } else if (localName.equals("message")) {
            this.endMessage();
        } else if (localName.equals("param")) {
            this.endParam();
        }
    }

    private void startLocation() {
        this.textBuffer = new StringBuffer();
    }

    private void endLocation() throws SAXException {
        if (null != this.textBuffer && this.textBuffer.length() > 0) {
            try {
                this.textBuffer.append(" ");
                this.out.write(this.textBuffer.toString());
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        this.textBuffer = null;
    }

    private void startMessage(Attributes attr) throws SAXException {
        this.params.clear();
        String id = attr.getValue("", "id");
        if (null == id || id.length() == 0) {
            throw new SAXException("id attribute is either null or empty");
        }
        this.message_id = this.prefix + id;
    }

    private void startParam(Attributes attr) {
        this.textBuffer = new StringBuffer();
    }

    private void endParam() {
        this.params.add(this.textBuffer.toString());
        this.textBuffer = null;
    }

    private void endMessage() throws SAXException {
        String msg = this.lsm.getLocalString(null, this.message_id, "Internal Error, message id  \"" + this.message_id + "\" not present in localisation file", this.params.toArray());
        this.message_id = null;
        if (null != this.logger && msg.startsWith("Internal Error")) {
            this.logger.severe(msg);
            return;
        }
        try {
            this.out.write(msg + "\n");
            this.out.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

