/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.jmx;

import com.sun.enterprise.admin.util.jmx.AttributeListUtils;
import com.sun.org.apache.commons.modeler.FieldInfo;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.Registry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectNamesSourceGenerator {
    private final File regFile;
    private final OutputStream out;
    private final Registry reg;
    private String pkgName;
    private String className;
    private static final String PARAM = "param";
    private static final char ONDELIMITER = ':';
    private static final String ANY_GETTER = "getConfigBeanObjectName";
    private static final String DEFAULT_PACKAGE_NAME = null;
    private static final String DEFAULT_CLASS_NAME = "ConfigMBeanNames";

    public ObjectNamesSourceGenerator(File regFile, OutputStream out) throws Exception {
        if (regFile == null || !regFile.canRead() || out == null) {
            throw new IllegalArgumentException("Either the registry file is unreadable or stream could not be written to");
        }
        this.regFile = regFile;
        this.out = out;
        this.pkgName = DEFAULT_PACKAGE_NAME;
        this.className = DEFAULT_CLASS_NAME;
        this.reg = new Registry();
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(regFile));
        this.reg.loadDescriptors("MbeansDescriptorsDOMSource", (Object)stream, null);
    }

    private void setClassName(String c) {
        this.className = c;
    }

    private void setPackageName(String p) {
        this.pkgName = p;
    }

    public String asString() throws Exception {
        String[] s = this.reg.findManagedBeans();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClassPreamble());
        for (int i = 0; i < s.length; ++i) {
            sb.append(this.mb2s(s[i]));
        }
        sb.append("\n}");
        return sb.toString();
    }

    public void write() throws Exception {
        this.out.write(this.asString().getBytes());
    }

    private String getClassPreamble() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPackageDeclaration());
        sb.append(this.getImports());
        sb.append(this.getClassJavadoc());
        return sb.toString();
    }

    private String getPackageDeclaration() {
        StringBuffer sb = new StringBuffer();
        sb.append("package TBD...").append('\n');
        sb.append('\n');
        return sb.toString();
    }

    private String getClassJavadoc() {
        StringBuffer sb = new StringBuffer("/** An Auto-generated MBean ObjectName Factory */");
        sb.append('\n');
        sb.append("public class ConfigMBeanNames  {");
        sb.append('\n');
        return sb.toString();
    }

    private String getImports() {
        return "import javax.management.ObjectName;\n";
    }

    private String mb2s(String name) {
        ManagedBean mb = this.reg.findManagedBean(name);
        StringBuffer sb = new StringBuffer();
        String method = this.getMethodSignature(mb);
        sb.append(method).append('\n');
        sb.append(this.getMethodBody(mb)).append('\n');
        return sb.toString();
    }

    private String getMethodSignature(ManagedBean mb) {
        StringBuffer sb = new StringBuffer("public static final ObjectName ");
        sb.append("get");
        String humped = AttributeListUtils.dash2CamelCase(mb.getName());
        sb.append(this.getValidJavaMethodName(humped));
        sb.append("ObjectName(");
        String onv = this.getObjectNameValue(mb);
        sb.append(this.getParameterList(onv));
        sb.append(" )");
        return sb.toString();
    }

    private String getMethodBody(ManagedBean mb) {
        String onv = this.getObjectNameValue(mb);
        String params = this.getParameterList(onv);
        String nodm = onv.substring(onv.indexOf(58) + 1);
        String ong = this.positionalReplace(nodm);
        String ret = this.getReturnStatement(ong);
        StringBuffer sb = new StringBuffer("{").append('\n').append(ret).append('\n').append("}");
        return sb.toString();
    }

    private String positionalReplace(String tk) {
        String rs = Tok2Params.replacePositionalTokens(tk);
        return rs;
    }

    private String getReturnStatement(String s) {
        StringBuffer sb = new StringBuffer();
        String qs = "\"" + s + "\"";
        sb.append("return ( ").append(ANY_GETTER).append("( ").append(qs).append(" )").append(" )");
        return sb.toString();
    }

    private String getObjectNameValue(ManagedBean mb) {
        List fields = mb.getFields();
        Iterator iter = fields.iterator();
        String val = null;
        while (iter.hasNext()) {
            FieldInfo f = (FieldInfo)iter.next();
            if (!"ObjectName".equals(f.getName())) continue;
            val = (String)f.getValue();
        }
        return val;
    }

    private String getValidJavaMethodName(String s) {
        String n = s.replace('#', '_');
        return n;
    }

    private String getParameterList(String on) {
        return Tok2Params.convert2ParamList(on);
    }

    public static void main(String[] args) {
        try {
            File r = new File("/export/home/kedar/ee/LATEST/admin-core/admin/dtds/admin-mbeans-descriptors.xml");
            PrintStream op = System.out;
            ObjectNamesSourceGenerator o = new ObjectNamesSourceGenerator(r, op);
            String s = o.asString();
            ((OutputStream)op).write(s.getBytes());
            System.out.println("Done");
            System.out.println("The length of Java source file would be, Characters: " + s.length());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class Tok2Params {
        private static final String REGEX1 = "a*\\{\\d\\}a*";

        private Tok2Params() {
        }

        private static String convert2ParamList(String s) {
            Pattern p = Pattern.compile(REGEX1);
            Matcher m = p.matcher(s);
            int n = 0;
            while (m.find()) {
                ++n;
            }
            return Tok2Params.getStringParamList(n - 1);
        }

        private static String getStringParamList(int n) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                sb.append(" final String ").append(ObjectNamesSourceGenerator.PARAM).append(i + 1);
                if (i == n - 1) continue;
                sb.append(',');
            }
            return sb.toString();
        }

        private static String replacePositionalTokens(String ts) {
            Pattern p = Pattern.compile(REGEX1);
            Matcher m = p.matcher(ts);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String gr = m.group();
                char ch = gr.charAt(1);
                String replacement = ObjectNamesSourceGenerator.PARAM + ch;
                m.appendReplacement(sb, replacement);
            }
            m.appendTail(sb);
            return sb.toString();
        }
    }
}

