/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.jndi;

import com.sun.enterprise.admin.monitor.jndi.JndiMBeanImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class JndiMBeanManager {
    private MBeanServer server = this.getMBeanServer();
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager(JndiMBeanManager.class);

    public void registerMBean(ObjectName objectName) {
        try {
            if (this.server.isRegistered(objectName)) {
                logger.fine(sm.getString("monitor.jndi.already_registered", new Object[]{objectName.toString()}));
                return;
            }
            this.server.registerMBean(new JndiMBeanImpl(), objectName);
            logger.finer(sm.getString("monitor.jndi.registered", new Object[]{objectName.toString()}));
        }
        catch (Exception e) {
            logger.fine(sm.getString("monitor.jndi.register_exception", new Object[]{objectName}));
            logger.throwing(JndiMBeanManager.class.getName(), "registerMBean()", e);
        }
    }

    public void unregisterMBean(ObjectName objectName) {
        try {
            if (this.server.isRegistered(objectName)) {
                this.server.unregisterMBean(objectName);
                logger.fine(sm.getString("monitor.jndi.unregistered", new Object[]{objectName.toString()}));
            } else {
                logger.fine(sm.getString("monitor.jndi.never_registered", new Object[]{objectName.toString()}));
            }
        }
        catch (Exception e) {
            logger.fine(sm.getString("monitor.jndi.register_failed", new Object[]{objectName.toString()}));
        }
    }

    MBeanServer getMBeanServer() {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (!servers.isEmpty()) {
            server = servers.get(0);
        }
        return server;
    }
}

