/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.Handler;
import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HandlerChain {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private boolean traceOn = false;
    Map<String, Handler> handlers = new HashMap<String, Handler>();

    public HandlerChain() {
        this.traceOn = TraceOnHelper.isTraceOn();
    }

    public void addHandler(Handler handler) {
        String name = handler.getName();
        if (name == null) {
            name = handler.getClass().getName();
        }
        this.handlers.put(name, handler);
        if (this.traceOn) {
            StringBuffer sb = new StringBuffer();
            for (String handlerName : this.handlers.keySet()) {
                sb.append(handlerName + ", ");
            }
            logger.log(Level.INFO, " Callflow: Handlers :" + sb.toString());
        }
    }

    public Handler[] getHandlers() {
        Handler[] h = this.handlers.values().toArray(new Handler[0]);
        return h;
    }

    public void removeHandler(String name) {
        if (this.traceOn) {
            logger.log(Level.INFO, " Callflow:Removing Handler :" + name);
        }
        this.handlers.remove(name);
    }
}

