/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.AsyncHandlerFactory;
import com.sun.enterprise.admin.monitor.callflow.AsyncHandlerIntf;
import com.sun.enterprise.admin.monitor.callflow.CallFlowInfo;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.admin.monitor.callflow.ContainerTypeOrApplicationType;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObject;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.EntityManagerMethod;
import com.sun.enterprise.admin.monitor.callflow.EntityManagerQueryMethod;
import com.sun.enterprise.admin.monitor.callflow.Listener;
import com.sun.enterprise.admin.monitor.callflow.RequestInfo;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.monitor.callflow.ThreadLocalData;
import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import com.sun.enterprise.web.connector.extension.GrizzlyConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentImpl
implements Agent {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final ThreadLocal<ThreadLocalState> threadLocal = new ThreadLocal(){

        protected ThreadLocalState initialValue() {
            return new ThreadLocalState();
        }
    };
    private static Agent __singletonAgent = new AgentImpl();
    private AtomicBoolean storeData = new AtomicBoolean(false);
    private int dataWriterThreadCount;
    private String callerIPAddressFilter;
    private String callerPrincipalFilter;
    private AsyncHandlerIntf asyncHandler = AsyncHandlerFactory.getInstance();
    private DbAccessObject dbAccessObject = DbAccessObjectImpl.getInstance();
    private boolean traceOn;
    private List<Listener> listeners = Collections.synchronizedList(new ArrayList());
    private boolean perfImpl = System.getProperty("com.sun.enterprise.callflow.perf", "true").equals("true");

    private AgentImpl() {
        this.traceOn = TraceOnHelper.isTraceOn();
    }

    public static Agent getInstance() {
        return __singletonAgent;
    }

    public void requestStart(RequestType requestType) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            threadLocal.remove();
            ThreadLocalState tls = threadLocal.get();
            tls.getFlowStack().clear();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", requestStart()");
            }
            tls.getRequestData().setRequestType(requestType);
            tls.getRequestData().setRequestStartTime(System.nanoTime());
            tls.getRequestData().setRequestStartTimeMillis(System.currentTimeMillis());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.request_start_operation_failed", e);
        }
    }

    public void addRequestInfo(RequestInfo requestInfo, String value) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", addRequestInfo()");
            }
            if (tls.getInitialized()) {
                logger.log(Level.FINE, "callflow.add_request_info_disallowed");
                return;
            }
            if (requestInfo == RequestInfo.CALLER_IP_ADDRESS) {
                tls.getRequestData().setCallerIPAddress(value);
            } else if (requestInfo == RequestInfo.REMOTE_USER) {
                tls.getRequestData().setRemoteUser(value);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.add_request_info_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        ThreadLocalState tls = threadLocal.get();
        if (tls.getInitialized()) {
            return;
        }
        RequestData requestData = tls.getRequestData();
        String callerIPAddress = requestData.getCallerIPAddress();
        String remoteUser = requestData.getRemoteUser();
        boolean filtered = false;
        if (this.callerIPAddressFilter != null && !this.callerIPAddressFilter.equals(callerIPAddress)) {
            filtered = true;
        }
        if (this.callerPrincipalFilter != null && !this.callerPrincipalFilter.equals(remoteUser)) {
            filtered = true;
        }
        tls.setStoreData(!filtered && this.getStoreData());
        if (!this.perfImpl && !filtered && this.getStoreData()) {
            AsyncHandlerIntf asyncHandlerIntf = this.asyncHandler;
            synchronized (asyncHandlerIntf) {
                if (this.dataWriterThreadCount == 0) {
                    this.asyncHandler.enable();
                }
                ++this.dataWriterThreadCount;
            }
        }
        tls.setInitialized(true);
        boolean listenersPresent = false;
        long otherStartTime = System.nanoTime();
        if (!this.listeners.isEmpty()) {
            listenersPresent = true;
            List<Listener> list = this.listeners;
            synchronized (list) {
                for (Listener listener : this.listeners) {
                    listener.requestStart(tls.getRequestId(), requestData.getRequestType(), callerIPAddress, remoteUser);
                }
            }
        }
        long otherEndTime = System.nanoTime();
        if (tls.getStoreData()) {
            this.storeRequestStartData(tls.getRequestId(), requestData.getRequestStartTime(), requestData.getRequestStartTimeMillis(), requestData.getRequestType(), callerIPAddress, remoteUser, tls.getFlowStack(), listenersPresent, otherStartTime, otherEndTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestEnd() {
        block18: {
            try {
                if (!this.getStoreData()) {
                    return;
                }
                ThreadLocalState tls = threadLocal.get();
                if (this.traceOn) {
                    logger.log(Level.INFO, tls.getRequestId() + ", requestEnd()");
                }
                boolean listenersPresent = false;
                long otherStartTime = System.nanoTime();
                if (!this.listeners.isEmpty()) {
                    listenersPresent = true;
                    List<Listener> list = this.listeners;
                    synchronized (list) {
                        for (Listener listener : this.listeners) {
                            listener.requestEnd(tls.getRequestId());
                        }
                    }
                }
                long otherEndTime = System.nanoTime();
                if (tls.getStoreData()) {
                    this.storeRequestEndData(tls.getRequestId(), tls.getFlowStack(), listenersPresent, otherStartTime, otherEndTime);
                }
                if (this.perfImpl || !tls.getStoreData()) break block18;
                AsyncHandlerIntf asyncHandlerIntf = this.asyncHandler;
                synchronized (asyncHandlerIntf) {
                    --this.dataWriterThreadCount;
                    if (this.dataWriterThreadCount == 0) {
                        this.asyncHandler.disable();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "callflow.request_end_operation_failed", e);
            }
            finally {
                threadLocal.remove();
            }
        }
    }

    public void startTime(ContainerTypeOrApplicationType type) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", startTime()");
            }
            this.initialize();
            if (tls.getStoreData()) {
                this.storeStartTimeData(tls.getRequestId(), type, tls.getFlowStack());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.start_time_operation_failed", e);
        }
    }

    public void endTime() {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", endTime()");
            }
            if (tls.getStoreData()) {
                this.storeEndTimeData(tls.getRequestId(), tls.getFlowStack());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.end_time_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbMethodStart(CallFlowInfo info) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", ejbMethodStart()");
            }
            String requestId = tls.getRequestId();
            String methodName = info.getMethod().toString();
            ComponentType componentType = info.getComponentType();
            String applicationName = info.getApplicationName();
            String moduleName = info.getModuleName();
            String componentName = info.getComponentName();
            String transactionId = info.getTransactionId();
            String securityId = info.getCallerPrincipal();
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.ejbMethodStart(requestId, methodName, applicationName, moduleName, componentName, componentType, securityId, transactionId);
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodStartData(tls.getRequestId(), info.getMethod().toString(), info.getComponentType(), info.getApplicationName(), info.getModuleName(), info.getComponentName(), Thread.currentThread().getName(), info.getTransactionId(), info.getCallerPrincipal(), tls.getFlowStack(), ContainerTypeOrApplicationType.EJB_APPLICATION, listenersPresent, otherStartTime, otherEndTime);
            }
            tls.setMethodName(methodName);
            tls.setApplicationName(applicationName);
            tls.setModuleName(moduleName);
            tls.setComponentName(componentName);
            tls.setComponentType(componentType.toString());
            tls.setTransactionId(transactionId);
            tls.setSecurityId(securityId);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.ejb_method_start_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbMethodEnd(CallFlowInfo info) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", ejbMethodEnd()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.ejbMethodEnd(tls.getRequestId(), info.getException());
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodEndData(tls.getRequestId(), info.getException(), tls.getFlowStack(), listenersPresent, otherStartTime, otherEndTime);
            }
            tls.setMethodName(null);
            tls.setApplicationName(null);
            tls.setModuleName(null);
            tls.setComponentName(null);
            tls.setComponentType(null);
            tls.setTransactionId(null);
            tls.setSecurityId(null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.ejb_method_end_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webMethodStart(String methodName, String applicationName, String moduleName, String componentName, ComponentType componentType, String callerPrincipal) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", webMethodStart()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.webMethodStart(tls.getRequestId(), methodName, applicationName, moduleName, componentName, componentType, callerPrincipal);
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodStartData(tls.getRequestId(), methodName, componentType, applicationName, moduleName, componentName, Thread.currentThread().getName(), null, callerPrincipal, tls.getFlowStack(), ContainerTypeOrApplicationType.WEB_APPLICATION, listenersPresent, otherStartTime, otherEndTime);
            }
            tls.setMethodName(methodName);
            tls.setApplicationName(applicationName);
            tls.setModuleName(moduleName);
            tls.setComponentName(componentName);
            tls.setComponentType(componentType.toString());
            tls.setTransactionId(null);
            tls.setSecurityId(callerPrincipal);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.web_method_start_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webMethodEnd(Throwable exception) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", webMethodEnd()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.webMethodEnd(tls.getRequestId(), exception);
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodEndData(tls.getRequestId(), exception, tls.getFlowStack(), listenersPresent, otherStartTime, otherEndTime);
            }
            tls.setMethodName(null);
            tls.setApplicationName(null);
            tls.setModuleName(null);
            tls.setComponentName(null);
            tls.setComponentType(null);
            tls.setTransactionId(null);
            tls.setSecurityId(null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.web_method_end_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerQueryStart(EntityManagerQueryMethod queryMethod) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", entityManagerQuerytart()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.entityManagerQueryStart(tls.getRequestId(), queryMethod, tls.getApplicationName(), tls.getModuleName(), tls.getComponentName(), ComponentType.JPA, tls.getSecurityId());
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodStartData(tls.getRequestId(), queryMethod.toString(), ComponentType.JPA, tls.getApplicationName(), tls.getModuleName(), tls.getComponentName(), Thread.currentThread().getName(), null, tls.getSecurityId(), tls.getFlowStack(), ContainerTypeOrApplicationType.JAVA_PERSISTENCE, listenersPresent, otherStartTime, otherEndTime);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.web_method_start_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerQueryEnd() {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", entityManagerQueryEnd()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.entityManagerQueryEnd(tls.getRequestId());
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodEndData(tls.getRequestId(), null, tls.getFlowStack(), listenersPresent, otherStartTime, otherEndTime);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.ejb_method_end_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodStart(EntityManagerMethod entityManagerMethod) {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", entityManagerMethodStart()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.entityManagerMethodStart(tls.getRequestId(), entityManagerMethod, tls.getApplicationName(), tls.getModuleName(), tls.getComponentName(), ComponentType.JPA, tls.getSecurityId());
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodStartData(tls.getRequestId(), entityManagerMethod.toString(), ComponentType.JPA, tls.getApplicationName(), tls.getModuleName(), tls.getComponentName(), Thread.currentThread().getName(), null, tls.getSecurityId(), tls.getFlowStack(), ContainerTypeOrApplicationType.JAVA_PERSISTENCE, listenersPresent, otherStartTime, otherEndTime);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.web_method_start_operation_failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodEnd() {
        try {
            if (!this.getStoreData()) {
                return;
            }
            ThreadLocalState tls = threadLocal.get();
            if (this.traceOn) {
                logger.log(Level.INFO, tls.getRequestId() + ", entityManagerMethodEnd()");
            }
            boolean listenersPresent = false;
            long otherStartTime = System.nanoTime();
            if (!this.listeners.isEmpty()) {
                listenersPresent = true;
                List<Listener> list = this.listeners;
                synchronized (list) {
                    for (Listener listener : this.listeners) {
                        listener.entityManagerMethodEnd(tls.getRequestId());
                    }
                }
            }
            long otherEndTime = System.nanoTime();
            if (tls.getStoreData()) {
                this.storeMethodEndData(tls.getRequestId(), null, tls.getFlowStack(), listenersPresent, otherStartTime, otherEndTime);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "callflow.ejb_method_end_operation_failed", e);
        }
    }

    private void storeRequestStartData(String requestId, long timeStamp, long timeStampMillis, RequestType requestType, String callerIPAddress, String remoteUser, FlowStack<ContainerTypeOrApplicationType> flowStack, boolean listenersPresent, long otherStartTime, long otherEndTime) {
        if (requestType == RequestType.REMOTE_WEB) {
            flowStack.push(ContainerTypeOrApplicationType.WEB_CONTAINER);
        } else if (requestType == RequestType.REMOTE_EJB) {
            flowStack.push(ContainerTypeOrApplicationType.ORB_CONTAINER);
        } else {
            flowStack.push(ContainerTypeOrApplicationType.EJB_CONTAINER);
        }
        this.asyncHandler.handleRequestStart(requestId, timeStamp, timeStampMillis, requestType, callerIPAddress, remoteUser);
        this.asyncHandler.handleStartTime(requestId, timeStamp, (ContainerTypeOrApplicationType)flowStack.peek());
        if (listenersPresent) {
            flowStack.push(ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleStartTime(requestId, otherStartTime, ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleEndTime(requestId, otherEndTime, flowStack.pop());
        }
    }

    private void storeRequestEndData(String requestId, FlowStack<ContainerTypeOrApplicationType> flowStack, boolean listenersPresent, long otherStartTime, long otherEndTime) {
        this.asyncHandler.handleEndTime(requestId, System.nanoTime(), flowStack.pop());
        if (listenersPresent) {
            flowStack.push(ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleStartTime(requestId, otherStartTime, ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleEndTime(requestId, otherEndTime, flowStack.pop());
        }
        this.asyncHandler.handleRequestEnd(requestId, System.nanoTime());
    }

    private void storeMethodStartData(String requestId, String methodName, ComponentType componentType, String applicationName, String moduleName, String componentName, String threadId, String transactionId, String securityId, FlowStack<ContainerTypeOrApplicationType> flowStack, ContainerTypeOrApplicationType appType, boolean listenersPresent, long otherStartTime, long otherEndTime) {
        this.asyncHandler.handleEndTime(requestId, System.nanoTime(), (ContainerTypeOrApplicationType)flowStack.peek());
        if (listenersPresent) {
            flowStack.push(ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleStartTime(requestId, otherStartTime, ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleEndTime(requestId, otherEndTime, flowStack.pop());
        }
        this.asyncHandler.handleMethodStart(requestId, System.nanoTime(), methodName, componentType, applicationName, moduleName, componentName, threadId, transactionId, securityId);
        flowStack.push(appType);
        this.asyncHandler.handleStartTime(requestId, System.nanoTime(), appType);
    }

    private void storeMethodEndData(String requestId, Throwable exception, FlowStack<ContainerTypeOrApplicationType> flowStack, boolean listenersPresent, long otherStartTime, long otherEndTime) {
        this.asyncHandler.handleEndTime(requestId, System.nanoTime(), flowStack.pop());
        this.asyncHandler.handleMethodEnd(requestId, System.nanoTime(), exception);
        if (listenersPresent) {
            flowStack.push(ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleStartTime(requestId, otherStartTime, ContainerTypeOrApplicationType.OTHER);
            this.asyncHandler.handleEndTime(requestId, otherEndTime, flowStack.pop());
        }
        this.asyncHandler.handleStartTime(requestId, System.nanoTime(), (ContainerTypeOrApplicationType)flowStack.peek());
    }

    private void storeStartTimeData(String requestId, ContainerTypeOrApplicationType type, FlowStack<ContainerTypeOrApplicationType> flowStack) {
        this.asyncHandler.handleEndTime(requestId, System.nanoTime(), (ContainerTypeOrApplicationType)flowStack.peek());
        flowStack.push(type);
        this.asyncHandler.handleStartTime(requestId, System.nanoTime(), type);
    }

    private void storeEndTimeData(String requestId, FlowStack<ContainerTypeOrApplicationType> flowStack) {
        this.asyncHandler.handleEndTime(requestId, System.nanoTime(), flowStack.pop());
        this.asyncHandler.handleStartTime(requestId, System.nanoTime(), (ContainerTypeOrApplicationType)flowStack.peek());
    }

    public ThreadLocalData getThreadLocalData() {
        return threadLocal.get();
    }

    public void registerListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public boolean getStoreData() {
        return this.storeData.get();
    }

    public void setStoreData(boolean value) {
        this.storeData.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEnable(boolean enable) {
        AgentImpl agentImpl = this;
        synchronized (agentImpl) {
            if (enable) {
                this.asyncHandler = AsyncHandlerFactory.getInstance();
                if (this.perfImpl) {
                    this.asyncHandler.enable();
                }
                if (!this.getStoreData()) {
                    boolean result = this.dbAccessObject.enable();
                    if (!result) {
                        logger.log(Level.SEVERE, "callflow.enable_failed");
                        throw new RuntimeException("Callflow Enable\tFailed");
                    }
                    this.enableGrizzly(true);
                    logger.log(Level.INFO, "callflow.enable_succeeded");
                }
            } else {
                this.callerIPAddressFilter = null;
                this.callerPrincipalFilter = null;
                if (this.perfImpl) {
                    if (this.asyncHandler != null) {
                        this.asyncHandler.disable();
                    }
                    this.asyncHandler = null;
                }
                if (this.getStoreData()) {
                    this.enableGrizzly(false);
                    this.dbAccessObject.disable();
                    logger.log(Level.INFO, "callflow.disable_succeeded");
                }
            }
            this.setStoreData(enable);
            return;
        }
    }

    public boolean isEnabled() {
        return this.storeData.get();
    }

    public void enableGrizzly(boolean enable) {
        ArrayList grizzlies = GrizzlyConfig.getGrizzlyConfigInstances();
        for (GrizzlyConfig grizzly : grizzlies) {
            grizzly.setEnableCallFlow(true);
        }
    }

    public void setCallerIPFilter(String ipAddress) {
        this.callerIPAddressFilter = ipAddress;
        if (this.callerIPAddressFilter != null && this.callerIPAddressFilter.equals("")) {
            this.callerIPAddressFilter = null;
        }
    }

    public String getCallerIPFilter() {
        return this.callerIPAddressFilter;
    }

    public void setCallerPrincipalFilter(String callerPrincipal) {
        this.callerPrincipalFilter = callerPrincipal;
        if (this.callerPrincipalFilter != null && this.callerPrincipalFilter.equals("")) {
            this.callerPrincipalFilter = null;
        }
    }

    public String getCallerPrincipalFilter() {
        return this.callerPrincipalFilter;
    }

    public void clearData() {
        if (!this.getStoreData()) {
            this.dbAccessObject.clearData();
        } else {
            logger.log(Level.WARNING, "callflow.turn_off_callflow_before_clearData");
        }
    }

    public boolean deleteRequestIds(String[] requestIds) {
        return this.dbAccessObject.deleteRequestIds(requestIds);
    }

    public List<Map<String, String>> getRequestInformation() {
        if (this.asyncHandler != null) {
            this.asyncHandler.flush();
        }
        return this.dbAccessObject.getRequestInformation();
    }

    public List<Map<String, String>> getCallStackForRequest(String requestId) {
        return this.dbAccessObject.getCallStackInformation(requestId);
    }

    public Map<String, String> getPieInformation(String requestID) {
        return this.dbAccessObject.getPieInformation(requestID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FlowStack<E>
    extends LinkedList<E> {
        FlowStack() {
        }

        @Override
        public void push(E e) {
            this.addFirst(e);
        }

        @Override
        public E pop() {
            return this.removeFirst();
        }
    }

    static class RequestData {
        private RequestType requestType;
        private long requestStartTime;
        private long requestStartTimeMillis;
        private String callerIPAddress;
        private String remoteUser;

        RequestData() {
        }

        RequestType getRequestType() {
            return this.requestType;
        }

        void setRequestType(RequestType requestType) {
            this.requestType = requestType;
        }

        long getRequestStartTime() {
            return this.requestStartTime;
        }

        void setRequestStartTime(long requestStartTime) {
            this.requestStartTime = requestStartTime;
        }

        long getRequestStartTimeMillis() {
            return this.requestStartTimeMillis;
        }

        void setRequestStartTimeMillis(long requestStartTimeMillis) {
            this.requestStartTimeMillis = requestStartTimeMillis;
        }

        String getCallerIPAddress() {
            return this.callerIPAddress;
        }

        void setCallerIPAddress(String callerIPAddress) {
            this.callerIPAddress = callerIPAddress;
        }

        String getRemoteUser() {
            return this.remoteUser;
        }

        void setRemoteUser(String remoteUser) {
            this.remoteUser = remoteUser;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalState
    implements ThreadLocalData {
        private String requestId = UUID.randomUUID().toString();
        private boolean initialized = false;
        private boolean storeData = false;
        private String methodName;
        private String componentType;
        private String applicationName;
        private String moduleName;
        private String componentName;
        private String transactionId;
        private String securityId;
        private RequestData requestData = new RequestData();
        private FlowStack<ContainerTypeOrApplicationType> flowStack = new FlowStack();

        ThreadLocalState() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        boolean getInitialized() {
            return this.initialized;
        }

        void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        boolean getStoreData() {
            return this.storeData;
        }

        void setStoreData(boolean storeData) {
            this.storeData = storeData;
        }

        public String getMethodName() {
            return this.methodName;
        }

        void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getComponentName() {
            return this.componentName;
        }

        void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public String getComponentType() {
            return this.componentType;
        }

        void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public String getSecurityId() {
            return this.securityId;
        }

        void setSecurityId(String securityId) {
            this.securityId = securityId;
        }

        RequestData getRequestData() {
            return this.requestData;
        }

        FlowStack<ContainerTypeOrApplicationType> getFlowStack() {
            return this.flowStack;
        }
    }
}

