/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTableAccessObject
implements TableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String SYSTEM_PROPERTY = "com.sun.enterprise.callflow.trace";
    public boolean traceOn = System.getProperty("com.sun.enterprise.callflow.trace", "false").equals("true");
    private static final String TABLE_EXISTS_SQL_ERROR_CODE = "X0Y32";
    Connection con = null;
    String tableName = null;
    private static final String DEFAULT_SERVER_NAME = "server";
    private long totalEntriesProcessed = 0L;
    private String name = "AbstractTableAccessObject";
    private static final String INVALID_TABLE_NAME_CHARACTER_DASH = "-";
    private static final String INVALID_TABLE_NAME_CHARACTER_DOT = ".";
    private static final String INVALID_TABLE_NAME_REPLACEMENT_STRING = "___";
    private static final String OVERRIDE_DEFAULT_REPLACEMENT_STRING = "com.sun.enterprise.callflow.replacementstring";

    public abstract boolean createTable(Connection var1);

    public abstract boolean dropTable(Connection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createStatmentAndExecuteUpdate(String oldsql, String tableNameWithoutServerInstance) {
        String sql = this.updateSqlWithTableName(oldsql, tableNameWithoutServerInstance);
        boolean result = false;
        Statement stmt = null;
        try {
            if (this.con != null) {
                stmt = this.con.createStatement();
                stmt.executeUpdate(sql);
                result = true;
            }
        }
        catch (SQLException se) {
            logger.log(Level.WARNING, "Error accessing CallFlow tables!", se);
            result = false;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException s) {}
            }
            stmt = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createTable(String oldsql, String tableNameWithoutServerInstance) {
        String sql = this.updateSqlWithTableName(oldsql, tableNameWithoutServerInstance);
        boolean result = false;
        Statement stmt = null;
        try {
            if (this.con != null) {
                stmt = this.con.createStatement();
                stmt.executeUpdate(sql);
                result = true;
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase(TABLE_EXISTS_SQL_ERROR_CODE)) {
                logger.log(Level.FINE, "callflow.table_already_exists_error", tableNameWithoutServerInstance);
            } else {
                logger.log(Level.WARNING, "callflow.table_creation_error", tableNameWithoutServerInstance);
                logger.log(Level.WARNING, "callflow.table_creation_error", se);
            }
            result = true;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException s) {}
            }
            stmt = null;
        }
        return result;
    }

    public String getServerInstanceName() {
        String server = DEFAULT_SERVER_NAME;
        ServerContext sc = ApplicationServer.getServerContext();
        if (sc != null) {
            server = this.removeInvalidCharactersFromTableName(sc.getInstanceName());
        }
        return "__" + server;
    }

    public String removeInvalidCharactersFromTableName(String instanceName) {
        String overrideString = null;
        overrideString = System.getProperty(OVERRIDE_DEFAULT_REPLACEMENT_STRING);
        if (overrideString == null) {
            overrideString = INVALID_TABLE_NAME_REPLACEMENT_STRING;
        }
        String tmp = instanceName.replace(INVALID_TABLE_NAME_CHARACTER_DOT, overrideString);
        String modifiedInstanceName = tmp.replace(INVALID_TABLE_NAME_CHARACTER_DASH, overrideString);
        return modifiedInstanceName;
    }

    String updateSqlWithTableName(String oldsql, String table) {
        String newsql = new String(oldsql);
        newsql = newsql.replaceAll(table, this.tableName);
        return newsql;
    }

    public boolean delete(PreparedStatement pstmt, String[] requestId) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < requestId.length; ++i) {
                pstmt.setString(1, requestId[i]);
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            boolean bl = result = updated.length == requestId.length;
            if (!result) {
                logger.log(Level.WARNING, "callflow.error_delete_row");
            }
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.WARNING, "callflow.error_delete_row");
            logger.log(Level.FINE, "Error data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.WARNING, "callflow.error_delete_row");
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public long getTotalEntriesProcessed() {
        return this.totalEntriesProcessed;
    }

    public void addTotalEntriesProcessed(int totalEntriesProcessed) {
        this.totalEntriesProcessed += (long)totalEntriesProcessed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

