/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.decorator.hssf.DecoratesHssf;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.render.TableWriterAdapter;

public class HssfTableWriter
extends TableWriterAdapter {
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private int rowNum;
    private HSSFRow currentRow;
    private int colNum;
    private HSSFCell currentCell;
    private short pctFormat = HSSFDataFormat.getBuiltinFormat((String)"0.00%");

    public HssfTableWriter(HSSFWorkbook wb) {
        this.wb = wb;
    }

    protected void writeTableOpener(TableModel model) throws Exception {
        this.sheet = this.wb.createSheet("-");
        this.rowNum = 0;
    }

    protected void writeCaption(TableModel model) throws Exception {
        HSSFCellStyle style = this.wb.createCellStyle();
        HSSFFont bold = this.wb.createFont();
        bold.setBoldweight((short)700);
        bold.setFontHeightInPoints((short)14);
        style.setFont(bold);
        style.setAlignment((short)2);
        this.colNum = 0;
        this.currentRow = this.sheet.createRow(this.rowNum++);
        this.currentCell = this.currentRow.createCell((short)this.colNum);
        this.currentCell.setCellStyle(style);
        String caption = model.getCaption();
        this.currentCell.setCellValue(caption);
        this.rowSpanTable(model);
    }

    private Region getMergeCellsRegion(short first, short last) {
        return new Region(this.currentRow.getRowNum(), first, this.currentRow.getRowNum(), last);
    }

    protected void writeTableHeader(TableModel model) throws Exception {
        this.currentRow = this.sheet.createRow(this.rowNum++);
        this.colNum = 0;
        HSSFCellStyle headerStyle = this.getHeaderFooterStyle();
        Iterator iterator = model.getHeaderCellList().iterator();
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            this.writeHeaderFooter(columnHeader, this.currentRow, headerStyle);
        }
    }

    protected void writeDecoratedRowStart(TableModel model) {
        model.getTableDecorator().startRow();
    }

    protected void writeRowOpener(Row row) throws Exception {
        this.currentRow = this.sheet.createRow(this.rowNum++);
        this.colNum = 0;
    }

    protected void writeColumnOpener(Column column) throws Exception {
        column.getOpenTag();
        this.currentCell = this.currentRow.createCell((short)this.colNum++);
        this.currentCell.setEncoding((short)1);
    }

    protected void writeColumnValue(Object value, Column column) throws Exception {
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value.toString().indexOf("%") > -1) {
                this.currentCell.setCellValue(num.doubleValue() / 100.0);
                HSSFCellStyle cellStyle = this.wb.createCellStyle();
                cellStyle.setDataFormat(this.pctFormat);
                this.currentCell.setCellStyle(cellStyle);
            } else {
                this.currentCell.setCellValue(num.doubleValue());
            }
        } else if (value instanceof Date) {
            this.currentCell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            this.currentCell.setCellValue((Calendar)value);
        } else {
            this.currentCell.setCellValue(this.escapeColumnValue(value));
        }
    }

    protected void writeDecoratedRowFinish(TableModel model) throws Exception {
        TableDecorator decorator = model.getTableDecorator();
        if (decorator instanceof DecoratesHssf) {
            DecoratesHssf hdecorator = (DecoratesHssf)decorator;
            hdecorator.setSheet(this.sheet);
        }
        decorator.finishRow();
        this.rowNum = this.sheet.getLastRowNum();
        ++this.rowNum;
    }

    protected void writePostBodyFooter(TableModel model) throws Exception {
        this.colNum = 0;
        this.currentRow = this.sheet.createRow(this.rowNum++);
        this.writeHeaderFooter(model.getFooter(), this.currentRow, this.getHeaderFooterStyle());
        this.rowSpanTable(model);
    }

    private void rowSpanTable(TableModel model) {
        this.sheet.addMergedRegion(this.getMergeCellsRegion(this.currentCell.getCellNum(), (short)(model.getNumberOfColumns() - 1)));
    }

    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    protected String escapeColumnValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        String returnString = ObjectUtils.toString((Object)rawValue);
        returnString = StringEscapeUtils.escapeJava((String)StringUtils.trimToEmpty((String)returnString));
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\t", (String)"    ");
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\r", (String)" ");
        returnString = StringEscapeUtils.unescapeJava((String)returnString);
        return returnString;
    }

    protected boolean isNumber(String rawValue) {
        if (rawValue == null) {
            return false;
        }
        String rawV = rawValue;
        if (rawV.indexOf(37) > -1) {
            rawV = rawV.replace('%', ' ').trim();
        }
        if (rawV.indexOf(36) > -1) {
            rawV = rawV.replace('$', ' ').trim();
        }
        if (rawV.indexOf(44) > -1) {
            rawV = StringUtils.replace((String)rawV, (String)",", (String)"");
        }
        return NumberUtils.isNumber((String)rawV.trim());
    }

    private void writeHeaderFooter(String value, HSSFRow row, HSSFCellStyle style) {
        this.currentCell = row.createCell((short)this.colNum++);
        this.currentCell.setCellValue(value);
        this.currentCell.setCellStyle(style);
        this.currentCell.setEncoding((short)1);
    }

    private HSSFCellStyle getHeaderFooterStyle() {
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setFillPattern((short)2);
        style.setFillBackgroundColor((short)54);
        HSSFFont bold = this.wb.createFont();
        bold.setBoldweight((short)700);
        bold.setColor((short)9);
        style.setFont(bold);
        return style;
    }
}

