/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ClassLoading {
    private static final Map<String, Class> PRIMITIVES = new HashMap<String, Class>();
    private static final Map<Class, String> VM_PRIMITIVES_REVERSE = new HashMap<Class, String>();
    private static final Map<String, Class> VM_PRIMITIVES = new HashMap<String, Class>();
    private static final Map<Class, Class> PRIMITIVE_WRAPPERS = new HashMap<Class, Class>();

    private ClassLoading() {
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        try {
            return ClassLoading.load(className, classLoader);
        }
        catch (ClassNotFoundException ignore) {
            Class type = null;
            type = ClassLoading.getPrimitiveType(className);
            if (type != null) {
                return type;
            }
            type = ClassLoading.getVMPrimitiveType(className);
            if (type != null) {
                return type;
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                String name = className.substring(1, className.length() - 1);
                return ClassLoading.load(name, classLoader);
            }
            if (className.charAt(0) == '[') {
                int arrayDimension = className.lastIndexOf(91) + 1;
                String componentClassName = className.substring(arrayDimension, className.length());
                type = ClassLoading.loadClass(componentClassName, classLoader);
                int[] dim = new int[arrayDimension];
                Arrays.fill(dim, 0);
                return Array.newInstance(type, dim).getClass();
            }
            if (className.endsWith("[]")) {
                int arrayDimension = 0;
                String componentClassName = className;
                while (componentClassName.endsWith("[]")) {
                    componentClassName = componentClassName.substring(0, componentClassName.length() - 2);
                    ++arrayDimension;
                }
                type = ClassLoading.loadClass(componentClassName, classLoader);
                int[] dim = new int[arrayDimension];
                Arrays.fill(dim, 0);
                return Array.newInstance(type, dim).getClass();
            }
            throw new ClassNotFoundException(className);
        }
    }

    private static Class load(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    public static String getClassName(Class clazz) {
        StringBuffer rc = new StringBuffer();
        while (clazz.isArray()) {
            rc.append('[');
            clazz = clazz.getComponentType();
        }
        if (!clazz.isPrimitive()) {
            rc.append('L');
            rc.append(clazz.getName());
            rc.append(';');
        } else {
            rc.append(VM_PRIMITIVES_REVERSE.get(clazz));
        }
        return rc.toString();
    }

    private static Class getPrimitiveType(String name) {
        return PRIMITIVES.get(name);
    }

    private static Class getVMPrimitiveType(String name) {
        return VM_PRIMITIVES.get(name);
    }

    static {
        PRIMITIVES.put("boolean", Boolean.TYPE);
        PRIMITIVES.put("byte", Byte.TYPE);
        PRIMITIVES.put("char", Character.TYPE);
        PRIMITIVES.put("short", Short.TYPE);
        PRIMITIVES.put("int", Integer.TYPE);
        PRIMITIVES.put("long", Long.TYPE);
        PRIMITIVES.put("float", Float.TYPE);
        PRIMITIVES.put("double", Double.TYPE);
        PRIMITIVES.put("void", Void.TYPE);
        VM_PRIMITIVES.put("B", Byte.TYPE);
        VM_PRIMITIVES.put("C", Character.TYPE);
        VM_PRIMITIVES.put("D", Double.TYPE);
        VM_PRIMITIVES.put("F", Float.TYPE);
        VM_PRIMITIVES.put("I", Integer.TYPE);
        VM_PRIMITIVES.put("J", Long.TYPE);
        VM_PRIMITIVES.put("S", Short.TYPE);
        VM_PRIMITIVES.put("Z", Boolean.TYPE);
        VM_PRIMITIVES.put("V", Void.TYPE);
        VM_PRIMITIVES_REVERSE.put(Byte.TYPE, "B");
        VM_PRIMITIVES_REVERSE.put(Character.TYPE, "C");
        VM_PRIMITIVES_REVERSE.put(Double.TYPE, "D");
        VM_PRIMITIVES_REVERSE.put(Float.TYPE, "F");
        VM_PRIMITIVES_REVERSE.put(Integer.TYPE, "I");
        VM_PRIMITIVES_REVERSE.put(Long.TYPE, "J");
        VM_PRIMITIVES_REVERSE.put(Short.TYPE, "S");
        VM_PRIMITIVES_REVERSE.put(Boolean.TYPE, "Z");
        VM_PRIMITIVES_REVERSE.put(Void.TYPE, "V");
        PRIMITIVE_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPERS.put(Void.TYPE, Void.class);
    }
}

