/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.state.Tracked;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverTransport
implements CompositeTransport {
    private static final Log LOG = LogFactory.getLog(FailoverTransport.class);
    private TransportListener transportListener;
    private boolean disposed;
    private final CopyOnWriteArrayList<URI> uris = new CopyOnWriteArrayList();
    private final Object reconnectMutex = new Object();
    private final Object sleepMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final ConcurrentHashMap<Integer, Command> requestMap = new ConcurrentHashMap();
    private URI connectedTransportURI;
    private Transport connectedTransport;
    private final TaskRunner reconnectTask;
    private boolean started;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private boolean randomize = true;
    private boolean initialized;
    private int maxReconnectAttempts;
    private int connectFailures;
    private long reconnectDelay = this.initialReconnectDelay;
    private Exception connectionFailure;
    private final TransportListener myTransportListener = this.createTransportListener();

    public FailoverTransport() throws InterruptedIOException {
        this.stateTracker.setTrackTransactions(true);
        this.reconnectTask = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean iterate() {
                Exception failure = null;
                Object object = FailoverTransport.this.reconnectMutex;
                synchronized (object) {
                    if (FailoverTransport.this.disposed || FailoverTransport.this.connectionFailure != null) {
                        FailoverTransport.this.reconnectMutex.notifyAll();
                    }
                    if (FailoverTransport.this.connectedTransport != null || FailoverTransport.this.disposed || FailoverTransport.this.connectionFailure != null) {
                        return false;
                    }
                    ArrayList connectList = FailoverTransport.this.getConnectList();
                    if (connectList.isEmpty()) {
                        failure = new IOException("No uris available to connect to.");
                    } else {
                        if (!FailoverTransport.this.useExponentialBackOff) {
                            FailoverTransport.this.reconnectDelay = FailoverTransport.this.initialReconnectDelay;
                        }
                        Iterator iter = connectList.iterator();
                        int i = 0;
                        while (iter.hasNext() && FailoverTransport.this.connectedTransport == null && !FailoverTransport.this.disposed) {
                            URI uri = (URI)iter.next();
                            try {
                                LOG.debug((Object)("Attempting connect to: " + uri));
                                Transport t = TransportFactory.compositeConnect(uri);
                                t.setTransportListener(FailoverTransport.this.myTransportListener);
                                t.start();
                                if (FailoverTransport.this.started) {
                                    FailoverTransport.this.restoreTransport(t);
                                }
                                LOG.debug((Object)"Connection established");
                                FailoverTransport.this.reconnectDelay = FailoverTransport.this.initialReconnectDelay;
                                FailoverTransport.this.connectedTransportURI = uri;
                                FailoverTransport.this.connectedTransport = t;
                                FailoverTransport.this.reconnectMutex.notifyAll();
                                FailoverTransport.this.connectFailures = 0;
                                if (FailoverTransport.this.transportListener != null) {
                                    FailoverTransport.this.transportListener.transportResumed();
                                }
                                LOG.info((Object)("Successfully reconnected to " + uri));
                                return false;
                            }
                            catch (Exception e) {
                                failure = e;
                                LOG.debug((Object)("Connect fail to: " + uri + ", reason: " + e));
                                ++i;
                            }
                        }
                    }
                    if (FailoverTransport.this.maxReconnectAttempts > 0 && ++FailoverTransport.this.connectFailures >= FailoverTransport.this.maxReconnectAttempts) {
                        LOG.error((Object)("Failed to connect to transport after: " + FailoverTransport.this.connectFailures + " attempt(s)"));
                        FailoverTransport.this.connectionFailure = failure;
                        FailoverTransport.this.reconnectMutex.notifyAll();
                        return false;
                    }
                }
                if (!FailoverTransport.this.disposed) {
                    LOG.debug((Object)("Waiting " + FailoverTransport.this.reconnectDelay + " ms before attempting connection. "));
                    object = FailoverTransport.this.sleepMutex;
                    synchronized (object) {
                        try {
                            FailoverTransport.this.sleepMutex.wait(FailoverTransport.this.reconnectDelay);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (FailoverTransport.this.useExponentialBackOff) {
                        FailoverTransport.this.reconnectDelay *= FailoverTransport.this.backOffMultiplier;
                        if (FailoverTransport.this.reconnectDelay > FailoverTransport.this.maxReconnectDelay) {
                            FailoverTransport.this.reconnectDelay = FailoverTransport.this.maxReconnectDelay;
                        }
                    }
                }
                return !FailoverTransport.this.disposed;
            }
        }, "ActiveMQ Failover Worker: " + System.identityHashCode(this));
    }

    TransportListener createTransportListener() {
        return new TransportListener(){

            public void onCommand(Object o) {
                Object object;
                Command command = (Command)o;
                if (command == null) {
                    return;
                }
                if (command.isResponse() && (object = FailoverTransport.this.requestMap.remove(((Response)command).getCorrelationId())) != null && object.getClass() == Tracked.class) {
                    ((Tracked)object).onResponses();
                }
                if (!FailoverTransport.this.initialized && command.isBrokerInfo()) {
                    BrokerInfo info = (BrokerInfo)command;
                    BrokerInfo[] peers = info.getPeerBrokerInfos();
                    if (peers != null) {
                        for (int i = 0; i < peers.length; ++i) {
                            String brokerString = peers[i].getBrokerURL();
                            FailoverTransport.this.add(brokerString);
                        }
                    }
                    FailoverTransport.this.initialized = true;
                }
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.onCommand(command);
                }
            }

            public void onException(IOException error) {
                try {
                    FailoverTransport.this.handleTransportFailure(error);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    FailoverTransport.this.transportListener.onException(new InterruptedIOException());
                }
            }

            public void transportInterupted() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportInterupted();
                }
            }

            public void transportResumed() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportResumed();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleTransportFailure(IOException e) throws InterruptedException {
        if (this.transportListener != null) {
            this.transportListener.transportInterupted();
        }
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.warn((Object)("Transport failed, attempting to automatically reconnect due to: " + e), (Throwable)e);
            if (this.connectedTransport != null) {
                this.initialized = false;
                ServiceSupport.dispose(this.connectedTransport);
                this.connectedTransport = null;
                this.connectedTransportURI = null;
            }
            this.reconnectTask.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.debug((Object)"Started.");
            if (this.started) {
                return;
            }
            this.started = true;
            if (this.connectedTransport != null) {
                this.stateTracker.restore(this.connectedTransport);
            } else {
                this.reconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Transport transportToStop = null;
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.debug((Object)"Stopped.");
            if (!this.started) {
                return;
            }
            this.started = false;
            this.disposed = true;
            if (this.connectedTransport != null) {
                transportToStop = this.connectedTransport;
                this.connectedTransport = null;
            }
            this.reconnectMutex.notifyAll();
        }
        object = this.sleepMutex;
        synchronized (object) {
            this.sleepMutex.notifyAll();
        }
        this.reconnectTask.shutdown();
        if (transportToStop != null) {
            transportToStop.stop();
        }
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public long getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(long reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public Transport getConnectedTransport() {
        return this.connectedTransport;
    }

    public URI getConnectedTransportURI() {
        return this.connectedTransportURI;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        Exception error = null;
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                int i = 0;
                while (!this.disposed) {
                    try {
                        block20: {
                            while (this.connectedTransport == null && !this.disposed && this.connectionFailure == null) {
                                LOG.trace((Object)"Waiting for transport to reconnect.");
                                try {
                                    this.reconnectMutex.wait(1000L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    LOG.debug((Object)("Interupted: " + e), (Throwable)e);
                                }
                            }
                            if (this.connectedTransport == null) {
                                error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : new IOException("Unexpected failure."));
                                break;
                            }
                            Tracked tracked = this.stateTracker.track(command);
                            if (tracked != null && tracked.isWaitingForResponse()) {
                                this.requestMap.put(command.getCommandId(), tracked);
                            } else if (tracked == null && command.isResponseRequired()) {
                                this.requestMap.put(command.getCommandId(), command);
                            }
                            try {
                                this.connectedTransport.oneway(command);
                            }
                            catch (IOException e) {
                                if (tracked != null) break block20;
                                if (command.isResponseRequired()) {
                                    this.requestMap.remove(command.getCommandId());
                                }
                                throw e;
                            }
                        }
                        return;
                    }
                    catch (IOException e) {
                        LOG.debug((Object)("Send oneway attempt: " + i + " failed."));
                        this.handleTransportFailure(e);
                        ++i;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        if (!this.disposed && error != null) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            throw IOExceptionSupport.create(error);
        }
    }

    @Override
    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public void add(URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            if (this.uris.contains(u[i])) continue;
            this.uris.add(u[i]);
        }
        this.reconnect();
    }

    @Override
    public void remove(URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            this.uris.remove(u[i]);
        }
        this.reconnect();
    }

    public void add(String u) {
        try {
            URI uri = new URI(u);
            if (!this.uris.contains(uri)) {
                this.uris.add(uri);
            }
            this.reconnect();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to parse URI: " + u));
        }
    }

    public void reconnect() {
        LOG.debug((Object)"Waking up reconnect task");
        try {
            this.reconnectTask.wakeup();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ArrayList<Object> getConnectList() {
        ArrayList<Object> l = new ArrayList<Object>(this.uris);
        if (this.randomize) {
            Random r = new Random();
            r.setSeed(System.currentTimeMillis());
            for (int i = 0; i < l.size(); ++i) {
                int p = r.nextInt(l.size());
                Object t = l.get(p);
                l.set(p, l.get(i));
                l.set(i, t);
            }
        }
        return l;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    @Override
    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T narrow(Class<T> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return target.cast(this);
        }
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.connectedTransport != null) {
                return this.connectedTransport.narrow(target);
            }
        }
        return null;
    }

    protected void restoreTransport(Transport t) throws Exception, IOException {
        t.start();
        this.stateTracker.restore(t);
        for (Command command : this.requestMap.values()) {
            t.oneway(command);
        }
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String toString() {
        return this.connectedTransportURI == null ? "unconnected" : this.connectedTransportURI.toString();
    }

    @Override
    public String getRemoteAddress() {
        if (this.connectedTransport != null) {
            return this.connectedTransport.getRemoteAddress();
        }
        return null;
    }

    @Override
    public boolean isFaultTolerant() {
        return true;
    }
}

