/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportLogger
extends TransportFilter {
    private static int lastId;
    private final Log log;

    public TransportLogger(Transport next) {
        this(next, LogFactory.getLog((String)(TransportLogger.class.getName() + ".Connection:" + TransportLogger.getNextId())));
    }

    public TransportLogger(Transport next, Log log) {
        super(next);
        this.log = log;
    }

    private static synchronized int getNextId() {
        return ++lastId;
    }

    public Object request(Object command) throws IOException {
        this.log.debug((Object)("SENDING REQUEST: " + command));
        Object rc = super.request(command);
        this.log.debug((Object)("GOT RESPONSE: " + rc));
        return rc;
    }

    public Object request(Object command, int timeout) throws IOException {
        this.log.debug((Object)("SENDING REQUEST: " + command));
        Object rc = super.request(command, timeout);
        this.log.debug((Object)("GOT RESPONSE: " + rc));
        return rc;
    }

    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        this.log.debug((Object)("SENDING ASNYC REQUEST: " + command));
        FutureResponse rc = this.next.asyncRequest(command, responseCallback);
        return rc;
    }

    public void oneway(Object command) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("SENDING: " + command));
        }
        this.next.oneway(command);
    }

    public void onCommand(Object command) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RECEIVED: " + command));
        }
        this.getTransportListener().onCommand(command);
    }

    public void onException(IOException error) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RECEIVED Exception: " + error), (Throwable)error);
        }
        this.getTransportListener().onException(error);
    }

    public String toString() {
        return this.next.toString();
    }
}

