/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.tree;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.Index;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.tree.TreeEntry;
import org.apache.activemq.kaha.impl.index.tree.TreePage;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LRUCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeIndex
implements Index {
    private static final String NAME_PREFIX = "tree-index-";
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_KEY_SIZE;
    private static final Log LOG;
    private final String name;
    private File directory;
    private File file;
    private RandomAccessFile indexFile;
    private IndexManager indexManager;
    private int pageSize = DEFAULT_PAGE_SIZE;
    private int keySize = DEFAULT_KEY_SIZE;
    private int keysPerPage = this.pageSize / this.keySize;
    private TreePage root;
    private LRUCache<Long, TreePage> pageCache;
    private DataByteArrayInputStream dataIn;
    private DataByteArrayOutputStream dataOut;
    private byte[] readBuffer;
    private Marshaller keyMarshaller;
    private long length;
    private TreePage firstFree;
    private TreePage lastFree;
    private AtomicBoolean loaded = new AtomicBoolean();
    private boolean enablePageCaching = true;
    private int pageCacheSize = 10;

    public TreeIndex(File directory, String name, IndexManager indexManager) throws IOException {
        this.directory = directory;
        this.name = name;
        this.indexManager = indexManager;
        this.pageCache = new LRUCache(this.pageCacheSize, this.pageCacheSize, 0.75f, true);
        this.openIndexFile();
    }

    public void setKeyMarshaller(Marshaller marshaller) {
        this.keyMarshaller = marshaller;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
        if (this.loaded.get()) {
            throw new RuntimeException("Pages already loaded - can't reset key size");
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.loaded.get() && pageSize != this.pageSize) {
            throw new RuntimeException("Pages already loaded - can't reset page size");
        }
        this.pageSize = pageSize;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isEnablePageCaching() {
        return this.enablePageCaching;
    }

    public void setEnablePageCaching(boolean enablePageCaching) {
        this.enablePageCaching = enablePageCaching;
    }

    public int getPageCacheSize() {
        return this.pageCacheSize;
    }

    public void setPageCacheSize(int pageCacheSize) {
        this.pageCacheSize = pageCacheSize;
        this.pageCache.setMaxCacheSize(pageCacheSize);
    }

    public void load() {
        if (this.loaded.compareAndSet(false, true)) {
            this.keysPerPage = this.pageSize / this.keySize;
            this.dataIn = new DataByteArrayInputStream();
            this.dataOut = new DataByteArrayOutputStream(this.pageSize);
            this.readBuffer = new byte[this.pageSize];
            try {
                this.openIndexFile();
                long offset = 0L;
                while (offset + (long)this.pageSize <= this.indexFile.length()) {
                    this.indexFile.seek(offset);
                    this.indexFile.readFully(this.readBuffer, 0, 18);
                    this.dataIn.restart(this.readBuffer);
                    TreePage page = new TreePage(this.keysPerPage);
                    page.setTree(this);
                    page.setId(offset);
                    page.readHeader(this.dataIn);
                    if (!page.isActive()) {
                        if (this.lastFree != null) {
                            this.lastFree.setNextFreePageId(offset);
                            this.indexFile.seek(this.lastFree.getId());
                            this.dataOut.reset();
                            this.lastFree.writeHeader(this.dataOut);
                            this.indexFile.write(this.dataOut.getData(), 0, 18);
                            this.lastFree = page;
                        } else {
                            this.lastFree = page;
                            this.firstFree = page;
                        }
                    } else if (this.root == null && page.isRoot()) {
                        this.root = this.getFullPage(offset);
                    }
                    offset += (long)this.pageSize;
                }
                this.length = offset;
                if (this.root == null) {
                    this.root = this.createRoot();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to load index ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void unload() throws IOException {
        if (this.loaded.compareAndSet(true, false) && this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
            this.pageCache.clear();
            this.root = null;
            this.firstFree = null;
            this.lastFree = null;
        }
    }

    public void store(Object key, StoreEntry value) throws IOException {
        TreeEntry entry = new TreeEntry();
        entry.setKey((Comparable)key);
        entry.setIndexOffset(value.getOffset());
        this.root.put(entry);
    }

    public StoreEntry get(Object key) throws IOException {
        TreeEntry entry = new TreeEntry();
        entry.setKey((Comparable)key);
        TreeEntry result = this.root.find(entry);
        return result != null ? this.indexManager.getIndex(result.getIndexOffset()) : null;
    }

    public StoreEntry remove(Object key) throws IOException {
        TreeEntry entry = new TreeEntry();
        entry.setKey((Comparable)key);
        TreeEntry result = this.root.remove(entry);
        return result != null ? this.indexManager.getIndex(result.getIndexOffset()) : null;
    }

    public boolean containsKey(Object key) throws IOException {
        TreeEntry entry = new TreeEntry();
        entry.setKey((Comparable)key);
        return this.root.find(entry) != null;
    }

    public void clear() throws IOException {
        this.unload();
        this.delete();
        this.openIndexFile();
        this.load();
    }

    public void delete() throws IOException {
        this.unload();
        if (this.file.exists()) {
            boolean bl = this.file.delete();
        }
        this.length = 0L;
    }

    TreePage getRoot() {
        return this.root;
    }

    TreePage lookupPage(long pageId) throws IOException {
        TreePage result = null;
        if (pageId >= 0L) {
            result = this.root != null && this.root.getId() == pageId ? this.root : this.getFromCache(pageId);
            if (result == null && (result = this.getFullPage(pageId)) != null) {
                if (result.isActive()) {
                    this.addToCache(result);
                } else {
                    throw new IllegalStateException("Trying to access an inactive page: " + pageId + " root is " + this.root);
                }
            }
        }
        return result;
    }

    TreePage createRoot() throws IOException {
        TreePage result;
        this.root = result = this.createPage(-1L);
        return result;
    }

    TreePage createPage(long parentId) throws IOException {
        TreePage result = this.getNextFreePage();
        if (result == null) {
            result = new TreePage(this.keysPerPage);
            result.setId(this.length);
            result.setTree(this);
            result.setParentId(parentId);
            this.writePage(result);
            this.length += (long)this.pageSize;
            this.indexFile.seek(this.length);
            this.indexFile.write(-1);
        }
        this.addToCache(result);
        return result;
    }

    void releasePage(TreePage page) throws IOException {
        this.removeFromCache(page);
        page.reset();
        page.setActive(false);
        if (this.lastFree == null) {
            this.firstFree = page;
            this.lastFree = page;
        } else {
            this.lastFree.setNextFreePageId(page.getId());
            this.writePage(this.lastFree);
        }
        this.writePage(page);
    }

    private TreePage getNextFreePage() throws IOException {
        TreePage result = null;
        if (this.firstFree != null) {
            if (this.firstFree.equals(this.lastFree)) {
                result = this.firstFree;
                this.firstFree = null;
                this.lastFree = null;
            } else {
                result = this.firstFree;
                this.firstFree = this.getPage(this.firstFree.getNextFreePageId());
                if (this.firstFree == null) {
                    this.lastFree = null;
                }
            }
            result.setActive(true);
            result.reset();
            result.saveHeader();
        }
        return result;
    }

    void writeFullPage(TreePage page) throws IOException {
        this.dataOut.reset();
        page.write(this.keyMarshaller, this.dataOut);
        if (this.dataOut.size() > this.pageSize) {
            throw new IOException("Page Size overflow: pageSize is " + this.pageSize + " trying to write " + this.dataOut.size());
        }
        this.indexFile.seek(page.getId());
        this.indexFile.write(this.dataOut.getData(), 0, this.dataOut.size());
    }

    void writePage(TreePage page) throws IOException {
        this.dataOut.reset();
        page.writeHeader(this.dataOut);
        this.indexFile.seek(page.getId());
        this.indexFile.write(this.dataOut.getData(), 0, 18);
    }

    TreePage getFullPage(long id) throws IOException {
        this.indexFile.seek(id);
        this.indexFile.readFully(this.readBuffer, 0, this.pageSize);
        this.dataIn.restart(this.readBuffer);
        TreePage page = new TreePage(this.keysPerPage);
        page.setId(id);
        page.setTree(this);
        page.read(this.keyMarshaller, this.dataIn);
        return page;
    }

    TreePage getPage(long id) throws IOException {
        this.indexFile.seek(id);
        this.indexFile.readFully(this.readBuffer, 0, 18);
        this.dataIn.restart(this.readBuffer);
        TreePage page = new TreePage(this.keysPerPage);
        page.setId(id);
        page.setTree(this);
        page.readHeader(this.dataIn);
        return page;
    }

    private TreePage getFromCache(long pageId) {
        TreePage result = null;
        if (this.enablePageCaching) {
            result = (TreePage)this.pageCache.get(pageId);
        }
        return result;
    }

    private void addToCache(TreePage page) {
        if (this.enablePageCaching) {
            this.pageCache.put(page.getId(), page);
        }
    }

    private void removeFromCache(TreePage page) {
        if (this.enablePageCaching) {
            this.pageCache.remove(page.getId());
        }
    }

    protected void openIndexFile() throws IOException {
        if (this.indexFile == null) {
            this.file = new File(this.directory, NAME_PREFIX + IOHelper.toFileSystemSafeName(this.name));
            this.file.getParentFile().mkdirs();
            this.indexFile = new RandomAccessFile(this.file, "rw");
        }
    }

    static {
        LOG = LogFactory.getLog(TreeIndex.class);
        DEFAULT_PAGE_SIZE = Integer.parseInt(System.getProperty("defaultPageSize", "16384"));
        DEFAULT_KEY_SIZE = Integer.parseInt(System.getProperty("defaultKeySize", "96"));
    }
}

