/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.Index;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMIndex
implements Index {
    private static final Log LOG = LogFactory.getLog(VMIndex.class);
    private IndexManager indexManager;
    private Map<Object, StoreEntry> map = new HashMap<Object, StoreEntry>();

    public VMIndex(IndexManager manager) {
        this.indexManager = manager;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public StoreEntry remove(Object key) {
        StoreEntry result = this.map.remove(key);
        if (result != null) {
            try {
                result = this.indexManager.refreshIndex((IndexItem)result);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to refresh entry", (Throwable)e);
                throw new RuntimeException("Failed to refresh entry");
            }
        }
        return result;
    }

    public void store(Object key, StoreEntry entry) {
        this.map.put(key, entry);
    }

    public StoreEntry get(Object key) {
        StoreEntry result = this.map.get(key);
        if (result != null) {
            try {
                result = this.indexManager.refreshIndex((IndexItem)result);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to refresh entry", (Throwable)e);
                throw new RuntimeException("Failed to refresh entry");
            }
        }
        return result;
    }

    public boolean isTransient() {
        return true;
    }

    public void load() {
    }

    public void unload() {
        this.map.clear();
    }

    public void setKeyMarshaller(Marshaller marshaller) {
    }
}

