/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TopicStorePrefetch
extends AbstractPendingMessageCursor
implements MessageRecoveryListener,
UsageListener {
    private static final Log LOG = LogFactory.getLog(TopicStorePrefetch.class);
    private TopicMessageStore store;
    private final LinkedHashMap<MessageId, Message> batchList = new LinkedHashMap();
    private String clientId;
    private String subscriberName;
    private Destination regionDestination;
    private boolean batchResetNeeded = true;
    private boolean storeMayHaveMoreMessages = true;
    private boolean started;
    private final Subscription subscription;

    public TopicStorePrefetch(Topic topic, String clientId, String subscriberName, Subscription subscription) {
        this.regionDestination = topic;
        this.subscription = subscription;
        this.store = (TopicMessageStore)topic.getMessageStore();
        this.clientId = clientId;
        this.subscriberName = subscriberName;
        this.maxProducersToAudit = 32;
        this.maxAuditDepth = 10000;
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.started = true;
            super.start();
            this.getSystemUsage().getMemoryUsage().addUsageListener(this);
            this.safeFillBatch();
        }
    }

    public synchronized void stop() throws Exception {
        if (this.started) {
            this.started = false;
            this.getSystemUsage().getMemoryUsage().removeUsageListener(this);
            super.stop();
            this.store.resetBatching(this.clientId, this.subscriberName);
            this.gc();
        }
    }

    public synchronized boolean isEmpty() {
        this.safeFillBatch();
        return this.batchList.isEmpty();
    }

    public synchronized int size() {
        this.safeFillBatch();
        return this.batchList.size();
    }

    public synchronized void addMessageLast(MessageReference node) throws Exception {
        if (node != null) {
            this.storeMayHaveMoreMessages = true;
            node.decrementReferenceCount();
        }
    }

    public synchronized void addMessageFirst(MessageReference node) throws Exception {
        if (node != null) {
            this.storeMayHaveMoreMessages = true;
            node.decrementReferenceCount();
            this.rollback(node.getMessageId());
        }
    }

    public synchronized void remove() {
    }

    public synchronized void remove(MessageReference node) {
    }

    public synchronized void clear() {
        this.gc();
    }

    public synchronized boolean hasNext() {
        boolean result = !this.isEmpty();
        return result;
    }

    public synchronized MessageReference next() {
        Message result = null;
        this.safeFillBatch();
        if (this.batchList.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<MessageId, Message>> i = this.batchList.entrySet().iterator();
        result = i.next().getValue();
        i.remove();
        result.setRegionDestination(this.regionDestination);
        result.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
        return result;
    }

    public void reset() {
    }

    public void finished() {
    }

    public synchronized boolean recoverMessage(Message message) throws Exception {
        MessageEvaluationContext messageEvaluationContext = new MessageEvaluationContext();
        messageEvaluationContext.setMessageReference(message);
        if (this.subscription.matches(message, messageEvaluationContext)) {
            message.setRegionDestination(this.regionDestination);
            if (!this.isDuplicate(message.getMessageId())) {
                if (message.getReferenceCount() == 0) {
                    message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                    message.incrementReferenceCount();
                }
                this.batchList.put(message.getMessageId(), message);
            } else {
                this.storeMayHaveMoreMessages = true;
            }
        }
        return true;
    }

    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
        throw new RuntimeException("Not supported");
    }

    public synchronized void dispatched(MessageReference message) {
        if (this.audit != null) {
            this.isDuplicate(message.getMessageId());
            Message removed = (Message)this.batchList.remove(message.getMessageId());
            if (removed != null) {
                removed.decrementReferenceCount();
            }
        }
    }

    protected synchronized void safeFillBatch() {
        try {
            this.fillBatch();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to fill batch", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected synchronized void fillBatch() throws Exception {
        if (this.batchResetNeeded) {
            this.store.resetBatching(this.clientId, this.subscriberName);
            this.batchResetNeeded = false;
            this.storeMayHaveMoreMessages = true;
        }
        while (this.batchList.isEmpty() && this.storeMayHaveMoreMessages) {
            this.storeMayHaveMoreMessages = false;
            this.store.recoverNextMessages(this.clientId, this.subscriberName, this.maxBatchSize, this);
            if (this.batchList.isEmpty()) continue;
            this.storeMayHaveMoreMessages = true;
        }
    }

    protected synchronized int getStoreSize() {
        try {
            return this.store.getMessageCount(this.clientId, this.subscriberName);
        }
        catch (IOException e) {
            LOG.error((Object)(this + " Failed to get the outstanding message count from the store"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized void gc() {
        for (Message msg : this.batchList.values()) {
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
        this.batchResetNeeded = true;
    }

    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage && oldPercentUsage >= 90) {
            this.storeMayHaveMoreMessages = true;
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch ", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "TopicStorePrefetch" + System.identityHashCode(this) + "(" + this.clientId + "," + this.subscriberName + ")";
    }
}

