/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class QueueStorePrefetch
extends AbstractPendingMessageCursor
implements MessageRecoveryListener {
    private static final Log LOG = LogFactory.getLog(QueueStorePrefetch.class);
    private MessageStore store;
    private final LinkedList<Message> batchList = new LinkedList();
    private Destination regionDestination;
    private int size;
    private boolean fillBatchDuplicates;

    public QueueStorePrefetch(Queue queue) {
        this.regionDestination = queue;
        this.store = queue.getMessageStore();
    }

    public void start() throws Exception {
        super.start();
        this.store.resetBatching();
    }

    public void stop() throws Exception {
        this.store.resetBatching();
        super.stop();
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public boolean hasMessagesBufferedToDeliver() {
        return !this.batchList.isEmpty();
    }

    public synchronized int size() {
        try {
            this.size = this.store.getMessageCount();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to get message count", (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.size;
    }

    public synchronized void addMessageLast(MessageReference node) throws Exception {
        ++this.size;
    }

    public void addMessageFirst(MessageReference node) throws Exception {
        ++this.size;
    }

    public void remove() {
        --this.size;
    }

    public void remove(MessageReference node) {
        --this.size;
    }

    public synchronized boolean hasNext() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return !this.batchList.isEmpty();
    }

    public synchronized MessageReference next() {
        Message result = this.batchList.removeFirst();
        result.decrementReferenceCount();
        result.setRegionDestination(this.regionDestination);
        result.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
        return result;
    }

    public void reset() {
    }

    public void finished() {
    }

    public synchronized boolean recoverMessage(Message message) throws Exception {
        if (!this.isDuplicate(message.getMessageId())) {
            message.setRegionDestination(this.regionDestination);
            message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
            message.incrementReferenceCount();
            this.batchList.addLast(message);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring batched duplicated from store: " + message));
            }
            this.fillBatchDuplicates = true;
        }
        return true;
    }

    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
        Message msg = this.store.getMessage(messageReference);
        if (msg != null) {
            return this.recoverMessage(msg);
        }
        String err = "Failed to retrieve message for id: " + messageReference;
        LOG.error((Object)err);
        throw new IOException(err);
    }

    public void gc() {
        for (Message msg : this.batchList) {
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
    }

    protected synchronized void fillBatch() throws Exception {
        this.store.recoverNextMessages(this.maxBatchSize, this);
        while (this.fillBatchDuplicates && this.batchList.isEmpty()) {
            this.fillBatchDuplicates = false;
            this.store.recoverNextMessages(this.maxBatchSize, this);
        }
        this.fillBatchDuplicates = false;
    }

    public String toString() {
        return "QueueStorePrefetch" + System.identityHashCode(this);
    }
}

