/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.LinkedList;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.usage.SystemUsage;

public class AbstractPendingMessageCursor
implements PendingMessageCursor {
    protected int memoryUsageHighWaterMark = 90;
    protected int maxBatchSize = 100;
    protected SystemUsage systemUsage;
    protected int maxProducersToAudit = 1024;
    protected int maxAuditDepth = 1;
    protected boolean enableAudit = true;
    protected ActiveMQMessageAudit audit;
    private boolean started = false;

    public synchronized void start() throws Exception {
        if (!this.started && this.enableAudit && this.audit == null) {
            this.audit = new ActiveMQMessageAudit(this.maxAuditDepth, this.maxProducersToAudit);
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        this.audit = null;
        this.gc();
    }

    public void add(ConnectionContext context, Destination destination) throws Exception {
    }

    public void remove(ConnectionContext context, Destination destination) throws Exception {
    }

    public boolean isRecoveryRequired() {
        return true;
    }

    public void addMessageFirst(MessageReference node) throws Exception {
    }

    public void addMessageLast(MessageReference node) throws Exception {
    }

    public void addRecoveredMessage(MessageReference node) throws Exception {
        this.addMessageLast(node);
    }

    public void clear() {
    }

    public boolean hasNext() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isEmpty(Destination destination) {
        return this.isEmpty();
    }

    public MessageReference next() {
        return null;
    }

    public void remove() {
    }

    public void reset() {
    }

    public int size() {
        return 0;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    protected void fillBatch() throws Exception {
    }

    public void resetForGC() {
        this.reset();
    }

    public void remove(MessageReference node) {
    }

    public void gc() {
    }

    public void setSystemUsage(SystemUsage usageManager) {
        this.systemUsage = usageManager;
    }

    public boolean hasSpace() {
        return this.systemUsage != null ? this.systemUsage.getMemoryUsage().getPercentUsage() < this.memoryUsageHighWaterMark : true;
    }

    public boolean isFull() {
        return this.systemUsage != null ? this.systemUsage.getMemoryUsage().isFull() : false;
    }

    public void release() {
    }

    public boolean hasMessagesBufferedToDeliver() {
        return false;
    }

    public int getMemoryUsageHighWaterMark() {
        return this.memoryUsageHighWaterMark;
    }

    public void setMemoryUsageHighWaterMark(int memoryUsageHighWaterMark) {
        this.memoryUsageHighWaterMark = memoryUsageHighWaterMark;
    }

    public SystemUsage getSystemUsage() {
        return this.systemUsage;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public LinkedList pageInList(int maxItems) {
        throw new RuntimeException("Not supported");
    }

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public synchronized void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
        if (this.audit != null) {
            this.audit.setMaximumNumberOfProducersToTrack(maxProducersToAudit);
        }
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public synchronized void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
        if (this.audit != null) {
            this.audit.setAuditDepth(maxAuditDepth);
        }
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public synchronized void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
        if (this.enableAudit && this.started && this.audit == null) {
            this.audit = new ActiveMQMessageAudit(this.maxAuditDepth, this.maxProducersToAudit);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void dispatched(MessageReference message) {
    }

    protected synchronized boolean isDuplicate(MessageId messageId) {
        if (!this.enableAudit || this.audit == null) {
            return false;
        }
        return this.audit.isDuplicate(messageId);
    }

    protected synchronized void rollback(MessageId id) {
        if (this.audit != null) {
            this.audit.rollback(id);
        }
    }
}

