/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PrefetchSubscription
extends AbstractSubscription {
    private static final Log LOG = LogFactory.getLog(PrefetchSubscription.class);
    protected PendingMessageCursor pending;
    protected final List<MessageReference> dispatched = new CopyOnWriteArrayList<MessageReference>();
    protected int prefetchExtension;
    protected long enqueueCounter;
    protected long dispatchCounter;
    protected long dequeueCounter;
    protected boolean optimizedDispatch = true;
    private int maxProducersToAudit = 32;
    private int maxAuditDepth = 2048;
    protected final SystemUsage usageManager;
    protected ActiveMQMessageAudit audit = new ActiveMQMessageAudit();

    public PrefetchSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info, PendingMessageCursor cursor) throws InvalidSelectorException {
        super(broker, context, info);
        this.usageManager = usageManager;
        this.pending = cursor;
    }

    public PrefetchSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this(broker, usageManager, context, info, new VMPendingMessageCursor());
    }

    public synchronized Response pullMessage(ConnectionContext context, MessagePull pull) throws Exception {
        if (this.getPrefetchSize() == 0 && !this.isSlave()) {
            ++this.prefetchExtension;
            final long dispatchCounterBeforePull = this.dispatchCounter;
            this.dispatchMatched();
            if (dispatchCounterBeforePull == this.dispatchCounter) {
                if (pull.getTimeout() == -1L) {
                    this.add(QueueMessageReference.NULL_MESSAGE);
                    this.dispatchMatched();
                }
                if (pull.getTimeout() > 0L) {
                    Scheduler.executeAfterDelay(new Runnable(){

                        public void run() {
                            PrefetchSubscription.this.pullTimeout(dispatchCounterBeforePull);
                        }
                    }, pull.getTimeout());
                }
            }
        }
        return null;
    }

    final synchronized void pullTimeout(long dispatchCounterBeforePull) {
        if (dispatchCounterBeforePull == this.dispatchCounter) {
            try {
                this.add(QueueMessageReference.NULL_MESSAGE);
                this.dispatchMatched();
            }
            catch (Exception e) {
                this.context.getConnection().serviceException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(MessageReference node) throws Exception {
        boolean pendingEmpty = false;
        pendingEmpty = this.pending.isEmpty();
        ++this.enqueueCounter;
        if (this.optimizedDispatch && !this.isFull() && pendingEmpty && !this.isSlave()) {
            this.dispatch(node);
        } else {
            this.optimizePrefetch();
            PendingMessageCursor pendingMessageCursor = this.pending;
            synchronized (pendingMessageCursor) {
                if (this.pending.isEmpty() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Prefetch limit.");
                }
                this.pending.addMessageLast(node);
                this.dispatchMatched();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processMessageDispatchNotification(MessageDispatchNotification mdn) throws Exception {
        try {
            this.pending.reset();
            while (this.pending.hasNext()) {
                MessageReference node = this.pending.next();
                if (!node.getMessageId().equals(mdn.getMessageId())) continue;
                this.pending.remove();
                this.createMessageDispatch(node, node.getMessage());
                this.dispatched.add(node);
                return;
            }
        }
        finally {
            this.pending.release();
        }
        throw new JMSException("Slave broker out of sync with master: Dispatched message (" + mdn.getMessageId() + ") was not in the pending list");
    }

    public synchronized void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        boolean callDispatchMatched = false;
        if (ack.isStandardAck()) {
            int index = 0;
            boolean inAckRange = false;
            ArrayList<MessageReference> removeList = new ArrayList<MessageReference>();
            for (final MessageReference node : this.dispatched) {
                MessageId messageId = node.getMessageId();
                if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                    inAckRange = true;
                }
                if (!inAckRange) continue;
                if (!context.isInTransaction()) {
                    ++this.dequeueCounter;
                    node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                    removeList.add(node);
                } else {
                    context.getTransaction().addSynchronization(new Synchronization(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void afterCommit() throws Exception {
                            PrefetchSubscription prefetchSubscription = PrefetchSubscription.this;
                            synchronized (prefetchSubscription) {
                                ++PrefetchSubscription.this.dequeueCounter;
                                PrefetchSubscription.this.dispatched.remove(node);
                                node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                                --PrefetchSubscription.this.prefetchExtension;
                            }
                        }

                        public void afterRollback() throws Exception {
                            super.afterRollback();
                        }
                    });
                }
                ++index;
                this.acknowledge(context, ack, node);
                if (!ack.getLastMessageId().equals(messageId)) continue;
                if (context.isInTransaction()) {
                    if (this.getPrefetchSize() != 0) {
                        this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                    }
                } else {
                    this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                }
                callDispatchMatched = true;
                break;
            }
            for (final MessageReference node : removeList) {
                this.dispatched.remove(node);
            }
            if (!callDispatchMatched && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Could not correlate acknowledgment with dispatched message: " + ack));
            }
        } else if (ack.isDeliveredAck()) {
            int index = 0;
            for (MessageReference node : this.dispatched) {
                if (ack.getLastMessageId().equals(node.getMessageId())) {
                    this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                    callDispatchMatched = true;
                    break;
                }
                ++index;
            }
            if (!callDispatchMatched) {
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
        } else if (ack.isRedeliveredAck()) {
            boolean inAckRange = false;
            for (MessageReference node : this.dispatched) {
                MessageId messageId = node.getMessageId();
                if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                    inAckRange = true;
                }
                if (!inAckRange) continue;
                node.incrementRedeliveryCounter();
                if (!ack.getLastMessageId().equals(messageId)) continue;
                callDispatchMatched = true;
                break;
            }
            if (!callDispatchMatched) {
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
        } else if (ack.isPoisonAck()) {
            if (ack.isInTransaction()) {
                throw new JMSException("Poison ack cannot be transacted: " + ack);
            }
            int index = 0;
            boolean inAckRange = false;
            ArrayList<MessageReference> removeList = new ArrayList<MessageReference>();
            for (MessageReference node : this.dispatched) {
                MessageId messageId = node.getMessageId();
                if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                    inAckRange = true;
                }
                if (!inAckRange) continue;
                this.sendToDLQ(context, node);
                node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                removeList.add(node);
                ++this.dequeueCounter;
                ++index;
                this.acknowledge(context, ack, node);
                if (!ack.getLastMessageId().equals(messageId)) continue;
                this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                callDispatchMatched = true;
                break;
            }
            for (MessageReference node : removeList) {
                this.dispatched.remove(node);
            }
            if (!callDispatchMatched) {
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
        }
        if (callDispatchMatched) {
            this.dispatchMatched();
        } else {
            if (this.isSlave()) {
                throw new JMSException("Slave broker out of sync with master: Acknowledgment (" + ack + ") was not in the dispatch list: " + this.dispatched);
            }
            LOG.debug((Object)("Acknowledgment out of sync (Normally occurs when failover connection reconnects): " + ack));
        }
    }

    protected void sendToDLQ(ConnectionContext context, MessageReference node) throws IOException, Exception {
        this.broker.sendToDeadLetterQueue(context, node);
    }

    protected synchronized boolean isFull() {
        return this.isSlave() || this.dispatched.size() - this.prefetchExtension >= this.info.getPrefetchSize();
    }

    public synchronized boolean isLowWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) <= (double)this.info.getPrefetchSize() * 0.4;
    }

    public synchronized boolean isHighWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) >= (double)this.info.getPrefetchSize() * 0.9;
    }

    public synchronized int countBeforeFull() {
        return this.info.getPrefetchSize() + this.prefetchExtension - this.dispatched.size();
    }

    public synchronized int getPendingQueueSize() {
        return this.pending.size();
    }

    public synchronized int getDispatchedQueueSize() {
        return this.dispatched.size();
    }

    public synchronized long getDequeueCounter() {
        return this.dequeueCounter;
    }

    public synchronized long getDispatchedCounter() {
        return this.dispatchCounter;
    }

    public synchronized long getEnqueueCounter() {
        return this.enqueueCounter;
    }

    public boolean isRecoveryRequired() {
        return this.pending.isRecoveryRequired();
    }

    public synchronized PendingMessageCursor getPending() {
        return this.pending;
    }

    public synchronized void setPending(PendingMessageCursor pending) {
        this.pending = pending;
        if (this.pending != null) {
            this.pending.setSystemUsage(this.usageManager);
        }
    }

    public void optimizePrefetch() {
    }

    public synchronized void add(ConnectionContext context, Destination destination) throws Exception {
        super.add(context, destination);
        this.pending.add(context, destination);
    }

    public synchronized void remove(ConnectionContext context, Destination destination) throws Exception {
        super.remove(context, destination);
        this.pending.remove(context, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dispatchMatched() throws IOException {
        block7: {
            if (!this.isSlave()) {
                try {
                    int numberToDispatch = this.countBeforeFull();
                    if (numberToDispatch <= 0) break block7;
                    this.pending.setMaxBatchSize(numberToDispatch);
                    int count = 0;
                    this.pending.reset();
                    while (this.pending.hasNext() && !this.isFull() && count < numberToDispatch) {
                        MessageReference node = this.pending.next();
                        if (node == null) {
                            break;
                        }
                        if (!this.canDispatch(node)) continue;
                        this.pending.remove();
                        if (node != QueueMessageReference.NULL_MESSAGE && this.broker.isExpired(node)) {
                            this.broker.messageExpired(this.getContext(), node);
                            ++this.dequeueCounter;
                            continue;
                        }
                        this.dispatch(node);
                        ++count;
                    }
                }
                finally {
                    this.pending.release();
                }
            }
        }
    }

    protected synchronized boolean dispatch(final MessageReference node) throws IOException {
        final Message message = node.getMessage();
        if (message == null) {
            return false;
        }
        if (this.canDispatch(node) && !this.isSlave()) {
            MessageDispatch md = this.createMessageDispatch(node, message);
            if (node != QueueMessageReference.NULL_MESSAGE) {
                ++this.dispatchCounter;
                this.dispatched.add(node);
                if (this.pending != null) {
                    this.pending.dispatched(message);
                }
            } else {
                this.prefetchExtension = Math.max(0, this.prefetchExtension - 1);
            }
            if (this.info.isDispatchAsync()) {
                md.setTransmitCallback(new Runnable(){

                    public void run() {
                        PrefetchSubscription.this.onDispatch(node, message);
                    }
                });
                this.context.getConnection().dispatchAsync(md);
            } else {
                this.context.getConnection().dispatchSync(md);
                this.onDispatch(node, message);
            }
            return true;
        }
        return false;
    }

    protected void onDispatch(MessageReference node, Message message) {
        if (node.getRegionDestination() != null && node != QueueMessageReference.NULL_MESSAGE) {
            node.getRegionDestination().getDestinationStatistics().getDispatched().increment();
        }
        if (this.info.isDispatchAsync()) {
            try {
                this.dispatchMatched();
            }
            catch (IOException e) {
                this.context.getConnection().serviceExceptionAsync(e);
            }
        }
    }

    public void updateConsumerPrefetch(int newPrefetch) {
        if (this.context != null && this.context.getConnection() != null && this.context.getConnection().isManageable()) {
            ConsumerControl cc = new ConsumerControl();
            cc.setConsumerId(this.info.getConsumerId());
            cc.setPrefetch(newPrefetch);
            this.context.getConnection().dispatchAsync(cc);
        }
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        if (node == QueueMessageReference.NULL_MESSAGE) {
            MessageDispatch md = new MessageDispatch();
            md.setMessage(null);
            md.setConsumerId(this.info.getConsumerId());
            md.setDestination(null);
            return md;
        }
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setDestination(node.getRegionDestination().getActiveMQDestination());
        md.setMessage(message);
        md.setRedeliveryCounter(node.getRedeliveryCounter());
        return md;
    }

    protected abstract boolean canDispatch(MessageReference var1) throws IOException;

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
    }

    public boolean isOptimizedDispatch() {
        return this.optimizedDispatch;
    }

    public void setOptimizedDispatch(boolean optimizedDispatch) {
        this.optimizedDispatch = optimizedDispatch;
    }

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }
}

