/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationFactoryImpl
extends DestinationFactory {
    protected final SystemUsage memoryManager;
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final PersistenceAdapter persistenceAdapter;
    protected RegionBroker broker;

    public DestinationFactoryImpl(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        this.memoryManager = memoryManager;
        this.taskRunnerFactory = taskRunnerFactory;
        if (persistenceAdapter == null) {
            throw new IllegalArgumentException("null persistenceAdapter");
        }
        this.persistenceAdapter = persistenceAdapter;
    }

    @Override
    public void setRegionBroker(RegionBroker broker) {
        if (broker == null) {
            throw new IllegalArgumentException("null broker");
        }
        this.broker = broker;
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        return this.persistenceAdapter.getDestinations();
    }

    @Override
    public Destination createDestination(ConnectionContext context, ActiveMQDestination destination, DestinationStatistics destinationStatistics) throws Exception {
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                final ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destination;
                return new Queue(this.broker.getRoot(), destination, this.memoryManager, null, destinationStatistics, this.taskRunnerFactory, this.broker.getTempDataStore()){

                    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
                        if (!tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId())) {
                            throw new JMSException("Cannot subscribe to remote temporary destination: " + tempDest);
                        }
                        super.addSubscription(context, sub);
                    }
                };
            }
            MessageStore store = this.persistenceAdapter.createQueueMessageStore((ActiveMQQueue)destination);
            Queue queue = new Queue(this.broker.getRoot(), destination, this.memoryManager, store, destinationStatistics, this.taskRunnerFactory, this.broker.getTempDataStore());
            this.configureQueue(queue, destination);
            queue.initialize();
            return queue;
        }
        if (destination.isTemporary()) {
            final ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destination;
            return new Topic(this.broker.getRoot(), destination, null, this.memoryManager, destinationStatistics, this.taskRunnerFactory){

                public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
                    if (!tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId())) {
                        throw new JMSException("Cannot subscribe to remote temporary destination: " + tempDest);
                    }
                    super.addSubscription(context, sub);
                }
            };
        }
        TopicMessageStore store = null;
        if (!AdvisorySupport.isAdvisoryTopic(destination)) {
            store = this.persistenceAdapter.createTopicMessageStore((ActiveMQTopic)destination);
        }
        Topic topic = new Topic(this.broker.getRoot(), destination, store, this.memoryManager, destinationStatistics, this.taskRunnerFactory);
        this.configureTopic(topic, destination);
        return topic;
    }

    protected void configureQueue(Queue queue, ActiveMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure(queue, this.broker.getTempDataStore());
        }
    }

    protected void configureTopic(Topic topic, ActiveMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure(topic);
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.persistenceAdapter.getLastMessageBrokerSequenceId();
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.persistenceAdapter;
    }

    @Override
    public SubscriptionInfo[] getAllDurableSubscriptions(ActiveMQTopic topic) throws IOException {
        return this.persistenceAdapter.createTopicMessageStore(topic).getAllSubscriptions();
    }
}

