/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdvisoryBroker
extends BrokerFilter {
    private static final Log LOG = LogFactory.getLog(AdvisoryBroker.class);
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    protected final ConcurrentHashMap<ConnectionId, ConnectionInfo> connections = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ConsumerId, ConsumerInfo> consumers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ProducerId, ProducerInfo> producers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ActiveMQDestination, DestinationInfo> destinations = new ConcurrentHashMap();
    protected final ProducerId advisoryProducerId = new ProducerId();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();

    public AdvisoryBroker(Broker next) {
        super(next);
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        this.next.addConnection(context, info);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        this.fireAdvisory(context, topic, info);
        this.connections.put(info.getConnectionId(), info);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription answer = this.next.addConsumer(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination());
            this.consumers.put(info.getConsumerId(), info);
            this.fireConsumerAdvisory(context, topic, info);
        } else {
            ActiveMQTopic topic;
            if (AdvisorySupport.isConnectionAdvisoryTopic(info.getDestination())) {
                for (ConnectionInfo connectionInfo : this.connections.values()) {
                    topic = AdvisorySupport.getConnectionAdvisoryTopic();
                    this.fireAdvisory(context, topic, connectionInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isDestinationAdvisoryTopic(info.getDestination())) {
                for (DestinationInfo destinationInfo : this.destinations.values()) {
                    topic = AdvisorySupport.getDestinationAdvisoryTopic(destinationInfo.getDestination());
                    this.fireAdvisory(context, topic, destinationInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isProducerAdvisoryTopic(info.getDestination())) {
                for (ProducerInfo producerInfo : this.producers.values()) {
                    topic = AdvisorySupport.getProducerAdvisoryTopic(producerInfo.getDestination());
                    this.fireProducerAdvisory(context, topic, producerInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isConsumerAdvisoryTopic(info.getDestination())) {
                for (ConsumerInfo consumerInfo : this.consumers.values()) {
                    topic = AdvisorySupport.getConsumerAdvisoryTopic(consumerInfo.getDestination());
                    this.fireConsumerAdvisory(context, topic, consumerInfo, info.getConsumerId());
                }
            }
        }
        return answer;
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.next.addProducer(context, info);
        if (info.getDestination() != null && !AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(info.getDestination());
            this.fireAdvisory(context, topic, info);
            this.producers.put(info.getProducerId(), info);
        }
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        Destination answer = this.next.addDestination(context, destination);
        if (!AdvisorySupport.isAdvisoryTopic(destination)) {
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            DestinationInfo info = new DestinationInfo(context.getConnectionId(), 0, destination);
            this.fireAdvisory(context, topic, info);
            this.destinations.put(destination, info);
        }
        return answer;
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        this.next.addDestinationInfo(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(destination)) {
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
            this.destinations.put(destination, info);
        }
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        this.next.removeDestination(context, destination, timeout);
        DestinationInfo info = this.destinations.remove(destination);
        if (info != null) {
            info.setDestination(destination);
            info.setOperationType((byte)1);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
            try {
                this.next.removeDestination(context, AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
            try {
                this.next.removeDestination(context, AdvisorySupport.getProducerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
        }
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo destInfo) throws Exception {
        this.next.removeDestinationInfo(context, destInfo);
        DestinationInfo info = this.destinations.remove(destInfo.getDestination());
        if (info != null) {
            info.setDestination(destInfo.getDestination());
            info.setOperationType((byte)1);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destInfo.getDestination());
            this.fireAdvisory(context, topic, info);
            try {
                this.next.removeDestination(context, AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
            try {
                this.next.removeDestination(context, AdvisorySupport.getProducerAdvisoryTopic(info.getDestination()), -1L);
            }
            catch (Exception expectedIfDestinationDidNotExistYet) {
                // empty catch block
            }
        }
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        this.next.removeConnection(context, info, error);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        this.fireAdvisory(context, topic, info.createRemoveCommand());
        this.connections.remove(info.getConnectionId());
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        this.next.removeConsumer(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination());
            this.consumers.remove(info.getConsumerId());
            this.fireConsumerAdvisory(context, topic, info.createRemoveCommand());
        }
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.next.removeProducer(context, info);
        if (info.getDestination() != null && !AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            ActiveMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(info.getDestination());
            this.producers.remove(info.getProducerId());
            this.fireProducerAdvisory(context, topic, info.createRemoveCommand());
        }
    }

    public void messageExpired(ConnectionContext context, MessageReference messageReference) {
        this.next.messageExpired(context, messageReference);
        try {
            ActiveMQTopic topic = AdvisorySupport.getExpiredMessageTopic(messageReference.getMessage().getDestination());
            this.fireAdvisory(context, topic, messageReference.getMessage());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to fire message expired advisory");
        }
    }

    protected void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command) throws Exception {
        this.fireAdvisory(context, topic, command, null);
    }

    protected void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    protected void fireConsumerAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command) throws Exception {
        this.fireConsumerAdvisory(context, topic, command, null);
    }

    protected void fireConsumerAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        advisoryMessage.setIntProperty("consumerCount", this.consumers.size());
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    protected void fireProducerAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command) throws Exception {
        this.fireProducerAdvisory(context, topic, command, null);
    }

    protected void fireProducerAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        advisoryMessage.setIntProperty("producerCount", this.producers.size());
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAdvisory(ConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId, ActiveMQMessage advisoryMessage) throws Exception {
        if (this.getBrokerService().isStarted()) {
            advisoryMessage.setDataStructure(command);
            advisoryMessage.setPersistent(false);
            advisoryMessage.setType("Advisory");
            advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
            advisoryMessage.setTargetConsumerId(targetConsumerId);
            advisoryMessage.setDestination(topic);
            advisoryMessage.setResponseRequired(false);
            advisoryMessage.setProducerId(this.advisoryProducerId);
            boolean originalFlowControl = context.isProducerFlowControl();
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setConnectionContext(context);
            producerExchange.setMutable(true);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            try {
                context.setProducerFlowControl(false);
                this.next.send(producerExchange, advisoryMessage);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }
}

