/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.ws.WebServiceException;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.wsf.common.IOUtils;
import org.jboss.wsf.container.jboss42.DefaultWebAppDesciptorModifierImpl;
import org.jboss.wsf.container.jboss42.RewriteResults;
import org.jboss.wsf.container.jboss42.WebAppDesciptorModifier;
import org.jboss.wsf.spi.deployment.Deployment;
import org.xml.sax.EntityResolver;

public class WebXMLRewriterImpl {
    private WebAppDesciptorModifier desciptorModifier = new DefaultWebAppDesciptorModifierImpl();

    public WebAppDesciptorModifier getDesciptorModifier() {
        return this.desciptorModifier;
    }

    public void setDesciptorModifier(WebAppDesciptorModifier desciptorModifier) {
        this.desciptorModifier = desciptorModifier;
    }

    public RewriteResults rewriteWebXml(Deployment dep) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        File warFile = new File(warURL.getFile());
        if (!warFile.isDirectory()) {
            throw new WebServiceException("Expected a war directory: " + warURL);
        }
        File webXML = new File(warURL.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WebServiceException("Cannot find web.xml: " + webXML);
        }
        try {
            File orgWebXML = new File(webXML.getCanonicalPath() + ".org");
            orgWebXML.delete();
            if (!webXML.renameTo(orgWebXML)) {
                throw new WebServiceException("Cannot rename web.xml: " + orgWebXML);
            }
            return this.rewriteWebXml(orgWebXML, webXML, dep);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RewriteResults rewriteWebXml(File input, File destFile, Deployment dep) throws Exception {
        if (destFile == null) {
            destFile = File.createTempFile("jbossws-alt-web", "xml", IOUtils.createTempDirectory());
            destFile.deleteOnExit();
        }
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new JBossEntityResolver());
            inputStream = new FileInputStream(input);
            Document document = reader.read((InputStream)inputStream);
            RewriteResults results = this.desciptorModifier.modifyDescriptor(dep, document);
            results.webXML = destFile.toURL();
            outputStream = new FileOutputStream(destFile);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(document);
            writer.close();
            RewriteResults rewriteResults = results;
            return rewriteResults;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

