/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;

public class ClassLocator
implements Locator {
    private static final Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Enumeration getResources(String name) throws IOException {
        Enumeration<URL> en;
        name = ClassLocator.resolveName(name);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && (en = cl.getResources(name)).hasMoreElements()) {
            return en;
        }
        cl = ClassLocator.class.getClassLoader();
        if (cl != null && (en = cl.getResources(name)).hasMoreElements()) {
            return en;
        }
        return ClassLoader.getSystemResources(name);
    }

    public List getDependentXMLResources(String name, String elName, String elDepends) throws IOException {
        LinkedHashMap<String, XMLResource> rcmap = new LinkedHashMap<String, XMLResource>();
        Enumeration en = this.getResources(name);
        while (en.hasMoreElements()) {
            URL url = (URL)en.nextElement();
            XMLResource xr = new XMLResource(url, elName, elDepends);
            XMLResource old = rcmap.put(xr.name, xr);
            if (old == null) continue;
            log.warning("Replicate resource: " + xr.name + "\nOverwrite " + old.url + "\nwith " + xr.url);
        }
        if (rcmap.isEmpty() && log.debugable()) {
            log.debug("No resouce is found for " + name);
        }
        LinkedList rcs = new LinkedList();
        LinkedHashSet resolving = new LinkedHashSet();
        while (!rcmap.isEmpty()) {
            Iterator it = rcmap.values().iterator();
            XMLResource xr = (XMLResource)it.next();
            it.remove();
            ClassLocator.resolveDependency(xr, rcs, rcmap, resolving);
            if (!$assertionsDisabled && !resolving.isEmpty()) {
                throw new AssertionError();
            }
        }
        return rcs;
    }

    private static void resolveDependency(XMLResource xr, List rcs, Map rcmap, Set resolving) {
        if (!resolving.add(xr.name)) {
            throw new IllegalStateException("Recusrive reference among " + resolving);
        }
        Iterator it = xr.depends.iterator();
        while (it.hasNext()) {
            String nm = (String)it.next();
            XMLResource dep = (XMLResource)rcmap.remove(nm);
            if (dep == null) continue;
            ClassLocator.resolveDependency(dep, rcs, rcmap, resolving);
        }
        rcs.add(new Resource(xr.url, xr.document));
        resolving.remove(xr.name);
        if (log.debugable()) {
            log.debug("Adding resolved resource: " + xr.name);
        }
    }

    public String getDirectory() {
        return null;
    }

    public URL getResource(String name) {
        URL url;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL uRL = url = cl != null ? cl.getResource(ClassLocator.resolveName(name)) : null;
        return url != null ? url : ClassLocator.class.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl != null ? cl.getResourceAsStream(ClassLocator.resolveName(name)) : null;
        return is != null ? is : ClassLocator.class.getResourceAsStream(name);
    }

    private static String resolveName(String name) {
        return name != null && name.startsWith("/") ? name.substring(1) : name;
    }

    public int hashCode() {
        return 1123;
    }

    public boolean equals(Object o) {
        return o instanceof ClassLocator;
    }

    static {
        $assertionsDisabled = !ClassLocator.class.desiredAssertionStatus();
        log = Log.lookup(ClassLocator.class);
    }

    public static class Resource {
        public final URL url;
        public final Document document;

        private Resource(URL url, Document document) {
            this.url = url;
            this.document = document;
        }

        public String toString() {
            return "[res: " + this.url + ']';
        }
    }

    private static class XMLResource {
        private final String name;
        private final URL url;
        private final Document document;
        private final List depends;

        private XMLResource(URL url, String elName, String elDepends) throws IOException {
            if (log.debugable()) {
                log.debug("Loading " + url);
            }
            try {
                this.document = new SAXBuilder(false, false, true).build(url);
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                IOException ioex = new IOException("Unable to load " + url);
                ioex.initCause(ex);
                throw ioex;
            }
            this.url = url;
            Element root = this.document.getRootElement();
            this.name = IDOMs.getRequiredElementValue(root, elName);
            String deps = root.getElementValue(elDepends, true);
            if (deps == null || deps.length() == 0) {
                this.depends = Collections.EMPTY_LIST;
            } else {
                this.depends = new LinkedList();
                CollectionsX.parse(this.depends, deps, ',');
                if (log.finerable()) {
                    log.finer(this.name + " depends on " + this.depends);
                }
            }
        }

        public String toString() {
            return "[" + this.name + ": " + this.url + " depends on " + this.depends + ']';
        }
    }
}

