/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Iterator;
import java.util.LinkedList;

public class Utils {
    public static final int getSubversion(String version, int portion) {
        if (portion < 0) {
            throw new IllegalArgumentException("Negative not allowed: " + portion);
        }
        int len = version.length();
        int j = 0;
        while (--portion >= 0) {
            if ((j = Utils.nextVerSeparator(version, j) + 1) < len) continue;
            return 0;
        }
        return Utils.convertSubversion(version.substring(j, Utils.nextVerSeparator(version, j)));
    }

    public static final int[] parseVersion(String version) {
        LinkedList<Integer> vers = new LinkedList<Integer>();
        int j = 0;
        int len = version.length();
        while (j < len) {
            int k = Utils.nextVerSeparator(version, j);
            vers.add(new Integer(Utils.convertSubversion(version.substring(j, k))));
            j = k + 1;
        }
        int[] ivs = new int[vers.size()];
        int j2 = 0;
        Iterator it = vers.iterator();
        while (it.hasNext()) {
            ivs[j2++] = (Integer)it.next();
        }
        return ivs;
    }

    public static final int compareVersion(int[] v1, int[] v2) {
        int j = 0;
        while (true) {
            if (j == v1.length) {
                while (j < v2.length) {
                    if (v2[j] > 0) {
                        return -1;
                    }
                    if (v2[j] < 0) {
                        return 1;
                    }
                    ++j;
                }
                return 0;
            }
            if (j == v2.length) {
                while (j < v1.length) {
                    if (v1[j] > 0) {
                        return 1;
                    }
                    if (v1[j] < 0) {
                        return -1;
                    }
                    ++j;
                }
                return 0;
            }
            if (v1[j] > v2[j]) {
                return 1;
            }
            if (v1[j] < v2[j]) {
                return -1;
            }
            ++j;
        }
    }

    private static final int convertSubversion(String subver) {
        try {
            return Integer.parseInt(subver);
        }
        catch (Throwable ex) {
            int j;
            int base;
            subver = subver.toLowerCase();
            if (subver.startsWith("rc")) {
                base = -100;
                j = 2;
            } else if (subver.startsWith("beta")) {
                base = -300;
                j = 4;
            } else if (subver.startsWith("alpha")) {
                base = -500;
                j = 5;
            } else {
                return 0;
            }
            if (j < subver.length()) {
                try {
                    return base + Integer.parseInt(subver.substring(j));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return base;
        }
    }

    private static final int nextVerSeparator(String version, int from) {
        char cc;
        int len = version.length();
        while (from < len && ((cc = version.charAt(from)) >= '0' && cc <= '9' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z')) {
            ++from;
        }
        return from;
    }
}

