/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;

public class MultiCache
implements Cache,
Serializable,
Cloneable {
    private final CacheMap[] _caches;
    private int _maxsize;

    public MultiCache() {
        this(16);
    }

    public MultiCache(int nCache, int maxSize, int lifetime) {
        this(nCache);
        this.setMaxSize(maxSize);
        this.setLifetime(lifetime);
    }

    public MultiCache(int nCache) {
        if (nCache <= 0) {
            throw new IllegalArgumentException("Positive only");
        }
        this._caches = new CacheMap[nCache];
        for (int j = 0; j < nCache; ++j) {
            this._caches[j] = new CacheMap(8);
            this._maxsize += this._caches[j].getMaxSize();
        }
    }

    private MultiCache(CacheMap[] clone, int maxsize) {
        this._maxsize = maxsize;
        this._caches = new CacheMap[clone.length];
        for (int j = 0; j < clone.length; ++j) {
            this._caches[j] = (CacheMap)clone[j].clone();
        }
    }

    public MultiCache(int nCache, int initSize) {
        if (nCache <= 0 || initSize <= 0) {
            throw new IllegalArgumentException("Positive only");
        }
        initSize = (initSize - 1) / nCache + 1;
        this._caches = new CacheMap[nCache];
        for (int j = 0; j < nCache; ++j) {
            this._caches[j] = new CacheMap(initSize);
            this._maxsize += this._caches[j].getMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        CacheMap map;
        CacheMap cacheMap = map = this.getCache(key);
        synchronized (cacheMap) {
            return map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        CacheMap map;
        CacheMap cacheMap = map = this.getCache(key);
        synchronized (cacheMap) {
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        CacheMap map;
        CacheMap cacheMap = map = this.getCache(key);
        synchronized (cacheMap) {
            return map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        CacheMap map;
        CacheMap cacheMap = map = this.getCache(key);
        synchronized (cacheMap) {
            return map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int j = 0; j < this._caches.length; ++j) {
            CacheMap cacheMap = this._caches[j];
            synchronized (cacheMap) {
                this._caches[j].clear();
                continue;
            }
        }
    }

    private CacheMap getCache(Object key) {
        int hc = Objects.hashCode(key);
        if ((hc = hc >>> 13 ^ hc) < 0) {
            hc = -hc;
        }
        return this._caches[hc % this._caches.length];
    }

    public int getLifetime() {
        return this._caches[0].getLifetime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifetime(int lifetime) {
        MultiCache multiCache = this;
        synchronized (multiCache) {
            for (int j = 0; j < this._caches.length; ++j) {
                this._caches[j].setLifetime(lifetime);
            }
        }
    }

    public int getMaxSize() {
        return this._maxsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxsize) {
        this._maxsize = maxsize;
        int v = maxsize / this._caches.length;
        if (v == 0) {
            v = maxsize > 0 ? 1 : (maxsize < 0 ? -1 : 0);
        }
        MultiCache multiCache = this;
        synchronized (multiCache) {
            for (int j = 0; j < this._caches.length; ++j) {
                this._caches[j].setMaxSize(v);
            }
        }
    }

    public Object clone() {
        return new MultiCache(this._caches, this._maxsize);
    }
}

