/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.xel.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.Maps;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

public class Utils {
    public static final int SCALAR = 0;
    public static final int LIST = 1;
    public static final int MAP = 2;

    public static ExValue[] parseList(String expr, Class expcls, boolean ignoreEmpty) {
        ExValue[] exValueArray;
        if (expr == null) {
            return null;
        }
        if (expr.length() != 0) {
            LinkedList<ExValue> dst = new LinkedList<ExValue>();
            Collection src = CollectionsX.parse(null, (String)expr, (char)',', (boolean)true, (boolean)true);
            Iterator it = src.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (ignoreEmpty && s.length() <= 0) continue;
                dst.add(new ExValue(s, expcls));
            }
            if (!dst.isEmpty()) {
                return dst.toArray(new ExValue[dst.size()]);
            }
        }
        if (ignoreEmpty) {
            exValueArray = null;
        } else {
            ExValue[] exValueArray2 = new ExValue[1];
            exValueArray = exValueArray2;
            exValueArray2[0] = new ExValue(expr, expcls);
        }
        return exValueArray;
    }

    public static Object parseComposite(String expr, Class expcls, int type) {
        if (expr == null) {
            return null;
        }
        if (type == 1) {
            return Utils.parseList(expr, expcls, false);
        }
        if (type == 2) {
            Map dst = Maps.parse(new LinkedHashMap(), (String)expr, (char)',', (char)'\'', (boolean)false, (boolean)false, (boolean)true);
            Iterator it = dst.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                me.setValue(new ExValue((String)me.getValue(), expcls));
            }
            return dst;
        }
        return new ExValue(expr, expcls);
    }

    public static Object evaluateComposite(Evaluator eval, Component comp, Object expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof ExValue) {
            return ((ExValue)expr).getValue(eval, comp);
        }
        if (expr instanceof ExValue[]) {
            ExValue[] src = (ExValue[])expr;
            Object[] dst = new Object[src.length];
            for (int j = 0; j < src.length; ++j) {
                dst[j] = src[j].getValue(eval, comp);
            }
            return dst;
        }
        Map src = (Map)expr;
        LinkedHashMap dst = new LinkedHashMap(src.size());
        Iterator it = src.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            dst.put(me.getKey(), ((ExValue)me.getValue()).getValue(eval, comp));
        }
        return dst;
    }

    public static Object evaluateComposite(Evaluator eval, Page page, Object expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof ExValue) {
            return ((ExValue)expr).getValue(eval, page);
        }
        if (expr instanceof ExValue[]) {
            ExValue[] src = (ExValue[])expr;
            Object[] dst = new Object[src.length];
            for (int j = 0; j < src.length; ++j) {
                dst[j] = src[j].getValue(eval, page);
            }
            return dst;
        }
        Map src = (Map)expr;
        LinkedHashMap dst = new LinkedHashMap(src.size());
        Iterator it = src.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            dst.put(me.getKey(), ((ExValue)me.getValue()).getValue(eval, page));
        }
        return dst;
    }
}

