/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.net.URL;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ContentLoader;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.zk.scripting.Interpreters;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.EvalRefStub;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.EvaluatorRef;

public class ZScript
extends EvalRefStub
implements Condition,
Serializable {
    private static final Log log = Log.lookup((Class)ZScript.class);
    private String _zslang;
    private final String _cnt;
    private final Object _url;
    private final Locator _locator;
    private final ConditionImpl _cond;
    private boolean _deferred;
    private static ResourceCache _cache;

    public static final ZScript parseContent(String content) {
        return ZScript.parseContent(content, 0);
    }

    public static final ZScript parseContent(String content, int lineno) {
        String prefix = null;
        if (content != null && lineno > 1) {
            StringBuffer sb = new StringBuffer(lineno);
            while (--lineno > 0) {
                sb.append('\n');
            }
            prefix = sb.toString();
        }
        int len = content != null ? content.length() : 0;
        for (int j = 0; j < len; ++j) {
            char cc = content.charAt(j);
            if (cc == ':') {
                if (j <= 0) break;
                String zslang = content.substring(0, j);
                if (Interpreters.exists(zslang)) {
                    return new ZScript(null, zslang, content.substring(j + 1), null);
                }
                log.warning("Ignored: unknown scripting language, " + zslang);
                break;
            }
            if (!Interpreters.isLegalName(cc)) break;
        }
        return new ZScript(null, null, prefix != null ? prefix + content : content, null);
    }

    public ZScript(EvaluatorRef evalr, String zslang, String content, ConditionImpl cond) {
        this._evalr = evalr;
        this._zslang = zslang;
        this._cnt = content != null ? content : "";
        this._url = null;
        this._locator = null;
        this._cond = cond;
    }

    public ZScript(EvaluatorRef evalr, String zslang, URL url, ConditionImpl cond) {
        if (url == null) {
            throw new IllegalArgumentException("null url");
        }
        this._evalr = evalr;
        this._zslang = zslang;
        this._url = url;
        this._cnt = null;
        this._locator = null;
        this._cond = cond;
    }

    public ZScript(EvaluatorRef evalr, String zslang, String url, ConditionImpl cond, Locator locator) {
        if (url == null || locator == null) {
            throw new IllegalArgumentException("null");
        }
        this._evalr = evalr;
        this._zslang = zslang;
        this._url = new ExValue(url, String.class);
        this._cnt = null;
        this._locator = locator;
        this._cond = cond;
    }

    EvaluatorRef getEvaluatorRef() {
        return this._evalr;
    }

    public String getLanguage() {
        return this._zslang;
    }

    public void setLanguage(String zslang) {
        this._zslang = zslang;
    }

    public String getRawContent() {
        return this._cnt;
    }

    public String getContent(Page page, Component comp) {
        Object o;
        URL url;
        if (this._cnt != null) {
            return this._cnt;
        }
        if (this._url instanceof ExValue) {
            String s = (String)(comp != null ? ((ExValue)this._url).getValue((Evaluator)this._evalr, comp) : ((ExValue)this._url).getValue((Evaluator)this._evalr, page));
            if (s == null || s.length() == 0) {
                throw new UiException("The zscript URL, " + this._url + ", is evaluated to \"" + s + '\"');
            }
            url = this._locator.getResource(s);
            if (url == null) {
                throw new UiException("File not found: " + s + " (evaluated from " + this._url + ')');
            }
        } else {
            url = (URL)this._url;
        }
        if ((o = ZScript.getCache().get((Object)url)) == null) {
            throw new UiException("File not found: " + this._url);
        }
        if (!(o instanceof String)) {
            throw new UiException("Illegal file type: " + o.getClass());
        }
        return (String)o;
    }

    public boolean isDeferred() {
        return this._deferred;
    }

    public void setDeferred(boolean deferred) {
        this._deferred = deferred;
    }

    public boolean isEffective(Component comp) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, comp);
    }

    public boolean isEffective(Page page) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, page);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40).append("[zscript: ");
        if (this._url != null) {
            sb.append(this._url);
        } else {
            int len = this._cnt.length();
            if (len > 20) {
                sb.append(this._cnt.substring(0, 16)).append("...");
            } else {
                sb.append(this._cnt);
            }
        }
        return sb.append(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceCache getCache() {
        if (_cache == null) {
            Class clazz = ZScript.class;
            synchronized (clazz) {
                if (_cache == null) {
                    ResourceCache cache = new ResourceCache((Loader)new ContentLoader());
                    cache.setMaxSize(512);
                    cache.setLifetime(3600000);
                    _cache = cache;
                }
            }
        }
        return _cache;
    }
}

