/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.idom.Namespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.xel.impl.EvaluatorRef;

public class NativeInfo
extends ComponentInfo {
    private List _prokids;
    private List _epikids;
    private NativeInfo _splitkid;
    private List _dns;

    public NativeInfo(NodeInfo parent, ComponentDefinition compdef, String tagnm) {
        super(parent, compdef, tagnm);
        if (!compdef.isNative()) {
            throw new IllegalArgumentException("compdef must be native");
        }
    }

    public NativeInfo(EvaluatorRef evlar, ComponentDefinition compdef, String tagnm) {
        super(evlar, compdef, tagnm);
    }

    public List getDeclaredNamespaces() {
        return this._dns != null ? this._dns : Collections.EMPTY_LIST;
    }

    public void addDeclaredNamespace(Namespace ns) {
        if (this._dns == null) {
            this._dns = new LinkedList();
        }
        this._dns.add(ns);
    }

    public List getPrologChildren() {
        return this._prokids != null ? this._prokids : Collections.EMPTY_LIST;
    }

    public List getEpilogChildren() {
        return this._epikids != null ? this._epikids : Collections.EMPTY_LIST;
    }

    public void addPrologChild(NativeInfo child) {
        this.addPrologChildDirectly(child);
    }

    public void addPrologChild(ZScript child) {
        this.addPrologChildDirectly(child);
    }

    public void addPrologChild(VariablesInfo child) {
        this.addPrologChildDirectly(child);
    }

    public void addPrologChild(AttributesInfo child) {
        this.addPrologChildDirectly(child);
    }

    public void addPrologChild(TextInfo text) {
        this.addPrologChildDirectly(text);
    }

    void addPrologChildDirectly(Object child) {
        if (this._prokids == null) {
            this._prokids = new LinkedList();
        }
        this._prokids.add(child);
    }

    public void addEpilogChild(NativeInfo child) {
        this.addEpilogChildDirectly(child);
    }

    public void addEpilogChild(ZScript child) {
        this.addEpilogChildDirectly(child);
    }

    public void addEpilogChild(VariablesInfo child) {
        this.addEpilogChildDirectly(child);
    }

    public void addEpilogChild(AttributesInfo child) {
        this.addEpilogChildDirectly(child);
    }

    void addEpilogChildDirectly(Object child) {
        if (this._epikids == null) {
            this._epikids = new LinkedList();
        }
        this._epikids.add(child);
    }

    public NativeInfo getSplitChild() {
        return this._splitkid;
    }

    public void setSplitChild(NativeInfo child) {
        this._splitkid = child;
    }

    public Component newInstance(Page page, Component parent) {
        Component comp = super.newInstance(page, parent);
        if (this._dns != null) {
            Native nc = (Native)((Object)comp);
            Iterator it = this._dns.iterator();
            while (it.hasNext()) {
                nc.addDeclaredNamespace((Namespace)it.next());
            }
        }
        return comp;
    }

    public Object clone() {
        NativeInfo clone = (NativeInfo)super.clone();
        if (clone._prokids != null) {
            clone._prokids = new LinkedList(clone._prokids);
        }
        if (clone._epikids != null) {
            clone._epikids = new LinkedList(clone._epikids);
        }
        return clone;
    }
}

