/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.JavaScript;
import org.zkoss.web.servlet.StyleSheet;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.Taglibs;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentDefinitionMap;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionLoaders;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LangEvalRef;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.EvaluatorRef;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

public class LanguageDefinition {
    private static final Log log = Log.lookup((Class)LanguageDefinition.class);
    private static final Map _ldefByName = new HashMap();
    private static final Map _ldefsByExt = new HashMap();
    private static final Map _ldefsByClient = new HashMap();
    public static final String ZK_NAMESPACE = "http://www.zkoss.org/2005/zk";
    public static final String ANNO_NAMESPACE = "http://www.zkoss.org/2005/zk/annotation";
    public static final String NATIVE_NAMESPACE = "http://www.zkoss.org/2005/zk/native";
    public static final String NATIVE_NAMESPACE_PREFIX = "native:";
    private final String _deviceType;
    private final String _name;
    private final String _ns;
    private List _exts;
    private final ComponentDefinitionMap _compdefs;
    private String _dyntagnm;
    private ComponentDefinition _dyntagDefn;
    private Set _dyntagRvAttrs;
    private final Map _initscripts = new HashMap();
    private final Map _eachscripts = new HashMap();
    private final String _completeURI;
    private final String _desktopURI;
    private final String _pageURI;
    private final List _taglibs = new LinkedList();
    private final List _js = new LinkedList();
    private final List _rojs = Collections.unmodifiableList(this._js);
    private final Map _jsmods = new HashMap(5);
    private final Map _rojsmods = Collections.unmodifiableMap(this._jsmods);
    private final List _ss = new LinkedList();
    private final List _ross = Collections.unmodifiableList(this._ss);
    private final Locator _locator;
    private LabelTemplate _labeltmpl;
    private MacroTemplate _macrotmpl;
    private ComponentDefinition _nativedef;
    private Evaluator _eval;
    private EvaluatorRef _evalr;
    private final boolean _native;
    static /* synthetic */ Class class$org$zkoss$zk$ui$ext$Macro;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String name) {
        LanguageDefinition.init();
        Map map = _ldefByName;
        synchronized (map) {
            return _ldefByName.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LanguageDefinition lookup(String name) {
        LanguageDefinition langdef;
        LanguageDefinition.init();
        if (name == null || name.length() == 0) {
            name = "xul/html";
        }
        Map map = _ldefByName;
        synchronized (map) {
            langdef = (LanguageDefinition)_ldefByName.get(name);
        }
        if (langdef == null) {
            if (ZK_NAMESPACE.equals(name)) {
                throw new DefinitionNotFoundException("http://www.zkoss.org/2005/zk is reserved. Use it only with reserved elements and attributes, such as zscript and attribute");
            }
            throw new DefinitionNotFoundException("Language not found: " + name);
        }
        return langdef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LanguageDefinition getByExtension(String ext) {
        LanguageDefinition langdef;
        LanguageDefinition.init();
        if (ext == null) {
            ext = "zul";
        }
        Map map = _ldefsByExt;
        synchronized (map) {
            langdef = (LanguageDefinition)_ldefsByExt.get(ext);
        }
        if (langdef == null) {
            throw new DefinitionNotFoundException("Language not found for extension " + ext);
        }
        return langdef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addExtension(String ext, String lang) {
        if (lang == null || ext == null) {
            throw new IllegalArgumentException();
        }
        LanguageDefinition.init();
        LanguageDefinition langdef = LanguageDefinition.lookup(lang);
        Map map = _ldefsByExt;
        synchronized (map) {
            _ldefsByExt.put(ext, langdef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getByDeviceType(String deviceType) {
        List ldefs;
        LanguageDefinition.init();
        Map map = _ldefsByClient;
        synchronized (map) {
            ldefs = (List)_ldefsByClient.get(deviceType);
        }
        return ldefs != null ? ldefs : Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getAll() {
        LanguageDefinition.init();
        LinkedList list = new LinkedList();
        Map map = _ldefsByClient;
        synchronized (map) {
            Iterator it = _ldefsByClient.values().iterator();
            while (it.hasNext()) {
                list.addAll((List)it.next());
            }
        }
        return list;
    }

    public static final Collection getDeviceTypes() {
        LanguageDefinition.init();
        return _ldefsByClient.keySet();
    }

    private static final void init() {
        try {
            DefinitionLoaders.load();
        }
        catch (IOException ex) {
            throw new UiException(ex);
        }
    }

    public LanguageDefinition(String deviceType, String name, String namespace, List extensions, String desktopURI, String pageURI, boolean ignoreCase, boolean bNative, Locator locator) {
        this(deviceType, name, namespace, extensions, desktopURI, desktopURI, pageURI, ignoreCase, bNative, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageDefinition(String deviceType, String name, String namespace, List extensions, String completeURI, String desktopURI, String pageURI, boolean ignoreCase, boolean bNative, Locator locator) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new UiException("deviceType cannot be empty");
        }
        if (!Devices.exists(deviceType)) {
            throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
        }
        if (ZK_NAMESPACE.equals(namespace)) {
            throw new UiException("http://www.zkoss.org/2005/zk is reserved.");
        }
        if (name == null || name.length() == 0 || namespace == null || namespace.length() == 0 || completeURI == null || completeURI.length() == 0 || desktopURI == null || desktopURI.length() == 0 || pageURI == null || pageURI.length() == 0 || locator == null) {
            throw new IllegalArgumentException();
        }
        this._deviceType = deviceType;
        this._name = name;
        this._ns = namespace;
        this._completeURI = completeURI;
        this._desktopURI = desktopURI;
        this._pageURI = pageURI;
        this._locator = locator;
        this._native = bNative;
        this._compdefs = new ComponentDefinitionMap(ignoreCase);
        boolean replWarned = false;
        Map map = _ldefByName;
        synchronized (map) {
            if (!_ldefByName.containsKey(name) && _ldefByName.containsKey(namespace)) {
                throw new UiException("Different language, " + name + ", with the same namespace, " + namespace);
            }
            _ldefByName.put(namespace, this);
            LanguageDefinition old = _ldefByName.put(name, this);
            if (old != null) {
                List ldefs = (List)_ldefsByClient.get(deviceType);
                if (ldefs != null) {
                    ldefs.remove(old);
                }
                replWarned = true;
                log.warning("Replicated language: " + name + ", overriden by " + this);
            }
        }
        if (extensions != null) {
            map = _ldefsByExt;
            synchronized (map) {
                Iterator it = extensions.iterator();
                while (it.hasNext()) {
                    String ext = (String)it.next();
                    LanguageDefinition old = _ldefsByExt.put(ext, this);
                    if (replWarned || old == null) continue;
                    log.warning("Extension " + ext + ", overriden by " + this);
                }
            }
            this._exts = Collections.unmodifiableList(extensions);
        } else {
            this._exts = Collections.EMPTY_LIST;
        }
        map = _ldefsByClient;
        synchronized (map) {
            LinkedList<LanguageDefinition> ldefs = (LinkedList<LanguageDefinition>)_ldefsByClient.get(deviceType);
            if (ldefs == null) {
                ldefs = new LinkedList<LanguageDefinition>();
                _ldefsByClient.put(deviceType, ldefs);
            }
            ldefs.add(this);
        }
    }

    public String getDeviceType() {
        return this._deviceType;
    }

    public boolean isNative() {
        return this._native;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespace() {
        return this._ns;
    }

    public List getExtensions() {
        return this._exts;
    }

    public Collection getComponentDefinitions() {
        return this._compdefs.getDefinitions();
    }

    public ComponentDefinitionMap getComponentDefinitionMap() {
        return this._compdefs;
    }

    public ComponentDefinition getComponentDefinition(String name) {
        ComponentDefinition compdef = this._compdefs.get(name);
        if (compdef == null) {
            throw new DefinitionNotFoundException("Component definition not found: " + name);
        }
        return compdef;
    }

    public ComponentDefinition getComponentDefinitionIfAny(String name) {
        return this._compdefs.get(name);
    }

    public ComponentDefinition getComponentDefinition(Class klass) {
        ComponentDefinition compdef = this._compdefs.get(klass);
        if (compdef == null) {
            throw new DefinitionNotFoundException("Component definition not found: " + klass);
        }
        return compdef;
    }

    public boolean hasComponentDefinition(String name) {
        return this._compdefs.contains(name);
    }

    public void addComponentDefinition(ComponentDefinition compdef) {
        this._compdefs.add(compdef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitScript(String zslang, String script) {
        if (zslang == null || zslang.length() == 0) {
            throw new IllegalArgumentException("null or empty language");
        }
        if (script != null && script.length() > 0) {
            zslang = zslang.toLowerCase();
            Map map = this._initscripts;
            synchronized (map) {
                String s = (String)this._initscripts.get(zslang);
                this._initscripts.put(zslang, s != null ? s + '\n' + script : script);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInitScript(String zslang) {
        zslang = zslang.toLowerCase();
        Map map = this._initscripts;
        synchronized (map) {
            return (String)this._initscripts.get(zslang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEachTimeScript(String zslang, String script) {
        if (zslang == null || zslang.length() == 0) {
            throw new IllegalArgumentException("null or empty language");
        }
        if (script != null && script.length() > 0) {
            zslang = zslang.toLowerCase();
            Map map = this._eachscripts;
            synchronized (map) {
                String s = (String)this._eachscripts.get(zslang);
                this._eachscripts.put(zslang, s != null ? s + '\n' + script : script);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEachTimeScript(String zslang) {
        zslang = zslang.toLowerCase();
        Map map = this._eachscripts;
        synchronized (map) {
            return (String)this._eachscripts.get(zslang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaScript(JavaScript js) {
        if (js == null) {
            throw new IllegalArgumentException("null js");
        }
        List list = this._js;
        synchronized (list) {
            this._js.add(js);
        }
    }

    public List getJavaScripts() {
        return this._rojs;
    }

    public void addJavaScriptModule(String name, String version) {
        if (name == null || name.length() == 0 || version == null || version.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._jsmods.put(name, version);
    }

    public Map getJavaScriptModules() {
        return this._rojsmods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyleSheet(StyleSheet ss) {
        if (ss == null) {
            throw new IllegalArgumentException("null ss");
        }
        List list = this._ss;
        synchronized (list) {
            this._ss.add(ss);
        }
    }

    public List getStyleSheets() {
        return this._ross;
    }

    public boolean isCaseInsensitive() {
        return this._compdefs.isCaseInsensitive();
    }

    public String getDesktopURI() {
        return this._desktopURI;
    }

    public String getPageURI() {
        return this._pageURI;
    }

    public String getCompleteURI() {
        return this._completeURI;
    }

    public void setMacroTemplate(Class klass, String moldURI) {
        this._macrotmpl = klass != null ? new MacroTemplate(klass, moldURI) : null;
    }

    public ComponentDefinition getMacroDefinition(String name, String macroURI, boolean inline, PageDefinition pgdef) {
        if (this._macrotmpl == null) {
            throw new UiException("Macro not supported by " + this);
        }
        ComponentDefinition compdef = ComponentDefinitionImpl.newMacroDefinition(pgdef != null ? null : this, pgdef, name, this._macrotmpl.klass, macroURI, inline);
        compdef.addMold("default", this._macrotmpl.moldURI, null);
        return compdef;
    }

    public void setNativeTemplate(Class klass) {
        if (klass == null || !Component.class.isAssignableFrom(klass) || !Native.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Illegal native class: " + klass);
        }
        this._nativedef = ComponentDefinitionImpl.newNativeDefinition(this, "native", klass);
    }

    public ComponentDefinition getNativeDefinition() {
        if (this._nativedef == null) {
            throw new UnsupportedOperationException("Native not supported by " + this);
        }
        return this._nativedef;
    }

    public void setLabelTemplate(String compName, String propName, boolean raw) {
        this._labeltmpl = compName != null ? new LabelTemplate(compName, propName, raw) : null;
    }

    public ComponentInfo newLabelInfo(ComponentInfo parent, String text) {
        if (this._labeltmpl == null) {
            throw new UiException("No default label component is supported by " + this);
        }
        return this._labeltmpl.newComponentInfo(parent, text);
    }

    public boolean isRawLabel() {
        return this._labeltmpl != null && this._labeltmpl.raw;
    }

    public void setDynamicTagInfo(String compnm, Set reservedAttrs) {
        if (compnm != null && this._dyntagnm != null) {
            log.warning("Overwriting the definition of dynamic tag. Previous=" + this._dyntagnm + " New=" + compnm + " for " + this);
        }
        this._dyntagnm = compnm;
        this._dyntagDefn = null;
        this._dyntagRvAttrs = compnm == null || reservedAttrs.isEmpty() ? null : Collections.unmodifiableSet(new HashSet(reservedAttrs));
    }

    public ComponentDefinition getDynamicTagDefinition() {
        if (this._dyntagDefn == null) {
            if (this._dyntagnm == null) {
                return null;
            }
            this._dyntagDefn = this.getComponentDefinition(this._dyntagnm);
        }
        return this._dyntagDefn;
    }

    public boolean isDynamicReservedAttributes(String attr) {
        return this._dyntagRvAttrs != null && this._dyntagRvAttrs.contains(attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaglib(Taglib taglib) {
        List list = this._taglibs;
        synchronized (list) {
            this._taglibs.add(taglib);
            this._eval = null;
        }
    }

    public Evaluator getEvaluator() {
        if (this._eval == null) {
            this._eval = this.newEvaluator();
        }
        return this._eval;
    }

    private Evaluator newEvaluator() {
        return new SimpleEvaluator(Taglibs.getFunctionMapper((List)this._taglibs, (Locator)this._locator), null);
    }

    public EvaluatorRef getEvaluatorRef() {
        if (this._evalr == null) {
            this._evalr = this.newEvaluatorRef();
        }
        return this._evalr;
    }

    private EvaluatorRef newEvaluatorRef() {
        return new LangEvalRef(this);
    }

    public String toString() {
        return "[LanguageDefinition: " + this._name + ']';
    }

    private class LabelTemplate {
        private ComponentDefinition _compdef;
        private final String _name;
        private final String _prop;
        private final boolean raw;

        private LabelTemplate(String name, String prop, boolean raw) {
            if (name == null || name.length() == 0 || prop == null || prop.length() == 0) {
                throw new IllegalArgumentException();
            }
            this._name = name;
            this._prop = prop;
            this.raw = raw;
        }

        private ComponentInfo newComponentInfo(ComponentInfo parent, String text) {
            if (this._compdef == null) {
                this._compdef = LanguageDefinition.this.getComponentDefinition(this._name);
            }
            ComponentInfo info = new ComponentInfo((NodeInfo)parent, this._compdef);
            info.addProperty(this._prop, text, null);
            return info;
        }
    }

    private static class MacroTemplate {
        private final Class klass;
        private final String moldURI;

        private MacroTemplate(Class klass, String moldURI) {
            if (moldURI == null || moldURI.length() == 0) {
                throw new IllegalArgumentException("Macro mold UI required");
            }
            if (klass == null || !(class$org$zkoss$zk$ui$Component == null ? (class$org$zkoss$zk$ui$Component = LanguageDefinition.class$("org.zkoss.zk.ui.Component")) : class$org$zkoss$zk$ui$Component).isAssignableFrom(klass) || !(class$org$zkoss$zk$ui$ext$Macro == null ? (class$org$zkoss$zk$ui$ext$Macro = LanguageDefinition.class$("org.zkoss.zk.ui.ext.Macro")) : class$org$zkoss$zk$ui$ext$Macro).isAssignableFrom(klass)) {
                throw new IllegalArgumentException("Illegal macro class: " + klass);
            }
            this.klass = klass;
            this.moldURI = moldURI;
        }
    }
}

