/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.DynamicTag;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.EventHandler;
import org.zkoss.zk.ui.metainfo.EventHandlerMap;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.ZkInfo;
import org.zkoss.zk.ui.metainfo.impl.MultiComposer;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.ui.util.ForEach;
import org.zkoss.zk.ui.util.ForEachImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.EvaluatorRef;
import org.zkoss.zk.xel.impl.Utils;

public class ComponentInfo
extends NodeInfo
implements Cloneable,
Condition,
Externalizable {
    private transient EvaluatorRef _evalr;
    private transient NodeInfo _parent;
    private transient ComponentDefinition _compdef;
    private ExValue _impl;
    private List _props;
    private EventHandlerMap _evthds;
    private AnnotationMap _annots;
    private String _tag;
    private ConditionImpl _cond;
    private String _fulfill;
    private ExValue[] _apply;
    private String _forward;
    private ExValue[] _forEach;
    private ExValue[] _forEachInfo;
    private String _replaceableText;
    private static final ThreadLocal _evalRefStack = new ThreadLocal();

    public ComponentInfo(NodeInfo parent, ComponentDefinition compdef, String tag) {
        if (parent == null || compdef == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parent;
        this._compdef = compdef;
        this._tag = tag;
        this._parent.appendChildDirectly(this);
        this._evalr = parent.getEvaluatorRef();
    }

    public ComponentInfo(NodeInfo parent, ComponentDefinition compdef) {
        this(parent, compdef, null);
    }

    public ComponentInfo() {
    }

    public ComponentInfo(EvaluatorRef evalr, ComponentDefinition compdef, String tag) {
        if (compdef == null) {
            throw new IllegalArgumentException();
        }
        this._compdef = compdef;
        this._tag = tag;
        this._evalr = evalr;
    }

    private ComponentInfo(ComponentInfo compInfo) {
        this._parent = compInfo._parent;
        this._children = compInfo._children;
        this._evalr = compInfo._evalr;
        this._compdef = compInfo._compdef;
        this._impl = compInfo._impl;
        this._tag = compInfo._tag;
        this._cond = compInfo._cond;
        this._fulfill = compInfo._fulfill;
        this._apply = compInfo._apply;
        this._forward = compInfo._forward;
        this._forEach = compInfo._forEach;
        this._forEachInfo = compInfo._forEachInfo;
        this._replaceableText = compInfo._replaceableText;
        this.dupProps(compInfo);
    }

    private void dupProps(ComponentInfo compInfo) {
        if (compInfo._annots != null) {
            this._annots = (AnnotationMap)compInfo._annots.clone();
        }
        if (compInfo._props != null) {
            this._props = new LinkedList(compInfo._props);
        }
        if (compInfo._evthds != null) {
            this._evthds = (EventHandlerMap)compInfo._evthds.clone();
        }
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._compdef.getLanguageDefinition();
    }

    public ComponentDefinition getComponentDefinition() {
        return this._compdef;
    }

    public void appendChild(TextInfo text) {
        if (!(this instanceof NativeInfo) && !(this instanceof ZkInfo)) {
            throw new IllegalStateException("NativeInfo or <zk> required");
        }
        this.appendChildDirectly(text);
    }

    public String getTag() {
        return this._tag;
    }

    public void setParent(NodeInfo parent) {
        if (this._parent != null) {
            this._parent.removeChildDirectly(this);
        }
        this._parent = parent;
        if (this._parent != null) {
            this._parent.appendChildDirectly(this);
        }
    }

    void setParentDirectly(NodeInfo parent) {
        this._parent = parent;
    }

    public String getTextAs() {
        return this._compdef.getTextAs();
    }

    public boolean isBlankPreserved() {
        return this._compdef.isBlankPreserved();
    }

    public String getReplaceableText() {
        return this._replaceableText;
    }

    public void setReplaceableText(String text) {
        this._replaceableText = text;
    }

    public String getFulfill() {
        return this._fulfill;
    }

    public void setFulfill(String fulfill) {
        this._fulfill = fulfill != null && fulfill.length() > 0 ? fulfill : null;
    }

    public Composer resolveComposer(Page page, Component comp) {
        ExValue[] defapply = this._compdef.getParsedApply();
        if (this._apply == null && defapply == null) {
            return null;
        }
        try {
            LinkedList composers = new LinkedList();
            Evaluator eval = this.getEvaluator();
            ComponentInfo.toComposers(composers, defapply, eval, page, comp);
            ComponentInfo.toComposers(composers, this._apply, eval, page, comp);
            return MultiComposer.getComposer(page, composers.toArray(new Composer[composers.size()]));
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public Composer getComposer(Page page) {
        return this.getComposer(page, null);
    }

    public Composer getComposer(Page page, Component comp) {
        return this.resolveComposer(page, comp);
    }

    private static void toComposers(List composers, ExValue[] apply, Evaluator eval, Page page, Component comp) throws Exception {
        if (apply != null) {
            for (int j = 0; j < apply.length; ++j) {
                ComponentInfo.toComposer(composers, page, comp != null ? apply[j].getValue(eval, comp) : apply[j].getValue(eval, page));
            }
        }
    }

    private static void toComposer(List composers, Page page, Object o) throws Exception {
        String s;
        if (o instanceof String && (s = (String)o).indexOf(44) >= 0) {
            o = CollectionsX.parse(null, (String)s, (char)',');
        }
        if (o instanceof Collection) {
            Iterator it = ((Collection)o).iterator();
            while (it.hasNext()) {
                Composer cp = ComponentInfo.toComposer(page, it.next());
                if (cp == null) continue;
                composers.add(cp);
            }
            return;
        }
        if (o instanceof Object[]) {
            Object[] ary = (Object[])o;
            for (int j = 0; j < ary.length; ++j) {
                Composer cp = ComponentInfo.toComposer(page, ary[j]);
                if (cp == null) continue;
                composers.add(cp);
            }
            return;
        }
        Composer cp = ComponentInfo.toComposer(page, o);
        if (cp != null) {
            composers.add(cp);
        }
    }

    private static Composer toComposer(Page page, Object o) throws Exception {
        if (o instanceof String) {
            String clsnm = ((String)o).trim();
            o = page != null ? page.resolveClass(clsnm).newInstance() : Classes.newInstanceByThread((String)clsnm);
        } else if (o instanceof Class) {
            o = ((Class)o).newInstance();
        }
        return (Composer)o;
    }

    public String getApply() {
        if (this._apply == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < this._apply.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(this._apply[j].getRawValue());
        }
        return sb.toString();
    }

    public void setApply(String apply) {
        this._apply = Utils.parseList(apply, Object.class, true);
    }

    public String getForward() {
        return this._forward;
    }

    public void setForward(String forward) {
        this._forward = forward != null && forward.length() > 0 ? forward : null;
    }

    public List getProperties() {
        return this._props != null ? this._props : Collections.EMPTY_LIST;
    }

    public void addProperty(String name, String value, ConditionImpl cond) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this._props == null) {
            this._props = new LinkedList();
        }
        this._props.add(new Property(this._evalr, name, value, cond));
    }

    public void addProperty(String name, NativeInfo value, ConditionImpl cond) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this._props == null) {
            this._props = new LinkedList();
        }
        this._props.add(new Property(this._evalr, name, value, cond));
    }

    public void addEventHandler(String name, ZScript zscript, ConditionImpl cond) {
        if (name == null || zscript == null) {
            throw new IllegalArgumentException("name and zscript cannot be null");
        }
        EventHandler evthd = new EventHandler(this._evalr, zscript, cond);
        if (this._evthds == null) {
            this._evthds = new EventHandlerMap();
        }
        this._evthds.add(name, evthd);
    }

    public Set getEventHandlerNames() {
        return this._evthds != null ? this._evthds.getEventNames() : Collections.EMPTY_SET;
    }

    public void setCondition(ConditionImpl cond) {
        this._cond = cond;
    }

    public boolean withCondition() {
        return this._cond != null;
    }

    public ForEach resolveForEach(Page page, Component comp) {
        return this._forEach == null ? null : (comp != null ? ForEachImpl.getInstance(this._evalr, comp, this._forEach, this._forEachInfo[0], this._forEachInfo[1]) : ForEachImpl.getInstance(this._evalr, page, this._forEach, this._forEachInfo[0], this._forEachInfo[1]));
    }

    public ForEach getForEach(Page page, Component comp) {
        return this.resolveForEach(page, comp);
    }

    public void setForEach(String expr, String begin, String end) {
        ExValue[] exValueArray;
        this._forEach = Utils.parseList(expr, Object.class, false);
        if (this._forEach == null) {
            exValueArray = null;
        } else {
            ExValue[] exValueArray2 = new ExValue[2];
            exValueArray2[0] = begin != null && begin.length() > 0 ? new ExValue(begin, Integer.class) : null;
            exValueArray = exValueArray2;
            exValueArray2[1] = end != null && end.length() > 0 ? new ExValue(end, Integer.class) : null;
        }
        this._forEachInfo = exValueArray;
    }

    public boolean withForEach() {
        return this._forEach != null;
    }

    public String getImplementationClass() {
        return this.getImplementation();
    }

    public void setImplementationClass(String clsnm) {
        this.setImplementation(clsnm);
    }

    public String getImplementation() {
        return this._impl != null ? this._impl.getRawValue() : null;
    }

    public void setImplementation(String expr) {
        this._impl = expr != null && expr.length() > 0 ? new ExValue(expr, Object.class) : null;
    }

    public Component newInstance(Page page, Component parent) {
        Component comp;
        Object impl = this.evalImpl(page, parent);
        ComponentsCtrl.setCurrentInfo(this);
        try {
            comp = impl instanceof Class ? this._compdef.newInstance((Class)impl) : (impl instanceof Component ? (Component)impl : this._compdef.newInstance(page, (String)impl));
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
        finally {
            ComponentsCtrl.setCurrentInfo((ComponentInfo)null);
        }
        if (comp instanceof DynamicTag) {
            ((DynamicTag)((Object)comp)).setTag(this._tag);
        }
        return comp;
    }

    private Object evalImpl(Page page, Component parent) {
        return this._impl == null ? null : (parent != null ? this._impl.getValue(this.getEvaluator(), parent) : this._impl.getValue(this.getEvaluator(), page));
    }

    public Component newInstance(Page page) {
        return this.newInstance(page, null);
    }

    public Class resolveImplementationClass(Page page, Component parent) throws ClassNotFoundException {
        Object impl = this.evalImpl(page, parent);
        return impl instanceof Class ? (Class)impl : (impl instanceof Component ? impl.getClass() : this._compdef.resolveImplementationClass(page, (String)impl));
    }

    public Class resolveImplementationClass(Page page) throws ClassNotFoundException {
        return this.resolveImplementationClass(page, null);
    }

    public AnnotationMap getAnnotationMap() {
        return this._annots;
    }

    public void applyProperties(Component comp) {
        this._compdef.applyProperties(comp);
        if (this._evthds != null) {
            ((ComponentCtrl)((Object)comp)).addSharedEventHandlerMap(this._evthds);
        }
        if (this._props != null) {
            Iterator it = this._props.iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                prop.assign(comp);
            }
        }
    }

    public Map evalProperties(Map propmap, Page owner, Component parent, boolean defIncluded) {
        if (defIncluded) {
            propmap = this._compdef.evalProperties(propmap, owner, parent);
        } else if (propmap == null) {
            propmap = new HashMap();
        }
        if (this._props != null) {
            Iterator it = this._props.iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                if (parent != null) {
                    if (!prop.isEffective(parent)) continue;
                    propmap.put(prop.getName(), prop.getValue(parent));
                    continue;
                }
                if (!prop.isEffective(owner)) continue;
                propmap.put(prop.getName(), prop.getValue(owner));
            }
        }
        return propmap;
    }

    public void addAnnotation(String annotName, Map annotAttrs) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(annotName, annotAttrs);
    }

    public void addAnnotation(String propName, String annotName, Map annotAttrs) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(propName, annotName, annotAttrs);
    }

    public Evaluator getEvaluator() {
        return this._evalr.getEvaluator();
    }

    public ComponentInfo duplicate() {
        return new DupComponentInfo(this);
    }

    public boolean isEffective(Component comp) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, comp);
    }

    public boolean isEffective(Page page) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, page);
    }

    public PageDefinition getPageDefinition() {
        return this._evalr.getPageDefinition();
    }

    public NodeInfo getParent() {
        return this._parent;
    }

    protected EvaluatorRef getEvaluatorRef() {
        return this._evalr;
    }

    public Object clone() {
        try {
            ComponentInfo info = (ComponentInfo)super.clone();
            info._parent = null;
            info.dupProps(this);
            return info;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64).append("[ComponentInfo: ").append(this._compdef.getName());
        if (this._tag != null) {
            sb.append(" <").append(this._tag).append('>');
        }
        return sb.append(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeExternal(ObjectOutput out) throws IOException {
        if (ComponentInfo.getSerializingEvalRef() != this._evalr) {
            ComponentInfo.pushSerializingEvalRef(this._evalr);
            try {
                out.writeObject(this._evalr);
                this.writeMembers(out);
            }
            finally {
                ComponentInfo.popSerializingEvalRef();
            }
        } else {
            out.writeObject(null);
            this.writeMembers(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._evalr = (EvaluatorRef)in.readObject();
        EvaluatorRef top = ComponentInfo.getSerializingEvalRef();
        if (this._evalr == null) {
            this._evalr = top;
        }
        if (this._evalr != null && top != this._evalr) {
            ComponentInfo.pushSerializingEvalRef(this._evalr);
            try {
                this.readMembers(in);
            }
            finally {
                ComponentInfo.popSerializingEvalRef();
            }
        } else {
            this.readMembers(in);
        }
    }

    private void writeMembers(ObjectOutput out) throws IOException {
        out.writeObject(this._children);
        LanguageDefinition langdef = this._compdef.getLanguageDefinition();
        if (langdef != null) {
            out.writeObject(langdef.getName());
            out.writeObject(this._compdef.getName());
        } else {
            out.writeObject(this._compdef);
        }
        out.writeObject(this._impl);
        out.writeObject(this._props);
        out.writeObject(this._evthds);
        out.writeObject(this._annots);
        out.writeObject(this._tag);
        out.writeObject(this._cond);
        out.writeObject(this._fulfill);
        out.writeObject(this._apply);
        out.writeObject(this._forward);
        out.writeObject(this._forEach);
        out.writeObject(this._forEachInfo);
    }

    private void readMembers(ObjectInput in) throws IOException, ClassNotFoundException {
        this._children = (List)in.readObject();
        Iterator it = this._children.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ComponentInfo)) continue;
            ((ComponentInfo)o).setParentDirectly(this);
        }
        Object v = in.readObject();
        if (v instanceof String) {
            LanguageDefinition langdef = LanguageDefinition.lookup((String)v);
            this._compdef = langdef.getComponentDefinition((String)in.readObject());
        } else {
            this._compdef = (ComponentDefinition)v;
        }
        this._impl = (ExValue)in.readObject();
        this._props = (List)in.readObject();
        this._evthds = (EventHandlerMap)in.readObject();
        this._annots = (AnnotationMap)in.readObject();
        this._tag = (String)in.readObject();
        this._cond = (ConditionImpl)in.readObject();
        this._fulfill = (String)in.readObject();
        this._apply = (ExValue[])in.readObject();
        this._forward = (String)in.readObject();
        this._forEach = (ExValue[])in.readObject();
        this._forEachInfo = (ExValue[])in.readObject();
    }

    static final void writeEvalRef(ObjectOutputStream s, EvaluatorRef evalr) throws IOException {
        s.writeObject(ComponentInfo.getSerializingEvalRef() != evalr ? evalr : null);
    }

    static final EvaluatorRef readEvalRef(ObjectInputStream s) throws IOException, ClassNotFoundException {
        EvaluatorRef evalr = (EvaluatorRef)s.readObject();
        return evalr != null ? evalr : ComponentInfo.getSerializingEvalRef();
    }

    private static final EvaluatorRef getSerializingEvalRef() {
        List stack = (List)_evalRefStack.get();
        return stack == null || stack.isEmpty() ? null : (EvaluatorRef)stack.get(0);
    }

    private static final void pushSerializingEvalRef(EvaluatorRef evalr) {
        LinkedList<EvaluatorRef> stack = (LinkedList<EvaluatorRef>)_evalRefStack.get();
        if (stack == null) {
            stack = new LinkedList<EvaluatorRef>();
            _evalRefStack.set(stack);
        }
        stack.add(0, evalr);
    }

    private static final void popSerializingEvalRef() {
        ((List)_evalRefStack.get()).remove(0);
    }

    private static class DupComponentInfo
    extends ComponentInfo {
        private DupComponentInfo(ComponentInfo compInfo) {
            super(compInfo);
        }

        public void appendChild(ZScript zscript) {
            throw new UnsupportedOperationException();
        }

        public void appendChild(VariablesInfo variables) {
            throw new UnsupportedOperationException();
        }

        public void appendChild(AttributesInfo custAttrs) {
            throw new UnsupportedOperationException();
        }

        public void appendChild(ComponentInfo compInfo) {
            throw new UnsupportedOperationException();
        }

        public boolean removeChild(ZScript zscript) {
            throw new UnsupportedOperationException();
        }

        public boolean removeChild(VariablesInfo variables) {
            throw new UnsupportedOperationException();
        }

        public boolean removeChild(AttributesInfo custAttrs) {
            throw new UnsupportedOperationException();
        }

        public boolean removeChild(ComponentInfo compInfo) {
            throw new UnsupportedOperationException();
        }

        void appendChildDirectly(Object child) {
            throw new UnsupportedOperationException();
        }

        boolean removeChildDirectly(Object child) {
            throw new UnsupportedOperationException();
        }

        public void appendChild(TextInfo text) {
            throw new UnsupportedOperationException();
        }
    }
}

