/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.impl.SimpleDesktopCache;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.SessionCtrl;

public class SessionDesktopCacheProvider
implements DesktopCacheProvider {
    private WebApp _wapp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopCache getDesktopCache(Session sess) {
        SessionCtrl sessCtrl = (SessionCtrl)((Object)sess);
        DesktopCache dc = sessCtrl.getDesktopCache();
        if (dc == null) {
            SessionDesktopCacheProvider sessionDesktopCacheProvider = this;
            synchronized (sessionDesktopCacheProvider) {
                dc = sessCtrl.getDesktopCache();
                if (dc == null) {
                    dc = new SimpleDesktopCache(this._wapp.getConfiguration());
                    sessCtrl.setDesktopCache(dc);
                }
            }
        }
        return dc;
    }

    public void sessionDestroyed(Session sess) {
        SessionCtrl sessCtrl = (SessionCtrl)((Object)sess);
        DesktopCache dc = sessCtrl.getDesktopCache();
        if (dc != null) {
            sessCtrl.setDesktopCache(null);
            dc.stop();
        }
    }

    public void sessionWillPassivate(Session sess) {
        DesktopCache dc = ((SessionCtrl)((Object)sess)).getDesktopCache();
        if (dc != null) {
            dc.sessionWillPassivate(sess);
        }
    }

    public void sessionDidActivate(Session sess) {
        DesktopCache dc = ((SessionCtrl)((Object)sess)).getDesktopCache();
        if (dc != null) {
            dc.sessionDidActivate(sess);
        }
    }

    public void start(WebApp wapp) {
        this._wapp = wapp;
    }

    public void stop(WebApp wapp) {
        this._wapp = null;
    }
}

