/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.RequestQueue;

public class RequestQueueImpl
implements RequestQueue {
    private static final Log log = Log.lookup((Class)RequestQueueImpl.class);
    private final List _requests = new LinkedList();
    private List _pfreqIds;

    public void addPerfRequestId(String requestId) {
        if (this._pfreqIds == null) {
            this._pfreqIds = new LinkedList();
        }
        this._pfreqIds.add(requestId);
    }

    public Collection clearPerfRequestIds() {
        List old = this._pfreqIds;
        this._pfreqIds = null;
        return old;
    }

    public boolean isEmpty() {
        while (!this._requests.isEmpty()) {
            if (RequestQueueImpl.isObsolete((AuRequest)this._requests.get(0))) {
                this._requests.remove(0);
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isObsolete(AuRequest request) {
        Component comp = request.getComponent();
        if (comp != null) {
            Desktop dt = comp.getDesktop();
            return dt != null && dt != request.getDesktop();
        }
        return false;
    }

    public AuRequest nextRequest() {
        while (!this._requests.isEmpty()) {
            AuRequest request = (AuRequest)this._requests.remove(0);
            if (RequestQueueImpl.isObsolete(request)) continue;
            return request;
        }
        return null;
    }

    public void addRequests(Collection requests) {
        Iterator it = requests.iterator();
        while (it.hasNext()) {
            AuRequest request = (AuRequest)it.next();
            try {
                request.activate();
                if (RequestQueueImpl.isObsolete(request)) continue;
                this.addRequest(request);
            }
            catch (ComponentNotFoundException ex) {
                if (!log.debugable()) continue;
                log.debug("Ignore request: " + ex.getMessage());
            }
        }
    }

    private void addRequest(AuRequest request) {
        int last;
        AuRequest req2;
        Command cmd;
        int flags;
        int last2 = this._requests.size() - 1;
        if (last2 < 0) {
            this._requests.add(request);
            return;
        }
        AuRequest req22 = (AuRequest)this._requests.get(last2);
        if ((req22.getCommand().getFlags() & 2) != 0) {
            this._requests.remove(last2);
            if (last2 == 0) {
                this._requests.add(request);
                return;
            }
        }
        if (((flags = (cmd = request.getCommand()).getFlags()) & 8) != 0) {
            String uuid = this.getUuid(request);
            Iterator it = this._requests.iterator();
            while (it.hasNext()) {
                AuRequest req23 = (AuRequest)it.next();
                if (req23.getCommand() != cmd || !Objects.equals((Object)this.getUuid(req23), (Object)uuid)) continue;
                it.remove();
                break;
            }
        } else if ((flags & 0x10) != 0 && (req2 = (AuRequest)this._requests.get(last = this._requests.size() - 1)).getCommand() == cmd && Objects.equals((Object)this.getUuid(req2), (Object)this.getUuid(request))) {
            this._requests.remove(last);
        }
        this._requests.add(request);
    }

    private String getUuid(AuRequest request) {
        Component comp = request.getComponent();
        if (comp != null) {
            return comp.getUuid();
        }
        Page page = request.getPage();
        if (page != null) {
            return page.getUuid();
        }
        return null;
    }
}

