/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;

public abstract class AbstractPage
implements Page,
PageCtrl,
Serializable {
    private transient AbstractComponent _firstRoot;
    private transient AbstractComponent _lastRoot;
    private int _nRoot;
    private transient Collection _roots;
    private transient Map _fellows;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractPage() {
        this.init();
    }

    private void init() {
        this._roots = new Roots();
        this._fellows = new HashMap();
    }

    public Component getFirstRoot() {
        return this._firstRoot;
    }

    public Component getLastRoot() {
        return this._lastRoot;
    }

    public boolean hasFellow(String compId) {
        return this._fellows.containsKey(compId);
    }

    public Component getFellow(String compId) {
        Component comp = (Component)this._fellows.get(compId);
        if (comp == null) {
            if (compId != null && ComponentsCtrl.isAutoId(compId)) {
                throw new ComponentNotFoundException(MZk.AUTO_ID_NOT_LOCATABLE, compId);
            }
            throw new ComponentNotFoundException("Fellow component not found: " + compId);
        }
        return comp;
    }

    public Component getFellowIfAny(String compId) {
        return (Component)this._fellows.get(compId);
    }

    public Collection getFellows() {
        return Collections.unmodifiableCollection(this._fellows.values());
    }

    public void addFellow(Component comp) {
        String compId = comp.getId();
        if (!$assertionsDisabled && ComponentsCtrl.isAutoId(compId)) {
            throw new AssertionError();
        }
        Component old = this._fellows.put(compId, comp);
        if (old != comp && old != null) {
            this._fellows.put(old.getId(), old);
            throw new InternalError("Called shall prevent replicated ID for roots");
        }
    }

    public void removeFellow(Component comp) {
        this._fellows.remove(comp.getId());
    }

    public void addRoot(Component comp) {
        if (!$assertionsDisabled && comp.getParent() != null) {
            throw new AssertionError();
        }
        AbstractComponent nc = (AbstractComponent)comp;
        if (this._firstRoot == nc || nc._next != null || nc._prev != null) {
            return;
        }
        if (this._lastRoot == null) {
            this._firstRoot = this._lastRoot = nc;
            nc._prev = null;
            nc._next = null;
        } else {
            this._lastRoot._next = nc;
            nc._prev = this._lastRoot;
            nc._next = null;
            this._lastRoot = nc;
        }
        ++this._nRoot;
    }

    public void removeRoot(Component comp) {
        if (!($assertionsDisabled || comp.getParent() == null && comp.getPage() == this)) {
            throw new AssertionError();
        }
        AbstractComponent oc = (AbstractComponent)comp;
        if (this._firstRoot != oc && oc._next == null && oc._prev == null) {
            return;
        }
        this.setNext(oc._prev, oc._next);
        this.setPrev(oc._next, oc._prev);
        oc._prev = null;
        oc._next = null;
        --this._nRoot;
    }

    private final void setNext(AbstractComponent comp, AbstractComponent next) {
        if (comp != null) {
            comp._next = next;
        } else {
            this._firstRoot = next;
        }
    }

    private final void setPrev(AbstractComponent comp, AbstractComponent prev) {
        if (comp != null) {
            comp._prev = prev;
        } else {
            this._lastRoot = prev;
        }
    }

    public void moveRoot(Component comp, Component refRoot) {
        if (!($assertionsDisabled || comp.getPage() == this && comp.getParent() == null)) {
            throw new AssertionError();
        }
        AbstractComponent nc = (AbstractComponent)comp;
        if (nc._next == refRoot) {
            return;
        }
        this.setNext(nc._prev, nc._next);
        this.setPrev(nc._next, nc._prev);
        --this._nRoot;
        if (refRoot != null) {
            AbstractComponent ref = (AbstractComponent)refRoot;
            this.setNext(nc, ref);
            this.setPrev(nc, ref._prev);
            this.setNext(ref._prev, nc);
            this.setPrev(ref, nc);
            ++this._nRoot;
        } else {
            this.addRoot(nc);
        }
    }

    public Collection getRoots() {
        return this._roots;
    }

    public void removeComponents() {
        AbstractComponent c = this._lastRoot;
        while (c != null) {
            AbstractComponent p = c._prev;
            c.detach();
            c = p;
        }
    }

    public void destroy() {
        this._firstRoot = null;
        this._nRoot = 0;
        this._fellows = new HashMap(1);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AbstractComponent p = this._firstRoot;
        while (p != null) {
            s.writeObject(p);
            p = p._next;
        }
        s.writeObject(null);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        AbstractComponent q = null;
        while (true) {
            AbstractComponent child;
            if ((child = (AbstractComponent)s.readObject()) == null) break;
            if (q != null) {
                q._next = child;
            } else {
                this._firstRoot = child;
            }
            child._prev = q;
            child._page = this;
            q = child;
        }
        this._lastRoot = q;
        this.fixFellows(this.getRoots());
    }

    private final void fixFellows(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            String compId = comp.getId();
            if (!ComponentsCtrl.isAutoId(compId)) {
                this.addFellow(comp);
            }
            if (comp instanceof IdSpace) continue;
            this.fixFellows(comp.getChildren());
        }
    }

    static {
        $assertionsDisabled = !AbstractPage.class.desiredAssertionStatus();
    }

    private static class RootIter
    implements Iterator {
        private AbstractComponent _p;

        private RootIter(AbstractComponent first) {
            this._p = first;
        }

        public boolean hasNext() {
            return this._p != null;
        }

        public Object next() {
            AbstractComponent c = this._p;
            this._p = this._p._next;
            return c;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Roots
    extends AbstractCollection {
        private Roots() {
        }

        public int size() {
            return AbstractPage.this._nRoot;
        }

        public Iterator iterator() {
            return new RootIter(AbstractPage.this._firstRoot);
        }
    }
}

