/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.util.AbstractNamespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;

public class SimpleNamespace
extends AbstractNamespace {
    private Namespace _parent;
    private final Map _vars = new HashMap(8);
    private final Component _owner;

    public SimpleNamespace() {
        this._owner = null;
    }

    public SimpleNamespace(Component owner) {
        this._owner = owner;
    }

    public void copy(Namespace ns) {
        Iterator it = ns.getVariableNames().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object value = ns.getVariable(name, true);
            this._vars.put(name, value);
            this.notifyAdd(name, value);
        }
    }

    public Component getOwner() {
        return this._owner;
    }

    public Page getOwnerPage() {
        return this._owner != null ? this._owner.getPage() : null;
    }

    public Set getVariableNames() {
        return this._vars.keySet();
    }

    public boolean containsVariable(String name, boolean local) {
        return this._vars.containsKey(name) || this._owner != null && this._owner.getFellowIfAny(name) != null || !local && this._parent != null && this._parent.containsVariable(name, false);
    }

    public Object getVariable(String name, boolean local) {
        Object val = this._vars.get(name);
        if (val != null || this._vars.containsKey(name)) {
            return val;
        }
        if (this._owner != null && (val = this._owner.getFellowIfAny(name)) != null) {
            return val;
        }
        return local || this._parent == null ? null : this._parent.getVariable(name, false);
    }

    public void setVariable(String name, Object value, boolean local) {
        if (!local && this._parent != null && !this._vars.containsKey(name)) {
            Namespace p = this._parent;
            do {
                if (!p.getVariableNames().contains(name)) continue;
                p.setVariable(name, value, true);
                return;
            } while ((p = p.getParent()) != null);
        }
        this._vars.put(name, value);
        this.notifyAdd(name, value);
    }

    public void unsetVariable(String name, boolean local) {
        if (this._vars.remove(name) != null || this._vars.containsKey(name)) {
            this.notifyRemove(name);
        } else if (!local && this._parent != null) {
            for (Namespace p = this._parent; p != null; p = p.getParent()) {
                if (p.getVariableNames().contains(name)) {
                    p.unsetVariable(name, true);
                    break;
                }
                if ((p = p.getParent()) == null) break;
            }
        }
    }

    public Namespace getParent() {
        return this._parent;
    }

    public void setParent(Namespace parent) {
        if (this._parent != parent) {
            for (Namespace p = parent; p != null; p = p.getParent()) {
                if (p != this) continue;
                throw new IllegalArgumentException("Recursive namespace: " + this + " with " + parent);
            }
            this._parent = parent;
            this.notifyParentChanged(parent);
        }
    }
}

