/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.NamespaceChangeListener;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.scripting.bsh.NSWrap;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;

public class BSHInterpreter
extends GenericInterpreter
implements SerializableAware,
HierachicalAware {
    static final Log log = Log.lookup((Class)BSHInterpreter.class);
    private static final String VAR_NSW = "z_bshnsw";
    private Interpreter _ip;
    private GlobalNS _bshns;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$bsh$BshMethod;

    protected void loadDefaultImports(NameSpace bshns) {
    }

    protected void exec(String script) {
        try {
            Namespace ns = this.getCurrent();
            if (ns != null) {
                this._ip.eval(script, this.prepareNS(ns));
            } else {
                this._ip.eval(script);
            }
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected boolean contains(String name) {
        try {
            return this._ip.getNameSpace().getVariable(name) != Primitive.VOID;
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected Object get(String name) {
        try {
            return Primitive.unwrap((Object)this._ip.get(name));
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected void set(String name, Object val) {
        try {
            this._ip.set(name, val);
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected void unset(String name) {
        try {
            this._ip.unset(name);
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected boolean contains(Namespace ns, String name) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            try {
                return bshns.getVariable(name) != Primitive.VOID;
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return this.contains(name);
    }

    protected Object get(Namespace ns, String name) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            try {
                return Primitive.unwrap((Object)bshns.getVariable(name));
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return this.get(name);
    }

    protected void set(Namespace ns, String name, Object val) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            try {
                bshns.setVariable(name, val != null ? val : Primitive.NULL, false);
                return;
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        this.set(name, val);
    }

    protected void unset(Namespace ns, String name) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            bshns.unsetVariable(name);
            return;
        }
        this.unset(name);
    }

    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        this._ip = new Interpreter();
        this._ip.setClassLoader(Thread.currentThread().getContextClassLoader());
        this._bshns = new GlobalNS(this._ip.getClassManager(), "global");
        this._ip.setNameSpace((NameSpace)this._bshns);
    }

    public void destroy() {
        this.getOwner().getNamespace().unsetVariable(VAR_NSW, false);
        try {
            this._bshns.clear();
            this._ip.setNameSpace(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._ip = null;
        this._bshns = null;
        super.destroy();
    }

    public Object getNativeInterpreter() {
        return this._ip;
    }

    public Class getClass(String clsnm) {
        try {
            return this._bshns.getClass(clsnm);
        }
        catch (UtilEvalError ex) {
            throw new UiException("Failed to load class " + clsnm, (Throwable)ex);
        }
    }

    public Function getFunction(String name, Class[] argTypes) {
        return this.getFunction0(this._bshns, name, argTypes);
    }

    public Function getFunction(Namespace ns, String name, Class[] argTypes) {
        return this.getFunction0(this.prepareNS(ns), name, argTypes);
    }

    private Function getFunction0(NameSpace bshns, String name, Class[] argTypes) {
        try {
            BshMethod m = bshns.getMethod(name, argTypes != null ? argTypes : new Class[]{}, false);
            return m != null ? new BSHFunction(m) : null;
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private NameSpace prepareNS(Namespace ns) {
        if (ns == this.getOwner().getNamespace()) {
            return this._bshns;
        }
        NSWrap nsw = (NSWrap)ns.getVariable(VAR_NSW, true);
        if (nsw != null) {
            return nsw.unwrap(ns);
        }
        NS bshns = this.newNS(ns);
        ns.setVariable(VAR_NSW, NSWrap.getInstance(bshns), true);
        return bshns;
    }

    NS newNS(Namespace ns) {
        Namespace p = ns.getParent();
        return new NS((NameSpace)(p != null ? this.prepareNS(p) : this._bshns), this._ip.getClassManager(), ns);
    }

    private static NameSpace prepareDetachedNS(Namespace ns) {
        NSWrap nsw = (NSWrap)ns.getVariable(VAR_NSW, true);
        if (nsw != null) {
            return nsw.unwrap(ns);
        }
        Namespace p = ns.getParent();
        NS bshns = new NS(p != null ? BSHInterpreter.prepareDetachedNS(p) : null, null, ns);
        ns.setVariable(VAR_NSW, NSWrap.getInstance(bshns), true);
        return bshns;
    }

    static BSHInterpreter getInterpreter(Namespace ns) {
        Page owner = ns.getOwnerPage();
        if (owner != null) {
            Iterator it = owner.getLoadedInterpreters().iterator();
            while (it.hasNext()) {
                Object ip = it.next();
                if (!(ip instanceof BSHInterpreter)) continue;
                return (BSHInterpreter)ip;
            }
        }
        return null;
    }

    public void write(ObjectOutputStream s, SerializableAware.Filter filter) throws IOException {
        BSHInterpreter.write(this._bshns, s, filter);
    }

    public void read(ObjectInputStream s) throws IOException, ClassNotFoundException {
        BSHInterpreter.read(this._bshns, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void write(NameSpace ns, ObjectOutputStream s, SerializableAware.Filter filter) throws IOException {
        block34: {
            boolean acs;
            Field f;
            block32: {
                int j;
                int j2;
                String[] vars = ns.getVariableNames();
                int n = j2 = vars != null ? vars.length : 0;
                while (--j2 >= 0) {
                    String nm = vars[j2];
                    if (nm == null || "bsh".equals(nm)) continue;
                    try {
                        Object val = ns.getVariable(nm, false);
                        if (val != null && !(val instanceof Serializable) && !(val instanceof Externalizable) || filter != null && !filter.accept(nm, val)) continue;
                        s.writeObject(nm);
                        s.writeObject(val);
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored failure to write " + nm, ex);
                    }
                }
                s.writeObject(null);
                BshMethod[] mtds = ns.getMethods();
                int n2 = j = mtds != null ? mtds.length : 0;
                while (--j >= 0) {
                    Object var13_26;
                    String nm = mtds[j].getName();
                    if (filter != null && !filter.accept(nm, mtds[j])) continue;
                    Field f2 = null;
                    boolean acs2 = false;
                    try {
                        try {
                            Object var11_25;
                            f2 = Classes.getAnyField((Class)(class$bsh$BshMethod == null ? BSHInterpreter.class$("bsh.BshMethod") : class$bsh$BshMethod), (String)"declaringNameSpace");
                            acs2 = f2.isAccessible();
                            Fields.setAccessible((AccessibleObject)f2, (boolean)true);
                            Object old = f2.get(mtds[j]);
                            try {
                                f2.set(mtds[j], null);
                                s.writeObject(mtds[j]);
                                var11_25 = null;
                            }
                            catch (Throwable throwable) {
                                var11_25 = null;
                                f2.set(mtds[j], old);
                                throw throwable;
                            }
                            f2.set(mtds[j], old);
                            var13_26 = null;
                            if (f2 == null) continue;
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        catch (Throwable ex) {
                            log.warning("Ignored failure to write " + nm, ex);
                            var13_26 = null;
                            if (f2 == null) continue;
                            Fields.setAccessible((AccessibleObject)f2, (boolean)acs2);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var13_26 = null;
                        if (f2 != null) {
                            Fields.setAccessible((AccessibleObject)f2, (boolean)acs2);
                        }
                        throw throwable;
                    }
                    Fields.setAccessible((AccessibleObject)f2, (boolean)acs2);
                }
                s.writeObject(null);
                f = null;
                acs = false;
                try {
                    Object var15_29;
                    try {
                        f = Classes.getAnyField((Class)NameSpace.class, (String)"importedClasses");
                        acs = f.isAccessible();
                        Fields.setAccessible((AccessibleObject)f, (boolean)true);
                        Map clses = (Map)f.get(ns);
                        if (clses != null) {
                            Iterator it = clses.values().iterator();
                            while (it.hasNext()) {
                                String clsnm = (String)it.next();
                                if (clsnm.startsWith("bsh.")) continue;
                                s.writeObject(clsnm);
                            }
                        }
                        var15_29 = null;
                        if (f == null) break block32;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored failure to write imported classes", ex);
                        var15_29 = null;
                        if (f != null) {
                            Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_30 = null;
                    if (f != null) {
                        Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                    }
                    throw throwable;
                }
                Fields.setAccessible((AccessibleObject)f, (boolean)acs);
            }
            s.writeObject(null);
            f = null;
            acs = false;
            try {
                try {
                    f = Classes.getAnyField((Class)NameSpace.class, (String)"importedPackages");
                    acs = f.isAccessible();
                    Fields.setAccessible((AccessibleObject)f, (boolean)true);
                    Collection pkgs = (Collection)f.get(ns);
                    if (pkgs != null) {
                        Iterator it = pkgs.iterator();
                        while (it.hasNext()) {
                            String pkgnm = (String)it.next();
                            if (pkgnm.startsWith("java.awt") || pkgnm.startsWith("javax.swing")) continue;
                            s.writeObject(pkgnm);
                        }
                    }
                    Object var17_32 = null;
                    if (f == null) break block34;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    log.warning("Ignored failure to write imported packages", ex);
                    Object var17_33 = null;
                    if (f != null) {
                        Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                Object var17_34 = null;
                if (f != null) {
                    Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                }
                throw throwable;
            }
            Fields.setAccessible((AccessibleObject)f, (boolean)acs);
        }
        s.writeObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void read(NameSpace ns, ObjectInputStream s) throws IOException {
        String nm;
        while (true) {
            try {
                while ((nm = (String)s.readObject()) != null) {
                    ns.setVariable(nm, s.readObject(), false);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warning("Ignored failure to read", ex);
                continue;
            }
            break;
        }
        while (true) {
            try {
                BshMethod mtd;
                while ((mtd = (BshMethod)s.readObject()) != null) {
                    block23: {
                        Object var6_13;
                        Field f = null;
                        boolean acs = false;
                        try {
                            f = Classes.getAnyField((Class)(class$bsh$BshMethod == null ? BSHInterpreter.class$("bsh.BshMethod") : class$bsh$BshMethod), (String)"declaringNameSpace");
                            acs = f.isAccessible();
                            Fields.setAccessible((AccessibleObject)f, (boolean)true);
                            f.set(mtd, ns);
                            var6_13 = null;
                            if (f == null) break block23;
                        }
                        catch (Throwable throwable) {
                            var6_13 = null;
                            if (f == null) throw throwable;
                            Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                            throw throwable;
                        }
                        Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                    }
                    ns.setMethod(mtd.getName(), mtd);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warning("Ignored failure to read", ex);
                continue;
            }
            break;
        }
        while (true) {
            try {
                while ((nm = (String)s.readObject()) != null) {
                    ns.importClass(nm);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warning("Ignored failure to read", ex);
                continue;
            }
            break;
        }
        while (true) {
            try {
                while (true) {
                    if ((nm = (String)s.readObject()) == null) {
                        return;
                    }
                    ns.importPackage(nm);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warning("Ignored failure to read", ex);
                continue;
            }
            break;
        }
    }

    private class BSHFunction
    implements Function {
        private final BshMethod _method;

        private BSHFunction(BshMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("null");
            }
            this._method = method;
        }

        public Class[] getParameterTypes() {
            return this._method.getParameterTypes();
        }

        public Class getReturnType() {
            return this._method.getReturnType();
        }

        public Object invoke(Object obj, Object[] args) throws Exception {
            return this._method.invoke(args != null ? args : new Object[]{}, BSHInterpreter.this._ip);
        }

        public Method toMethod() {
            return null;
        }
    }

    private static class NSCListener
    implements NamespaceChangeListener {
        private final NS _bshns;

        private NSCListener(NS bshns) {
            this._bshns = bshns;
        }

        public void onAdd(String name, Object value) {
        }

        public void onRemove(String name) {
        }

        public void onParentChanged(Namespace newparent) {
            if (newparent != null) {
                BSHInterpreter ip = BSHInterpreter.getInterpreter(this._bshns._ns);
                this._bshns.setParent(ip != null ? ip.prepareNS(newparent) : BSHInterpreter.prepareDetachedNS(newparent));
                return;
            }
            this._bshns.setParent(null);
        }
    }

    static class NS
    extends AbstractNS {
        private Namespace _ns;

        private NS(NameSpace parent, BshClassManager classManager, Namespace ns) {
            super(parent, classManager, "ns" + System.identityHashCode(ns));
            this._ns = ns;
            this._ns.addChangeListener(new NSCListener(this));
        }

        protected Object getFromNamespace(String name) {
            BSHInterpreter ip = BSHInterpreter.getInterpreter(this._ns);
            if (ip != null && ip.getCurrent() == null) {
                return BSHInterpreter.getImplicit(name);
            }
            Object v = this._ns.getVariable(name, true);
            return v != null || this._ns.containsVariable(name, true) ? v : BSHInterpreter.getImplicit(name);
        }
    }

    private class GlobalNS
    extends AbstractNS {
        private GlobalNS(BshClassManager classManager, String name) {
            super(null, classManager, name);
        }

        protected Object getFromNamespace(String name) {
            if (BSHInterpreter.this.getCurrent() == null) {
                return BSHInterpreter.getImplicit(name);
            }
            Namespace ns = BSHInterpreter.this.getOwner().getNamespace();
            Object v = ns.getVariable(name, true);
            return v != null || ns.containsVariable(name, true) ? v : BSHInterpreter.getImplicit(name);
        }

        public void loadDefaultImports() {
            BSHInterpreter.this.loadDefaultImports(this);
        }
    }

    private static abstract class AbstractNS
    extends NameSpace {
        private boolean _inGet;

        protected AbstractNS(NameSpace parent, BshClassManager classManager, String name) {
            super(parent, classManager, name);
        }

        protected abstract Object getFromNamespace(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Variable getVariableImpl(String name, boolean recurse) throws UtilEvalError {
            Variable var = super.getVariableImpl(name, false);
            if (!this._inGet && var == null) {
                Object v = this.getFromNamespace(name);
                if (v != GenericInterpreter.UNDEFINED) {
                    this._inGet = true;
                    try {
                        this.setVariable(name, v != null ? v : Primitive.NULL, false);
                        var = super.getVariableImpl(name, false);
                        this.unsetVariable(name);
                        Object var6_5 = null;
                        this._inGet = false;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this._inGet = false;
                        throw throwable;
                    }
                }
                if (var == null && recurse) {
                    NameSpace parent = this.getParent();
                    if (parent instanceof AbstractNS) {
                        var = ((AbstractNS)parent).getVariableImpl(name, true);
                    } else if (parent != null) {
                        try {
                            Method m = (class$bsh$NameSpace == null ? (class$bsh$NameSpace = BSHInterpreter.class$("bsh.NameSpace")) : class$bsh$NameSpace).getDeclaredMethod("getVariableImpl", class$java$lang$String == null ? (class$java$lang$String = BSHInterpreter.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
                            m.setAccessible(true);
                            var = (Variable)m.invoke((Object)parent, name, Boolean.TRUE);
                        }
                        catch (Exception ex) {
                            throw UiException.Aide.wrap(ex);
                        }
                    }
                }
            }
            return var;
        }

        public void loadDefaultImports() {
        }
    }
}

