/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.fn;

import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Locales;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.zk.fn.JspFns;
import org.zkoss.zk.fn.ZkFns;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class DspFns {
    private static final CacheMap _datejs = new CacheMap(8);

    public static String outZkHtmlTags(String deviceType) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            return ZkFns.outZkHtmlTags(exec, null, null);
        }
        return JspFns.outZkHtmlTags(ServletFns.getCurrentServletContext(), (HttpServletRequest)ServletFns.getCurrentRequest(), (HttpServletResponse)ServletFns.getCurrentResponse(), deviceType);
    }

    public static final String outDeviceStyleSheets(String deviceType) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            return ZkFns.outDeviceStyleSheets(exec, null, null);
        }
        return JspFns.outDeviceStyleSheets(ServletFns.getCurrentServletContext(), (HttpServletRequest)ServletFns.getCurrentRequest(), (HttpServletResponse)ServletFns.getCurrentResponse(), deviceType);
    }

    public static final String outLocaleJavaScript() {
        Locale locale = Locales.getCurrent();
        return DspFns.outNumberJavaScript(locale) + DspFns.outDateJavaScript(locale);
    }

    private static final String outNumberJavaScript(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        StringBuffer sb = new StringBuffer(128);
        DspFns.appendAssignJavaScript(sb, "zk.GROUPING", symbols.getGroupingSeparator());
        DspFns.appendAssignJavaScript(sb, "zk.DECIMAL", symbols.getDecimalSeparator());
        DspFns.appendAssignJavaScript(sb, "zk.PERCENT", symbols.getPercent());
        DspFns.appendAssignJavaScript(sb, "zk.MINUS", symbols.getMinusSign());
        return sb.toString();
    }

    private static final void appendAssignJavaScript(StringBuffer sb, String nm, char val) {
        char quot = val == '\"' ? (char)'\'' : '\"';
        sb.append(nm).append('=').append(quot).append(val).append(quot).append(";\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String outDateJavaScript(Locale locale) {
        CacheMap cacheMap = _datejs;
        synchronized (cacheMap) {
            String djs = (String)_datejs.get((Object)locale);
            if (djs != null) {
                return djs;
            }
        }
        String djs = DspFns.getDateJavaScript(locale);
        CacheMap cacheMap2 = _datejs;
        synchronized (cacheMap2) {
            Iterator it = _datejs.values().iterator();
            while (it.hasNext()) {
                String val = (String)it.next();
                if (!val.equals(djs)) continue;
                djs = val;
            }
            _datejs.put((Object)locale, (Object)djs);
        }
        return djs;
    }

    private static final String getDateJavaScript(Locale locale) {
        StringBuffer sb = new StringBuffer(512);
        Calendar cal = Calendar.getInstance(locale);
        cal.clear();
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        sb.append("zk.DOW_1ST=").append(firstDayOfWeek - 1).append(";\n");
        boolean zhlang = locale.getLanguage().equals("zh");
        SimpleDateFormat df = new SimpleDateFormat("E", locale);
        String[] sdow = new String[7];
        String[] s2dow = new String[7];
        int j = firstDayOfWeek;
        for (int k = 0; k < 7; ++k) {
            int len;
            char cc;
            cal.set(7, j);
            sdow[k] = df.format(cal.getTime());
            if (++j > 7) {
                j = 1;
            }
            s2dow[k] = zhlang ? (sdow[k].length() >= 3 ? sdow[k].substring(2) : sdow[k]) : ((cc = sdow[k].charAt((len = sdow[k].length()) - 1)) == '.' || cc == ',' ? sdow[k].substring(0, len - 1) : sdow[k]);
        }
        df = new SimpleDateFormat("EEEE", locale);
        String[] fdow = new String[7];
        int j2 = firstDayOfWeek;
        for (int k = 0; k < 7; ++k) {
            cal.set(7, j2);
            fdow[k] = df.format(cal.getTime());
            if (++j2 <= 7) continue;
            j2 = 1;
        }
        df = new SimpleDateFormat("MMM", locale);
        String[] smon = new String[12];
        String[] s2mon = new String[12];
        for (int j3 = 0; j3 < 12; ++j3) {
            int len;
            char cc;
            cal.set(2, j3);
            smon[j3] = df.format(cal.getTime());
            s2mon[j3] = zhlang ? (smon[0].length() >= 2 ? smon[j3].substring(0, smon[j3].length() - 1) : smon[j3]) : ((cc = smon[j3].charAt((len = smon[j3].length()) - 1)) == '.' || cc == ',' ? smon[j3].substring(0, len - 1) : smon[j3]);
        }
        df = new SimpleDateFormat("MMMM", locale);
        String[] fmon = new String[12];
        for (int j4 = 0; j4 < 12; ++j4) {
            cal.set(2, j4);
            fmon[j4] = df.format(cal.getTime());
        }
        DspFns.appendJavaScriptArray(sb, "SDOW", sdow);
        if (Objects.equals((Object)s2dow, (Object)sdow)) {
            sb.append("zk.S2DOW=zk.SDOW;\n");
        } else {
            DspFns.appendJavaScriptArray(sb, "S2DOW", s2dow);
        }
        if (Objects.equals((Object)fdow, (Object)sdow)) {
            sb.append("zk.FDOW=zk.SDOW;\n");
        } else {
            DspFns.appendJavaScriptArray(sb, "FDOW", fdow);
        }
        DspFns.appendJavaScriptArray(sb, "SMON", smon);
        if (Objects.equals((Object)s2mon, (Object)smon)) {
            sb.append("zk.S2MON=zk.SMON;\n");
        } else {
            DspFns.appendJavaScriptArray(sb, "S2MON", s2mon);
        }
        if (Objects.equals((Object)fmon, (Object)smon)) {
            sb.append("zk.FMON=zk.SMON;\n");
        } else {
            DspFns.appendJavaScriptArray(sb, "FMON", fmon);
        }
        df = new SimpleDateFormat("a", locale);
        cal.set(11, 3);
        String[] ampm = new String[2];
        ampm[0] = df.format(cal.getTime());
        cal.set(11, 15);
        ampm[1] = df.format(cal.getTime());
        DspFns.appendJavaScriptArray(sb, "APM", ampm);
        return sb.toString();
    }

    private static final void appendJavaScriptArray(StringBuffer sb, String varnm, String[] vals) {
        sb.append("zk.").append(varnm).append("=[");
        int j = 0;
        while (true) {
            sb.append('\"').append(Strings.escape((String)vals[j], (String)"\\\"")).append('\"');
            if (++j >= vals.length) break;
            sb.append(',');
        }
        sb.append("];\n");
    }

    public static void setCacheControl(String prop, int hours) {
        JspFns.setCacheControl((HttpServletResponse)ServletFns.getCurrentResponse(), prop, hours);
    }

    public static void setCSSCacheControl() {
        JspFns.setCSSCacheControl((HttpServletResponse)ServletFns.getCurrentResponse());
    }

    public static void setCWRCacheControl() {
        JspFns.setCWRCacheControl((HttpServletResponse)ServletFns.getCurrentResponse());
    }

    static {
        _datejs.setLifetime(86400000);
    }
}

