/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.idom.Verifier;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.http.HttpAuWriter;
import org.zkoss.zk.ui.UiException;

public class AuWriters {
    private static Class _awCls;
    public static final String CONTENT_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String CONTENT_TYPE = "text/xml;charset=UTF-8";

    public static Class getImplementationClass() {
        return _awCls != null ? _awCls : HttpAuWriter.class;
    }

    public static void setImplementationClass(Class cls) {
        if (cls != null) {
            if (cls.equals(HttpAuWriter.class)) {
                cls = null;
            } else if (!AuWriter.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(cls + " must implement " + AuWriter.class.getName());
            }
        }
        _awCls = cls;
    }

    public static AuWriter newInstance() throws UiException {
        if (_awCls != null) {
            try {
                return (AuWriter)_awCls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return new HttpAuWriter();
    }

    public static void writeResponseId(Writer out, int resId) throws IOException {
        out.write("<rid>");
        out.write(Integer.toString(resId));
        out.write("</rid>\n");
    }

    public static void write(Writer out, AuResponse response) throws IOException {
        out.write("\n<r><c>");
        out.write(response.getCommand());
        out.write("</c>");
        String[] data = response.getData();
        if (data != null) {
            for (int j = 0; j < data.length; ++j) {
                out.write("\n<d>");
                AuWriters.encodeXML(out, data[j]);
                out.write("</d>");
            }
        }
        out.write("\n</r>");
    }

    private static void encodeXML(Writer out, String data) throws IOException {
        if (data == null || data.length() == 0) {
            return;
        }
        int k = 0;
        int len = data.length();
        int j = 0;
        while (j < len) {
            char cc = data.charAt(j);
            if (cc == ']') {
                if (j + 2 < len && data.charAt(j + 1) == ']' && data.charAt(j + 2) == '>') {
                    AuWriters.encodeByCData(out, data.substring(k, j + 2));
                    out.write("&gt;");
                    k = j += 3;
                    continue;
                }
            } else if (!Verifier.isXMLCharacter((char)cc)) {
                AuWriters.encodeByCData(out, data.substring(k, j));
                out.write(63);
                k = ++j;
                continue;
            }
            ++j;
        }
        if (k < len) {
            AuWriters.encodeByCData(out, data.substring(k));
        }
    }

    private static void encodeByCData(Writer out, String data) throws IOException {
        int j = data.length();
        if (j > 100) {
            out.write("<![CDATA[");
            out.write(data);
            out.write("]]>");
            return;
        }
        while (--j >= 0) {
            char cc = data.charAt(j);
            if (cc != '<' && cc != '>' && cc != '&') continue;
            out.write("<![CDATA[");
            out.write(data);
            out.write("]]>");
            return;
        }
        out.write(data);
    }
}

