/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.Serializable;
import java.net.URL;
import java.security.Principal;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.test.TestDeployer;

public class TestDeployerJBoss
implements TestDeployer {
    private static final String MAIN_DEPLOYER = "jboss.system:service=MainDeployer";
    private MBeanServerConnection server;
    private String username;
    private String password;

    public TestDeployerJBoss(MBeanServerConnection server) {
        this.server = server;
        this.username = System.getProperty("jmx.authentication.username");
        if ("${jmx.authentication.username}".equals(this.username)) {
            this.username = null;
        }
        this.password = System.getProperty("jmx.authentication.password");
        if ("${jmx.authentication.password}".equals(this.password)) {
            this.password = null;
        }
    }

    public void deploy(URL url) throws Exception {
        this.invokeMainDeployer("deploy", url);
    }

    public void undeploy(URL url) throws Exception {
        this.invokeMainDeployer("undeploy", url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMainDeployer(String methodName, URL url) throws Exception {
        Principal prevUsername = null;
        Object prevPassword = null;
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        SecurityAdaptor securityAdaptor = ((SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class)).newSecurityAdapter();
        if (this.username != null || this.password != null) {
            prevUsername = securityAdaptor.getPrincipal();
            prevPassword = securityAdaptor.getCredential();
            securityAdaptor.setPrincipal((Principal)new SimplePrincipal(this.username));
            securityAdaptor.setCredential((Object)this.password);
        }
        try {
            this.server.invoke(new ObjectName(MAIN_DEPLOYER), methodName, new Object[]{url}, new String[]{"java.net.URL"});
        }
        finally {
            if (this.username != null || this.password != null) {
                securityAdaptor.setPrincipal(prevUsername);
                securityAdaptor.setCredential(prevPassword);
            }
        }
    }

    public static class SimplePrincipal
    implements Principal,
    Serializable {
        private String name;

        public SimplePrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

