/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.IOException;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;

public abstract class ClassType
extends CompoundType {
    private ClassType parent;

    public ClassType getSuperclass() {
        return this.parent;
    }

    public void print(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        if (this.isInner()) {
            writer.p("// " + this.getTypeDescription() + " (INNER)");
        } else {
            writer.p("// " + this.getTypeDescription());
        }
        writer.pln(" (" + this.getRepositoryID() + ")\n");
        this.printPackageOpen(writer, useIDLNames);
        if (!useIDLNames) {
            writer.p("public ");
        }
        String prefix = "";
        writer.p("class " + this.getTypeName(false, useIDLNames, false));
        if (this.printExtends(writer, useQualifiedNames, useIDLNames, globalIDLNames)) {
            prefix = ",";
        }
        this.printImplements(writer, prefix, useQualifiedNames, useIDLNames, globalIDLNames);
        writer.plnI(" {");
        this.printMembers(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        writer.pln();
        this.printMethods(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        if (useIDLNames) {
            writer.pOln("};");
        } else {
            writer.pOln("}");
        }
        this.printPackageClose(writer, useIDLNames);
    }

    protected void destroy() {
        if (!this.destroyed) {
            super.destroy();
            if (this.parent != null) {
                this.parent.destroy();
                this.parent = null;
            }
        }
    }

    protected ClassType(ContextStack stack, int typeCode, ClassDefinition classDef) {
        super(stack, typeCode, classDef);
        if ((typeCode & 0x4000000) == 0 && classDef.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected ClassType(int typeCode, ClassDefinition classDef, ContextStack stack) {
        super(stack, classDef, typeCode);
        if ((typeCode & 0x4000000) == 0 && classDef.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected ClassType(ContextStack stack, ClassDefinition classDef, int typeCode) {
        super(stack, classDef, typeCode);
        if ((typeCode & 0x4000000) == 0 && classDef.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected void swapInvalidTypes() {
        super.swapInvalidTypes();
        if (this.parent != null && this.parent.getStatus() != 1) {
            this.parent = (ClassType)this.getValidType(this.parent);
        }
    }

    public String addExceptionDescription(String typeDesc) {
        if (this.isException) {
            typeDesc = this.isCheckedException ? typeDesc + " - Checked Exception" : typeDesc + " - Unchecked Exception";
        }
        return typeDesc;
    }

    protected boolean initParents(ContextStack stack) {
        stack.setNewContextCode(11);
        BatchEnvironment env = stack.getEnv();
        boolean result = true;
        try {
            ClassDeclaration parentDecl = this.getClassDefinition().getSuperClass((Environment)env);
            if (parentDecl != null) {
                ClassDefinition parentDef = parentDecl.getClassDefinition((Environment)env);
                this.parent = (ClassType)ClassType.makeType(parentDef.getType(), parentDef, stack);
                if (this.parent == null) {
                    result = false;
                }
            }
        }
        catch (ClassNotFound e) {
            ClassType.classNotFound(stack, e);
            throw new CompilerError("ClassType constructor");
        }
        return result;
    }
}

