/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections;

import com.sun.org.apache.commons.collections.DefaultMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ReferenceMap
extends AbstractMap {
    private static final long serialVersionUID = -3370601314380922368L;
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    private int keyType;
    private int valueType;
    private float loadFactor;
    private transient ReferenceQueue queue = new ReferenceQueue();
    private transient Entry[] table;
    private transient int size;
    private transient int threshold;
    private volatile transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;

    public ReferenceMap() {
        this(0, 1);
    }

    public ReferenceMap(int n, int n2) {
        this(n, n2, 16, 0.75f);
    }

    public ReferenceMap(int n, int n2, int n3, float f) {
        int n4;
        ReferenceMap.verify("keyType", n);
        ReferenceMap.verify("valueType", n2);
        if (n3 <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than 1.");
        }
        this.keyType = n;
        this.valueType = n2;
        for (n4 = 1; n4 < n3; n4 *= 2) {
        }
        this.table = new Entry[n4];
        this.loadFactor = f;
        this.threshold = (int)((float)n4 * f);
    }

    private static void verify(String string, int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(string + " must be HARD, SOFT, WEAK.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.table = new Entry[objectInputStream.readInt()];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
        this.queue = new ReferenceQueue();
        Object object = objectInputStream.readObject();
        while (object != null) {
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            object = objectInputStream.readObject();
        }
    }

    private Object toReference(int n, Object object, int n2) {
        switch (n) {
            case 0: {
                return object;
            }
            case 1: {
                return new SoftRef(n2, object, this.queue);
            }
            case 2: {
                return new WeakRef(n2, object, this.queue);
            }
        }
        throw new Error();
    }

    private Entry getEntry(Object object) {
        if (object == null) {
            return null;
        }
        int n = object.hashCode();
        int n2 = this.indexFor(n);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && object.equals(entry.getKey())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private int indexFor(int n) {
        n += ~(n << 15);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return n & this.table.length - 1;
    }

    private void resize() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2];
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n = this.indexFor(entry2.hash);
                entry2.next = this.table[n];
                this.table[n] = entry2;
            }
            entryArray[i] = null;
        }
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    private void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.purge(reference);
            reference = this.queue.poll();
        }
    }

    private void purge(Reference reference) {
        int n = reference.hashCode();
        int n2 = this.indexFor(n);
        Entry entry = null;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.purge(reference)) {
                if (entry == null) {
                    this.table[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.size;
                return;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
    }

    public int size() {
        this.purge();
        return this.size;
    }

    public boolean isEmpty() {
        this.purge();
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        this.purge();
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return false;
        }
        return entry.getValue() != null;
    }

    public Object get(Object object) {
        this.purge();
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (object2 == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purge();
        if (this.size + 1 > this.threshold) {
            this.resize();
        }
        int n = object.hashCode();
        int n2 = this.indexFor(n);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (n == entry.hash && object.equals(entry.getKey())) {
                Object object3 = entry.getValue();
                entry.setValue(object2);
                return object3;
            }
            entry = entry.next;
        }
        ++this.size;
        ++this.modCount;
        object = this.toReference(this.keyType, object, n);
        object2 = this.toReference(this.valueType, object2, n);
        this.table[n2] = new Entry(object, n, object2, this.table[n2]);
        return null;
    }

    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        this.purge();
        int n = object.hashCode();
        int n2 = this.indexFor(n);
        Entry entry = null;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (n == entry2.hash && object.equals(entry2.getKey())) {
                if (entry == null) {
                    this.table[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.size;
                ++this.modCount;
                return entry2.getValue();
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public Set entrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new AbstractSet(){

            public int size() {
                return ReferenceMap.this.size();
            }

            public void clear() {
                ReferenceMap.this.clear();
            }

            public boolean contains(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = ReferenceMap.this.getEntry(entry.getKey());
                return entry2 != null && ((Object)entry).equals(entry2);
            }

            public boolean remove(Object object) {
                boolean bl = this.contains(object);
                if (bl) {
                    Map.Entry entry = (Map.Entry)object;
                    ReferenceMap.this.remove(entry.getKey());
                }
                return bl;
            }

            public Iterator iterator() {
                return new EntryIterator();
            }

            public Object[] toArray() {
                return this.toArray(new Object[0]);
            }

            public Object[] toArray(Object[] objectArray) {
                ArrayList<DefaultMapEntry> arrayList = new ArrayList<DefaultMapEntry>();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    arrayList.add(new DefaultMapEntry(entry.getKey(), entry.getValue()));
                }
                return arrayList.toArray(objectArray);
            }
        };
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new AbstractSet(){

            public int size() {
                return ReferenceMap.this.size;
            }

            public Iterator iterator() {
                return new KeyIterator();
            }

            public boolean contains(Object object) {
                return ReferenceMap.this.containsKey(object);
            }

            public boolean remove(Object object) {
                Object object2 = ReferenceMap.this.remove(object);
                return object2 != null;
            }

            public void clear() {
                ReferenceMap.this.clear();
            }
        };
        return this.keySet;
    }

    public Collection values() {
        if (this.values != null) {
            return this.values;
        }
        this.values = new AbstractCollection(){

            public int size() {
                return ReferenceMap.this.size;
            }

            public void clear() {
                ReferenceMap.this.clear();
            }

            public Iterator iterator() {
                return new ValueIterator();
            }
        };
        return this.values;
    }

    private class Entry
    implements Map.Entry {
        Object key;
        Object value;
        int hash;
        Entry next;

        public Entry(Object object, int n, Object object2, Entry entry) {
            this.key = object;
            this.hash = n;
            this.value = object2;
            this.next = entry;
        }

        public Object getKey() {
            return ReferenceMap.this.keyType > 0 ? ((Reference)this.key).get() : this.key;
        }

        public Object getValue() {
            return ReferenceMap.this.valueType > 0 ? ((Reference)this.value).get() : this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.getValue();
            if (ReferenceMap.this.valueType > 0) {
                ((Reference)this.value).clear();
            }
            this.value = ReferenceMap.this.toReference(ReferenceMap.this.valueType, object, this.hash);
            return object2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null || v == null) {
                return false;
            }
            return k.equals(this.getKey()) && v.equals(this.getValue());
        }

        public int hashCode() {
            Object object = this.getValue();
            return this.hash ^ (object == null ? 0 : object.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        boolean purge(Reference reference) {
            boolean bl = ReferenceMap.this.keyType > 0 && this.key == reference;
            boolean bl2 = bl = bl || ReferenceMap.this.valueType > 0 && this.value == reference;
            if (bl) {
                if (ReferenceMap.this.keyType > 0) {
                    ((Reference)this.key).clear();
                }
                if (ReferenceMap.this.valueType > 0) {
                    ((Reference)this.value).clear();
                }
            }
            return bl;
        }
    }

    private class EntryIterator
    implements Iterator {
        int index;
        Entry entry;
        Entry previous;
        Object nextKey;
        Object nextValue;
        Object currentKey;
        Object currentValue;
        int expectedModCount;

        public EntryIterator() {
            this.index = ReferenceMap.this.size() != 0 ? ReferenceMap.this.table.length : 0;
            this.expectedModCount = ReferenceMap.this.modCount;
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                Entry entry = this.entry;
                int n = this.index;
                while (entry == null && n > 0) {
                    entry = ReferenceMap.this.table[--n];
                }
                this.entry = entry;
                this.index = n;
                if (entry == null) {
                    this.currentKey = null;
                    this.currentValue = null;
                    return false;
                }
                this.nextKey = entry.getKey();
                this.nextValue = entry.getValue();
                if (!this.nextNull()) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        private void checkMod() {
            if (ReferenceMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean nextNull() {
            return this.nextKey == null || this.nextValue == null;
        }

        protected Entry nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.nextKey = null;
            this.nextValue = null;
            return this.previous;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            this.checkMod();
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            ReferenceMap.this.remove(this.currentKey);
            this.previous = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedModCount = ReferenceMap.this.modCount;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private static class SoftRef
    extends SoftReference {
        private int hash;

        public SoftRef(int n, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private static class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(int n, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

