/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.codegen;

import com.sun.appserv.ClassLoaderUtil;
import com.sun.ejb.codegen.EjbcContext;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JaxrpcMappingDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.io.JaxrpcMappingDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.deployment.util.WebServerInfo;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.webservice.WsCompile;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.codegen.JaxRpcCodegenAdapter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.tools.CompileToolDelegate;
import com.sun.xml.rpc.spi.tools.GeneratedFileInfo;
import com.sun.xml.rpc.spi.tools.J2EEModelInfo;
import com.sun.xml.rpc.spi.tools.ModelFileModelInfo;
import com.sun.xml.rpc.spi.tools.ModelInfo;
import com.sun.xml.rpc.spi.tools.NamespaceMappingInfo;
import com.sun.xml.rpc.spi.tools.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.spi.tools.NoMetadataModelInfo;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.ws.Service;

public class JaxRpcRICodegen
extends ModuleContentLinker
implements JaxRpcCodegenAdapter {
    protected EjbcContext context = null;
    Vector files = new Vector();
    private JaxRpcObjectFactory rpcFactory;
    private Logger logger = WsUtil.getDefaultLogger();
    private int wscompileInvocationCount = 0;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JaxRpcRICodegen.class);
    private com.sun.xml.rpc.spi.tools.CompileTool wscompileForAccept = null;
    private com.sun.xml.rpc.spi.tools.CompileTool wscompileForWebServices = null;
    File dummyConfigFile = null;

    public JaxRpcRICodegen() {
        this.rpcFactory = JaxRpcObjectFactory.newInstance();
    }

    public void run(EjbcContext context) throws Exception {
        this.rootLocation_ = new FileArchive();
        this.rootLocation_.open(context.getSrcDir().getAbsolutePath());
        this.context = context;
        Application application = context.getDescriptor();
        application.visit(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accept(ServiceReferenceDescriptor serviceRef) {
        boolean codegenRequired = false;
        URL wsdlOverride = null;
        boolean wsdlOverriden = false;
        boolean jaxwsClient = false;
        super.accept(serviceRef);
        try {
            ClassLoader clr = serviceRef.getBundleDescriptor().getClassLoader();
            Class<?> serviceInterface = clr.loadClass(serviceRef.getServiceInterface());
            if (Service.class.isAssignableFrom(serviceInterface)) {
                jaxwsClient = true;
            }
            for (ServiceRefPortInfo portInfo : serviceRef.getPortsInfo()) {
                if (!portInfo.isLinkedToPortComponent()) continue;
                WebServiceEndpoint linkedPortComponent = portInfo.getPortComponentLink();
                if (linkedPortComponent == null) {
                    throw new GeneratorException(localStrings.getLocalString("enterprise.webservice.componentlinkunresolved", "The port-component-link {0} cannot be resolved", new Object[]{portInfo.getPortComponentLinkName()}));
                }
                WsUtil wsUtil = new WsUtil();
                WebServerInfo wsi = wsUtil.getWebServerInfo(this.context.getDeploymentRequest());
                URL rootURL = wsi.getWebServerRootURL(linkedPortComponent.isSecure());
                URL actualAddress = linkedPortComponent.composeEndpointAddress(rootURL);
                if (jaxwsClient) {
                    portInfo.addStubProperty("javax.xml.ws.service.endpoint.address", actualAddress.toExternalForm());
                } else {
                    portInfo.addStubProperty("javax.xml.rpc.service.endpoint.address", actualAddress.toExternalForm());
                }
                if (!serviceRef.getBundleDescriptor().getModuleType().equals(ModuleType.CAR) || (wsdlOverride = serviceRef.getWsdlOverride()) == null) continue;
                wsdlOverriden = true;
                serviceRef.setWsdlOverride(linkedPortComponent.getWebService().getWsdlFileUrl());
            }
            if (jaxwsClient) {
                return;
            }
            if (serviceRef.hasGeneratedServiceInterface()) {
                if (!serviceRef.hasWsdlFile() || !serviceRef.hasMappingFile()) throw new GeneratorException("Deployment error for service-ref " + serviceRef.getName() + ".\nService references with generated service " + "interface must include WSDL and mapping information.");
                codegenRequired = true;
            } else if (serviceRef.hasWsdlFile()) {
                if (!serviceRef.hasMappingFile()) throw new GeneratorException("Deployment error for service-ref " + serviceRef.getName() + ".\nService references with wsdl must also have " + "mapping information.");
                codegenRequired = true;
            }
            if (codegenRequired) {
                com.sun.xml.rpc.spi.tools.CompileTool wscompile;
                ModelInfo modelInfo = this.createModelInfo(serviceRef);
                String[] args = this.createJaxrpcCompileArgs(false);
                this.wscompileForAccept = wscompile = this.rpcFactory.createCompileTool((OutputStream)System.out, "wscompile");
                WsCompile delegate = new WsCompile(wscompile, serviceRef);
                delegate.setModelInfo(modelInfo);
                wscompile.setDelegate((CompileToolDelegate)delegate);
                this.jaxrpc(args, delegate, serviceRef, this.files);
            }
            if (!wsdlOverriden) return;
            serviceRef.setWsdlOverride(wsdlOverride);
            return;
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    public void accept(WebService webService) {
        super.accept(webService);
        try {
            if ("1.1".compareTo(webService.getWebServicesDescriptor().getSpecVersion()) < 0) {
                WsUtil wsUtil = new WsUtil();
                Collection<WebServiceEndpoint> endpoints = webService.getEndpoints();
                for (WebServiceEndpoint ep : endpoints) {
                    if (ep.implementedByWebComponent()) {
                        wsUtil.updateServletEndpointRuntime(ep);
                        continue;
                    }
                    wsUtil.validateEjbEndpoint(ep);
                }
            } else {
                this.jaxrpcWebService(webService, this.files);
            }
        }
        catch (Exception e) {
            RuntimeException ge = new RuntimeException(e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    public Iterator getListOfBinaryFiles() {
        return this.files.iterator();
    }

    public Iterator getListOfSourceFiles() {
        return null;
    }

    public void done() {
    }

    private void done(com.sun.xml.rpc.spi.tools.CompileTool wscompile) {
        CompileTool compileTool;
        com.sun.xml.rpc.spi.tools.ProcessorEnvironment env;
        if (wscompile != null && wscompile instanceof CompileTool && (env = (compileTool = (CompileTool)wscompile).getEnvironment()) != null && env instanceof ProcessorEnvironment) {
            ProcessorEnvironment typedEnv = (ProcessorEnvironment)env;
            URLClassLoader urlCL = typedEnv.getClassLoader();
            ClassLoaderUtil.releaseLoader(urlCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JaxrpcMappingDescriptor getJaxrpcMappingInfo(URL mappingFileUrl, Descriptor desc) throws Exception {
        JaxrpcMappingDescriptor mappingDesc = null;
        InputStream is = null;
        try {
            is = mappingFileUrl.openStream();
            JaxrpcMappingDeploymentDescriptorFile jaxrpcDD = new JaxrpcMappingDeploymentDescriptorFile();
            if (desc instanceof ServiceReferenceDescriptor) {
                ServiceReferenceDescriptor srd = (ServiceReferenceDescriptor)desc;
                jaxrpcDD.setDeploymentDescriptorPath(srd.getMappingFileUri());
                jaxrpcDD.setErrorReportingString(srd.getBundleDescriptor().getModuleDescriptor().getArchiveUri());
            }
            if (desc instanceof WebService) {
                WebService ws = (WebService)desc;
                jaxrpcDD.setDeploymentDescriptorPath(ws.getMappingFileUri());
                jaxrpcDD.setErrorReportingString(ws.getBundleDescriptor().getModuleDescriptor().getArchiveUri());
            }
            jaxrpcDD.setXMLValidationLevel(Deployer.getValidationLevel());
            mappingDesc = (JaxrpcMappingDescriptor)jaxrpcDD.read(desc, is);
            Object var8_7 = null;
            if (is == null) return mappingDesc;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return mappingDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJaxrpcRIModelFile(URL mappingFileUrl) {
        boolean isModel = false;
        InputStream is = null;
        try {
            is = mappingFileUrl.openStream();
            isModel = this.rpcFactory.createXMLModelFileFilter().isModelFile(is);
            return isModel;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private ModelInfo createModelInfo(WebService webService) throws Exception {
        ModelFileModelInfo modelInfo = null;
        URL mappingFileUrl = webService.getMappingFile().toURL();
        modelInfo = this.createModelFileModelInfo(mappingFileUrl);
        if (this.isJaxrpcRIModelFile(mappingFileUrl)) {
            this.debug("000. JaxrpcRIModelFile.");
            modelInfo = this.createModelFileModelInfo(mappingFileUrl);
        } else {
            JaxrpcMappingDescriptor mappingDesc = this.getJaxrpcMappingInfo(mappingFileUrl, webService);
            if (mappingDesc.isSimpleMapping()) {
                this.debug("111. SimpleMapping.");
                modelInfo = this.createNoMetadataModelInfo(webService, mappingDesc);
            } else {
                this.debug("222. FullMapping .");
                modelInfo = this.createFullMappingModelInfo(webService);
            }
        }
        return modelInfo;
    }

    private ModelInfo createModelInfo(ServiceReferenceDescriptor serviceRef) throws Exception {
        JaxrpcMappingDescriptor mappingDesc;
        Object modelInfo = null;
        URL mappingFileUrl = serviceRef.getMappingFile().toURL();
        modelInfo = this.isJaxrpcRIModelFile(mappingFileUrl) ? this.createModelFileModelInfo(mappingFileUrl) : ((mappingDesc = this.getJaxrpcMappingInfo(mappingFileUrl, serviceRef)).isSimpleMapping() && serviceRef.hasGeneratedServiceInterface() ? this.createNoMetadataModelInfo(serviceRef, mappingDesc) : this.createFullMappingModelInfo(serviceRef));
        return modelInfo;
    }

    private ModelFileModelInfo createModelFileModelInfo(URL modelFileUrl) throws Exception {
        ModelFileModelInfo modelInfo = this.rpcFactory.createModelFileModelInfo();
        modelInfo.setLocation(modelFileUrl.toExternalForm());
        return modelInfo;
    }

    private J2EEModelInfo createFullMappingModelInfo(WebService webService) throws Exception {
        URL mappingFileUrl = webService.getMappingFile().toURL();
        URL wsdlFileUrl = webService.getWsdlFileUrl();
        return this.createFullMappingModelInfo(mappingFileUrl, wsdlFileUrl);
    }

    private J2EEModelInfo createFullMappingModelInfo(ServiceReferenceDescriptor serviceRef) throws Exception {
        URL mappingFileUrl = serviceRef.getMappingFile().toURL();
        URL wsdlFileUrl = serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : serviceRef.getWsdlFileUrl();
        return this.createFullMappingModelInfo(mappingFileUrl, wsdlFileUrl);
    }

    private J2EEModelInfo createFullMappingModelInfo(URL mappingFile, URL wsdlFile) throws Exception {
        J2EEModelInfo modelInfo = this.rpcFactory.createJ2EEModelInfo(mappingFile);
        modelInfo.setLocation(wsdlFile.toExternalForm());
        modelInfo.setJavaPackageName("package_ignored");
        return modelInfo;
    }

    private NoMetadataModelInfo createNoMetadataModelInfo(WebService webService, JaxrpcMappingDescriptor mappingDesc) throws Exception {
        NoMetadataModelInfo modelInfo = this.rpcFactory.createNoMetadataModelInfo();
        URL wsdlFileUrl = webService.getWsdlFileUrl();
        Collection<WebServiceEndpoint> endpoints = webService.getEndpoints();
        if (endpoints.size() != 1) {
            throw new GeneratorException("Deployment code generation error for webservice " + webService.getName() + ". " + " jaxrpc-mapping-file is required if web service has " + "multiple endpoints");
        }
        WebServiceEndpoint endpoint = endpoints.iterator().next();
        modelInfo.setLocation(wsdlFileUrl.toExternalForm());
        modelInfo.setInterfaceName(endpoint.getServiceEndpointInterface());
        modelInfo.setPortName(endpoint.getWsdlPort());
        this.addNamespaceMappingRegistry(modelInfo, mappingDesc);
        return modelInfo;
    }

    private void addNamespaceMappingRegistry(NoMetadataModelInfo modelInfo, JaxrpcMappingDescriptor mappingDesc) {
        NamespaceMappingRegistryInfo namespaceRegistry = this.rpcFactory.createNamespaceMappingRegistryInfo();
        modelInfo.setNamespaceMappingRegistry(namespaceRegistry);
        Collection mappings = mappingDesc.getMappings();
        for (JaxrpcMappingDescriptor.Mapping next : mappings) {
            NamespaceMappingInfo namespaceInfo = this.rpcFactory.createNamespaceMappingInfo(next.getNamespaceUri(), next.getPackage());
            namespaceRegistry.addMapping(namespaceInfo);
        }
    }

    private NoMetadataModelInfo createNoMetadataModelInfo(ServiceReferenceDescriptor serviceRef, JaxrpcMappingDescriptor mappingDesc) throws Exception {
        Class<?> serviceInterface;
        Collection seis;
        NoMetadataModelInfo modelInfo = this.rpcFactory.createNoMetadataModelInfo();
        URL wsdlFile = serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : serviceRef.getWsdlFileUrl();
        modelInfo.setLocation(wsdlFile.toExternalForm());
        WsUtil wsUtil = new WsUtil();
        String serviceInterfaceName = serviceRef.getServiceInterface();
        ClassLoader cl = this.context.getDescriptor().getClassLoader();
        if (cl instanceof EJBClassLoader) {
            List moduleList = EJBClassPathUtils.getApplicationClassPath(this.context.getDescriptor(), this.context.getSrcDir().getAbsolutePath());
            Iterator itr = moduleList.iterator();
            while (itr.hasNext()) {
                ((EJBClassLoader)cl).appendURL(new File((String)itr.next()));
            }
        }
        if ((seis = wsUtil.getSEIsFromGeneratedService(serviceInterface = cl.loadClass(serviceInterfaceName))).size() == 0) {
            throw new GeneratorException("Invalid Generated Service Interface " + serviceInterfaceName + " . ");
        }
        if (seis.size() > 1) {
            throw new GeneratorException("Deployment error : If no jaxrpc-mapping file is provided, Generated Service Interface must have only 1 Service Endpoint Interface");
        }
        String serviceEndpointInterface = (String)seis.iterator().next();
        modelInfo.setInterfaceName(serviceEndpointInterface);
        this.addNamespaceMappingRegistry(modelInfo, mappingDesc);
        return modelInfo;
    }

    private boolean keepJaxrpcGeneratedFile(String fileType, Descriptor desc) {
        boolean keep = true;
        if (fileType.equals("Wsdl") || fileType.equals("RemoteInterface")) {
            keep = false;
        } else if (fileType.equals("Service")) {
            keep = desc instanceof ServiceReferenceDescriptor && ((ServiceReferenceDescriptor)desc).hasGenericServiceInterface();
        }
        return keep;
    }

    private String[] createJaxrpcCompileArgs(boolean generateTies) throws IOException {
        int numJaxrpcArgs = 0;
        numJaxrpcArgs = this.logger.isLoggable(Level.FINE) ? 16 : 11;
        ++this.wscompileInvocationCount;
        String infix = null;
        if (this.wscompileInvocationCount > 1) {
            ++numJaxrpcArgs;
            infix = this.wscompileInvocationCount + "";
        }
        String[] jaxrpcArgs = new String[numJaxrpcArgs];
        int jaxrpcCnt = 0;
        if (this.dummyConfigFile == null) {
            this.dummyConfigFile = File.createTempFile("dummy_wscompile_config", "config");
            this.dummyConfigFile.deleteOnExit();
        }
        String classPath = null;
        String[] urls = this.context.getClasspathUrls();
        Application app = this.context.getDescriptor();
        List moduleList = EJBClassPathUtils.getApplicationClassPath(app, this.context.getSrcDir().getAbsolutePath());
        moduleList.addAll(Arrays.asList(urls));
        for (int i = 0; i < moduleList.size(); ++i) {
            classPath = classPath == null ? (String)moduleList.get(i) : classPath + File.pathSeparatorChar + (String)moduleList.get(i);
        }
        String optionalDependencyClassPath = OptionalPkgDependency.getExtDirFilesAsClasspath();
        if (optionalDependencyClassPath.length() > 0) {
            classPath = optionalDependencyClassPath + File.pathSeparatorChar + classPath;
        }
        jaxrpcArgs[jaxrpcCnt++] = generateTies ? "-gen:server" : "-gen:client";
        jaxrpcArgs[jaxrpcCnt++] = "-f:donotoverride";
        if (infix != null) {
            jaxrpcArgs[jaxrpcCnt++] = "-f:infix:" + infix;
        }
        jaxrpcArgs[jaxrpcCnt++] = "-classpath";
        jaxrpcArgs[jaxrpcCnt++] = classPath;
        if (this.logger.isLoggable(Level.FINE)) {
            long timeStamp = System.currentTimeMillis();
            jaxrpcArgs[jaxrpcCnt++] = "-Xdebugmodel:" + this.context.getStubsDir() + File.separator + "debugModel.txt." + timeStamp;
            jaxrpcArgs[jaxrpcCnt++] = "-Xprintstacktrace";
            jaxrpcArgs[jaxrpcCnt++] = "-model";
            jaxrpcArgs[jaxrpcCnt++] = this.context.getStubsDir() + File.separator + "debugModel.model" + timeStamp;
            jaxrpcArgs[jaxrpcCnt++] = "-verbose";
        }
        jaxrpcArgs[jaxrpcCnt++] = "-s";
        jaxrpcArgs[jaxrpcCnt++] = this.context.getStubsDir().toString();
        jaxrpcArgs[jaxrpcCnt++] = "-d";
        jaxrpcArgs[jaxrpcCnt++] = this.context.getStubsDir().toString();
        jaxrpcArgs[jaxrpcCnt++] = "-keep";
        jaxrpcArgs[jaxrpcCnt++] = "-g";
        jaxrpcArgs[jaxrpcCnt++] = this.dummyConfigFile.getPath();
        if (this.logger.isLoggable(Level.FINE)) {
            for (int i = 0; i < jaxrpcArgs.length; ++i) {
                this.logger.fine(jaxrpcArgs[i]);
            }
        }
        return jaxrpcArgs;
    }

    private void jaxrpc(String[] args, WsCompile wsCompile, Descriptor desc, Vector files) throws Exception {
        block6: {
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.debug("---> ARGS = ");
                    for (int i = 0; i < args.length; ++i) {
                        System.err.print(args[i] + "; ");
                    }
                }
                boolean compiled = wsCompile.getCompileTool().run(args);
                this.done(wsCompile.getCompileTool());
                if (compiled) {
                    for (GeneratedFileInfo next : wsCompile.getGeneratedFiles()) {
                        String fileType = next.getType();
                        File file = next.getFile();
                        String origPath = file.getPath();
                        if (!origPath.endsWith(".java")) continue;
                        int javaIndex = origPath.lastIndexOf(".java");
                        String newPath = origPath.substring(0, javaIndex) + ".class";
                        if (!this.keepJaxrpcGeneratedFile(fileType, desc)) continue;
                        files.add(newPath);
                    }
                    break block6;
                }
                throw new GeneratorException("jaxrpc compilation exception");
            }
            catch (Throwable t) {
                GeneratorException ge = new GeneratorException(t.getMessage());
                ge.initCause(t);
                throw ge;
            }
        }
    }

    private void jaxrpcWebService(WebService webService, Vector files) throws Exception {
        com.sun.xml.rpc.spi.tools.CompileTool wscompile;
        if (webService.getWsdlFileUrl() == null || webService.getMappingFileUri() == null) {
            throw new IASDeploymentException(localStrings.getLocalString("enterprise.webservice.jaxrpcFilesNotFound", "Service {0} seems to be a JAXRPC based web service but without the mandatory WSDL and Mapping file. Deployment cannot proceed", new Object[]{webService.getName()}));
        }
        ModelInfo modelInfo = this.createModelInfo(webService);
        String[] args = this.createJaxrpcCompileArgs(true);
        this.wscompileForWebServices = wscompile = this.rpcFactory.createCompileTool((OutputStream)System.out, "wscompile");
        WsCompile delegate = new WsCompile(wscompile, webService);
        delegate.setModelInfo(modelInfo);
        wscompile.setDelegate((CompileToolDelegate)delegate);
        this.jaxrpc(args, delegate, webService, files);
    }

    private void debug(String msg) {
        if (this.logger.isLoggable(Level.FINE)) {
            System.out.println("[JaxRpcRICodegen] --> " + msg);
        }
    }
}

