/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.corba.ee.spi.codegen.Wrapper;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.enterprise.InjectionException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.VirtualServerInfo;
import com.sun.enterprise.deployment.util.WebServerInfo;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.event.ApplicationLoaderEventNotifier;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InjectionManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.enterprise.webservice.ApplicationLoaderEventListenerImpl;
import com.sun.enterprise.webservice.HandlerResolverImpl;
import com.sun.enterprise.webservice.Import;
import com.sun.enterprise.webservice.PortInfoImpl;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.logging.LogDomains;
import com.sun.tools.ws.spi.WSToolsObjectFactory;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.messaging.saaj.soap.ExpressMessageFactoryImpl;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.model.Model;
import com.sun.xml.rpc.spi.model.Port;
import com.sun.xml.rpc.spi.model.Service;
import com.sun.xml.rpc.spi.runtime.ClientTransportFactory;
import com.sun.xml.rpc.spi.runtime.SOAPConstants;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.StubBase;
import com.sun.xml.rpc.spi.runtime.Tie;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.deploy.shared.ModuleType;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPBinding;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsUtil {
    public static final String CLIENT_TRANSPORT_LOG_PROPERTY = "com.sun.enterprise.webservice.client.transport.log";
    public static final String ENDPOINT_ADDRESS_PARAM_NAME = "endpointAddressParam";
    public final String WSDL_IMPORT_NAMESPACE_PARAM_NAME = "wsdlImportNamespaceParam";
    public static final String WSDL_IMPORT_LOCATION_PARAM_NAME = "wsdlImportLocationParam";
    public static final String WSDL_INCLUDE_LOCATION_PARAM_NAME = "wsdlIncludeLocationParam";
    public final String SCHEMA_IMPORT_NAMESPACE_PARAM_NAME = "schemaImportNamespaceParam";
    public static final String SCHEMA_IMPORT_LOCATION_PARAM_NAME = "schemaImportLocationParam";
    public static final String SCHEMA_INCLUDE_LOCATION_PARAM_NAME = "schemaIncludeLocationParam";
    private static final String ONE_WAY_OPERATION = "com.sun.xml.rpc.server.OneWayOperation";
    private static final String CLIENT_BAD_REQUEST = "com.sun.xml.rpc.server.http.ClientBadRequest";
    private static final String SECURITY_POLICY_NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static Logger deploymentLogger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private JaxRpcObjectFactory rpcFactory = JaxRpcObjectFactory.newInstance();
    private static Logger _logger = null;
    static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WsUtil.class);
    private static boolean readProperty = true;
    private static ExpressMessageFactoryImpl soapMsgFactory = null;
    private static final String EXPRESS_MSG_FACTORY = "com.sun.enterprise.webservice.expressMsgFactory";

    public static void start() {
        WebServiceEngineImpl.getInstance();
        ApplicationLoaderEventListenerImpl listener = ServiceEngineUtil.getListener();
        ApplicationLoaderEventNotifier.getInstance().addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handleGet(HttpServletRequest request, HttpServletResponse response, WebServiceEndpoint endpoint) throws IOException {
        block29: {
            headers = this.getHeaders(request);
            if (this.hasSomeTextXmlContent(headers)) {
                message = "Received HTTP GET containing text/xml  content for endpoint " + endpoint.getEndpointName() + " at " + endpoint.getEndpointAddressUri() + " . HTTP POST should be used instead.";
                this.writeInvalidMethodType(response, message);
                WsUtil.logger.info(message);
                return false;
            }
            wsdlUrl = null;
            requestUriRaw = request.getRequestURI();
            requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
            queryString = request.getQueryString();
            webService = endpoint.getWebService();
            if (queryString == null) {
                wsdlPath = endpoint.getWsdlContentPath(requestUri);
                if (wsdlPath != null) {
                    module = webService.getBundleDescriptor().getModuleDescriptor();
                    if (wsdlPath.equals(webService.getWsdlFileUri())) {
                        wsdlUrl = webService.getWsdlFileUrl();
                    } else if (this.isWsdlContent(wsdlPath, webService.getBundleDescriptor())) {
                        finalWsdlUrl = webService.getWsdlFileUrl();
                        finalWsdlPath = finalWsdlUrl.getPath();
                        wsdlDirPath = finalWsdlPath.substring(0, finalWsdlPath.length() - webService.getWsdlFileUri().length());
                        wsdlDir = new File(wsdlDirPath);
                        wsdlFile = new File(wsdlDir, wsdlPath.replace('/', File.separatorChar));
                        try {
                            wsdlUrl = wsdlFile.toURL();
                        }
                        catch (MalformedURLException mue) {
                            WsUtil.logger.log(Level.INFO, "Failure serving WSDL for " + webService.getName(), mue);
                        }
                    }
                }
            } else if (queryString.equalsIgnoreCase("WSDL")) {
                wsdlUrl = webService.getWsdlFileUrl();
            }
            success = false;
            if (wsdlUrl != null) {
                is = null;
                try {
                    block28: {
                        response.setContentType("text/xml");
                        response.setStatus(200);
                        if (wsdlUrl.toURI().equals(webService.getWsdlFileUrl().toURI())) {
                            try {
                                moduleID = endpoint.getBundleDescriptor().getApplication().getRegistrationName();
                                wsi = this.getWebServerInfo(moduleID, request);
                                url = webService.getWsdlFileUrl();
                                originalWsdlFile = new File(url.getPath() + "__orig");
                                if (!originalWsdlFile.exists()) {
                                    originalWsdlFile = new File(url.getPath());
                                }
                                this.generateFinalWsdl(originalWsdlFile.toURL(), webService, wsi, (OutputStream)response.getOutputStream());
                            }
                            catch (Exception e) {
                                urlCon = wsdlUrl.openConnection();
                                urlCon.setUseCaches(false);
                                is = urlCon.getInputStream();
                                ArchivistUtils.copy(is, (OutputStream)response.getOutputStream());
                            }
                        } else {
                            urlCon = wsdlUrl.openConnection();
                            urlCon.setUseCaches(false);
                            is = urlCon.getInputStream();
                            ArchivistUtils.copy(is, (OutputStream)response.getOutputStream());
                        }
                        success = true;
                        if (!WsUtil.logger.isLoggable(Level.FINE)) break block28;
                        WsUtil.logger.fine("Serving up final wsdl " + wsdlUrl + " for " + request.getRequestURL() + (queryString != null ? "?" + queryString : ""));
                    }
                    var19_22 = null;
                    ** if (is == null) goto lbl-1000
                }
                catch (Throwable var18_28) {
                    var19_24 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw var18_28;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block29;
                    catch (Exception e) {
                        WsUtil.logger.log(Level.INFO, "Failure serving WSDL for web service " + webService.getName(), e);
                        var19_23 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
        }
        if (!success) {
            message = "Invalid wsdl request " + request.getRequestURL() + (queryString != null ? "?" + queryString : "") + " for web service " + webService.getName();
            WsUtil.logger.info(message);
            this.writeInvalidMethodType(response, message);
        }
        return success;
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = this.getWsdlDir(bundle);
        return uri != null && uri.startsWith(wsdlDir);
    }

    public String getWsdlDir(BundleDescriptor bundle) {
        boolean isWar = bundle instanceof WebBundleDescriptor;
        return isWar ? "WEB-INF/wsdl" : "META-INF/wsdl";
    }

    public void setClientTransportLog(ServiceReferenceDescriptor serviceRef, Stub stub, String transportLogUrlStr) {
        try {
            final String logUrlString = transportLogUrlStr;
            OutputStream os = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    URL transportLogUrl = new URL(logUrlString);
                    File transportFile = new File(transportLogUrl.getFile());
                    return new FileOutputStream(transportFile, true);
                }
            });
            ClientTransportFactory transportFactory = this.rpcFactory.createClientTransportFactory(0, os);
            if (stub instanceof StubBase) {
                ((StubBase)stub)._setTransportFactory(transportFactory);
                logger.info("Logging client transport for service-ref " + serviceRef.getName() + " to file " + transportLogUrlStr);
            }
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.INFO, "", pae.getCause());
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void parseRelativeImports(URL wsdlFileUrl, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        block15: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            InputStream is = null;
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
            Object var11_13 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block15;
            }
            catch (IOException io) {}
            break block15;
            {
                catch (SAXParseException spe) {
                    logger.log(Level.SEVERE, "\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
                    Exception x = spe;
                    if (spe.getException() != null) {
                        x = spe.getException();
                    }
                    x.printStackTrace();
                    Object var11_14 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block15;
                    }
                    catch (IOException io) {}
                    break block15;
                }
                catch (Exception sxe) {
                    logger.log(Level.SEVERE, "Error parsing WSDL" + sxe.getMessage());
                    Object var11_15 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block15;
                    }
                    catch (IOException io) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException io) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void addImportsAndIncludes(NodeList list, Collection result, String namespace, String location) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation != null && givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    private void procesSchemaImports(Document document, Collection schemaImportCollection) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection wsdlImportCollection) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection schemaIncludeCollection) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection wsdlIncludesCollection) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, File finalWsdlFile) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(finalWsdlFile));
        this.generateFinalWsdl(wsdlFileUrl, webService, wsi, outputStream);
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, OutputStream outputStream) throws Exception {
        Switch theSwitch = Switch.getSwitch();
        String webServiceName = webService.getName();
        HashSet wsdlRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet schemaIncludes = new HashSet();
        if (webService.hasUrlPublishing()) {
            this.parseRelativeImports(wsdlFileUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        }
        Collection<WebServiceEndpoint> endpoints = webService.getEndpoints();
        ArrayList<WebServiceEndpoint> endpointsCopy = new ArrayList<WebServiceEndpoint>();
        endpointsCopy.addAll(endpoints);
        BundleDescriptor bundle = webService.getBundleDescriptor();
        WebServicesDescriptor wsd = bundle.getWebServices();
        Collection<WebService> webServices = wsd.getWebServices();
        if (webServices.size() > 1) {
            for (WebService aWS : webServices) {
                if (webService.getName().equals(aWS.getName())) continue;
                if (webService.getWsdlFileUri() != null && aWS.getWsdlFileUri() != null && webService.getWsdlFileUri().equals(aWS.getWsdlFileUri())) {
                    endpointsCopy.addAll(aWS.getEndpoints());
                    continue;
                }
                if (webService.getWsdlFileUrl() == null || aWS.getWsdlFileUrl() == null || !webService.getWsdlFileUrl().toString().equals(aWS.getWsdlFileUrl().toString())) continue;
                endpointsCopy.addAll(aWS.getEndpoints());
            }
        }
        BufferedInputStream wsdlInputStream = new BufferedInputStream(wsdlFileUrl.openStream());
        StreamSource XsltWsdlDocument = new StreamSource(wsdlInputStream);
        Templates templates = this.createTemplatesFor(endpointsCopy, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        Transformer transformer = templates.newTransformer();
        WebServiceEndpoint endpointForImport = webService.pickEndpointForRelativeImports();
        URL root = wsi.getWebServerRootURL(endpointForImport.isSecure());
        URL finalWsdlUrl = endpointForImport.composeFinalWsdlUrl(root);
        int wsdlImportNum = 0;
        for (Import next : wsdlRelativeImports) {
            transformer.setParameter("wsdlImportNamespaceParam" + wsdlImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum, relativeUrl);
            ++wsdlImportNum;
        }
        int schemaImportNum = 0;
        for (Import next : schemaRelativeImports) {
            transformer.setParameter("schemaImportNamespaceParam" + schemaImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum, relativeUrl);
            ++schemaImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import next : wsdlIncludes) {
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum, relativeUrl);
            ++wsdlIncludeNum;
        }
        int schemaIncludeNum = 0;
        for (Import next : schemaIncludes) {
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_INCLUDE_LOCATION_PARAM_NAME + schemaIncludeNum, relativeUrl);
            ++schemaIncludeNum;
        }
        int endpointNum = 0;
        for (WebServiceEndpoint next : endpointsCopy) {
            URL rootURL = wsi.getWebServerRootURL(next.isSecure());
            URL actualAddress = next.composeEndpointAddress(rootURL);
            transformer.setParameter(ENDPOINT_ADDRESS_PARAM_NAME + endpointNum, actualAddress.toExternalForm());
            String endpointType = next.implementedByEjbComponent() ? "EJB" : "Servlet";
            deploymentLogger.log(Level.INFO, "enterprise.deployment.endpoint.registration", new Object[]{endpointType, next.getEndpointName(), actualAddress});
            ++endpointNum;
        }
        transformer.transform(XsltWsdlDocument, new StreamResult(outputStream));
        ((InputStream)wsdlInputStream).close();
        outputStream.close();
    }

    public HandlerInfo createHandlerInfo(WebServiceHandler handler, ClassLoader loader) throws Exception {
        QName[] headers = new QName[handler.getSoapHeaders().size()];
        int i = 0;
        Iterator iter = handler.getSoapHeaders().iterator();
        while (iter.hasNext()) {
            headers[i] = (QName)iter.next();
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (NameValuePairDescriptor next : handler.getInitParams()) {
            properties.put(next.getName(), next.getValue());
        }
        Class<?> handlerClass = loader.loadClass(handler.getHandlerClass());
        return new HandlerInfo(handlerClass, properties, headers);
    }

    public URL privilegedGetServiceRefWsdl(ServiceReferenceDescriptor desc) throws Exception {
        URL wsdlFileURL;
        try {
            final ServiceReferenceDescriptor serviceRef = desc;
            wsdlFileURL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    URL retVal = serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : (serviceRef.getWsdlFileUrl() != null ? serviceRef.getWsdlFileUrl() : (serviceRef.getWsdlFileUri().startsWith("http") ? new URL(serviceRef.getWsdlFileUri()) : new File(serviceRef.getWsdlFileUri()).toURL()));
                    return retVal;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return wsdlFileURL;
    }

    public javax.xml.rpc.Service createConfiguredService(ServiceReferenceDescriptor desc) throws Exception {
        ServiceReferenceDescriptor serviceRef = desc;
        javax.xml.rpc.Service service = null;
        try {
            final URL wsdlFileURL = this.privilegedGetServiceRefWsdl(serviceRef);
            final QName serviceName = serviceRef.getServiceName();
            final ServiceFactory serviceFactory = ServiceFactory.newInstance();
            service = (javax.xml.rpc.Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return serviceFactory.createService(wsdlFileURL, serviceName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return service;
    }

    public void configureHandlerChain(ServiceReferenceDescriptor serviceRef, javax.xml.rpc.Service service, Iterator ports, ClassLoader loader) throws Exception {
        if (!serviceRef.hasHandlers()) {
            return;
        }
        HandlerRegistry registry = service.getHandlerRegistry();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            List handlerChain = registry.getHandlerChain(nextPort);
            HashSet soapRoles = new HashSet();
            for (WebServiceHandler nextHandler : serviceRef.getHandlers()) {
                Collection portNames = nextHandler.getPortNames();
                if (!portNames.isEmpty() && !portNames.contains(nextPort.getLocalPart())) continue;
                soapRoles.addAll(nextHandler.getSoapRoles());
                HandlerInfo handlerInfo = this.createHandlerInfo(nextHandler, loader);
                handlerChain.add(handlerInfo);
            }
        }
    }

    private Templates createTemplatesFor(Collection endpoints, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        String importLocationParam;
        String importLocationParam2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        writer.write("<xsl:transform version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:soap12=\"http://schemas.xmlsoap.org/wsdl/soap12/\">\n");
        int wsdlImportNum = 0;
        for (Import next : wsdlRelativeImports) {
            String importNamespaceParam = "wsdlImportNamespaceParam" + wsdlImportNum;
            importLocationParam2 = WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:import[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:import></xsl:template>");
            ++wsdlImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import next : wsdlIncludes) {
            importLocationParam2 = WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum;
            writer.write("<xsl:param name=\"" + importLocationParam2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:include[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:include>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:include></xsl:template>");
            ++wsdlIncludeNum;
        }
        int schemaImportNum = 0;
        for (Import next : schemaRelativeImports) {
            String importNamespaceParam = "schemaImportNamespaceParam" + schemaImportNum;
            importLocationParam = SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:import[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:import></xsl:template>");
            ++schemaImportNum;
        }
        int schemaIncludeNum = 0;
        for (Import next : schemaIncludes) {
            importLocationParam = SCHEMA_INCLUDE_LOCATION_PARAM_NAME + schemaIncludeNum;
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:include[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:include>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:include></xsl:template>");
            ++schemaIncludeNum;
        }
        int endpointNum = 0;
        for (WebServiceEndpoint endpoint : endpoints) {
            if (!endpoint.hasWsdlPort()) {
                throw new Exception("No WSDL port specified for endpoint " + endpoint.getEndpointName());
            }
            if (!endpoint.hasServiceName()) {
                throw new Exception("Runtime settings error.  Cannot find service name for endpoint " + endpoint.getEndpointName());
            }
            String actualAddressParam = ENDPOINT_ADDRESS_PARAM_NAME + endpointNum;
            writer.write("<xsl:param name=\"" + actualAddressParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
            writer.write(endpoint.getServiceName().getNamespaceURI());
            writer.write("']/wsdl:service[@name='");
            writer.write(endpoint.getServiceName().getLocalPart());
            writer.write("']/wsdl:port[@name='");
            writer.write(endpoint.getWsdlPort().getLocalPart());
            writer.write("']/" + endpoint.getSoapAddressPrefix() + ":address\" mode=\"copy\">");
            writer.write("<" + endpoint.getSoapAddressPrefix() + ":address><xsl:attribute name=\"location\"><xsl:value-of select=\"$" + actualAddressParam + "\"/>");
            writer.write("</xsl:attribute></" + endpoint.getSoapAddressPrefix() + ":address></xsl:template>");
            ++endpointNum;
        }
        writer.write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
        writer.write("</xsl:transform>\n");
        writer.close();
        byte[] stylesheet = bos.toByteArray();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(new String(stylesheet));
        }
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheet));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(stylesheetSource);
        return templates;
    }

    public Collection getSEIsFromGeneratedService(Class generatedServiceInterface) throws Exception {
        HashSet<String> seis = new HashSet<String>();
        Method[] declaredMethods = generatedServiceInterface.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method next = declaredMethods[i];
            Class<?> returnType = next.getReturnType();
            if (!next.getName().startsWith("get") || next.getDeclaringClass() == javax.xml.rpc.Service.class || !Remote.class.isAssignableFrom(returnType)) continue;
            seis.add(returnType.getName());
        }
        return seis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File publishFinalWsdl(URL clientPublishUrl, String finalWsdlUri, byte[] finalWsdlBytes) throws Exception {
        File finalWsdlFile = null;
        FileOutputStream fos = null;
        try {
            boolean madeDirs;
            finalWsdlFile = new File(clientPublishUrl.getFile(), finalWsdlUri.replace('/', File.separatorChar));
            File parent = finalWsdlFile.getParentFile();
            if (!parent.exists() && !(madeDirs = parent.mkdirs())) {
                throw new IOException("Error creating " + parent);
            }
            fos = new FileOutputStream(finalWsdlFile);
            fos.write(finalWsdlBytes, 0, finalWsdlBytes.length);
            Object var9_8 = null;
            if (fos == null) return finalWsdlFile;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                logger.log(Level.INFO, "", ioe);
            }
            throw throwable;
        }
        try {
            fos.close();
            return finalWsdlFile;
        }
        catch (IOException ioe) {
            logger.log(Level.INFO, "", ioe);
        }
        return finalWsdlFile;
    }

    public Port getPortFromModel(Model model, QName portName) {
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service next = (Service)serviceIter.next();
            Iterator portIter = next.getPorts();
            while (portIter.hasNext()) {
                Port nextPort = (Port)portIter.next();
                if (!this.portsEqual(nextPort, portName)) continue;
                return nextPort;
            }
        }
        return null;
    }

    public Service getServiceForPort(Model model, QName thePortName) {
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service nextService = (Service)serviceIter.next();
            Iterator portIter = nextService.getPorts();
            while (portIter.hasNext()) {
                Port nextPort = (Port)portIter.next();
                if (!this.portsEqual(nextPort, thePortName)) continue;
                return nextService;
            }
        }
        return null;
    }

    public boolean portsEqual(Port port, QName candidatePortName) {
        boolean equal = false;
        QName portPropertyName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        equal = portPropertyName != null ? candidatePortName.equals(portPropertyName) : candidatePortName.equals(port.getName());
        return equal;
    }

    public Collection getAllPorts(Model model) {
        HashSet ports = new HashSet();
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service next = (Service)serviceIter.next();
            ports.addAll(next.getPortsList());
        }
        return ports;
    }

    public Method getInvMethod(Tie webServiceTie, MessageContext context) throws Exception {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)context;
        SOAPMessage message = soapMsgContext.getMessage();
        StreamingHandler streamingHandler = (StreamingHandler)webServiceTie;
        int opcode = streamingHandler.getOpcodeForRequestMessage(message);
        return streamingHandler.getMethodForOpcode(opcode);
    }

    public void throwSOAPFaultException(String faultString, MessageContext msgContext) {
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        this.throwSOAPFaultException(faultString, soapMessage);
    }

    public void throwSOAPFaultException(String faultString, SOAPMessage soapMessage) throws SOAPFaultException {
        SOAPFaultException sfe = null;
        try {
            SOAPPart sp = soapMessage.getSOAPPart();
            SOAPEnvelope se = sp.getEnvelope();
            SOAPBody sb = se.getBody();
            Iterator iter = sb.getChildElements();
            if (iter.hasNext()) {
                SOAPBodyElement requestBody = (SOAPBodyElement)iter.next();
                requestBody.detachNode();
            }
            SOAPFault soapFault = sb.addFault();
            se.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            String faultActor = "http://schemas.xmlsoap.org/soap/actor/next";
            QName faultCode = SOAPConstants.FAULT_CODE_SERVER;
            soapFault.setFaultCode("env:" + faultCode.getLocalPart());
            soapFault.setFaultString(faultString);
            soapFault.setFaultActor(faultActor);
            sfe = new SOAPFaultException(faultCode, faultActor, faultString, null);
        }
        catch (SOAPException se) {
            logger.log(Level.FINE, "", se);
        }
        if (sfe != null) {
            throw sfe;
        }
    }

    void writeReply(HttpServletResponse response, com.sun.xml.rpc.spi.runtime.SOAPMessageContext messageContext) throws IOException, SOAPException {
        if (this.isMessageContextPropertySet(messageContext, ONE_WAY_OPERATION)) {
            return;
        }
        SOAPMessage reply = messageContext.getMessage();
        boolean statusCode = false;
        if (messageContext.isFailure()) {
            if (this.isMessageContextPropertySet(messageContext, CLIENT_BAD_REQUEST)) {
                response.setStatus(400);
                this.setContentTypeAndFlush(response);
                return;
            }
            response.setStatus(500);
        } else {
            response.setStatus(200);
        }
        ServletOutputStream os = response.getOutputStream();
        String[] headers = reply.getMimeHeaders().getHeader("Content-Type");
        if (headers != null && headers.length > 0) {
            response.setContentType(headers[0]);
        } else {
            response.setContentType("text/xml");
        }
        WsUtil.putHeaders(reply.getMimeHeaders(), response);
        reply.writeTo((OutputStream)os);
        os.flush();
    }

    private static void putHeaders(MimeHeaders headers, HttpServletResponse response) {
        headers.removeHeader("Content-Type");
        headers.removeHeader("Content-Length");
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            response.setHeader(header.getName(), header.getValue());
        }
    }

    public static void raiseException(HttpServletResponse resp, String binding, String faultString) {
        resp.setStatus(500);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding)) {
            resp.setContentType("text/xml");
            try {
                PrintWriter writer = new PrintWriter((OutputStream)resp.getOutputStream());
                writer.println("<error>" + faultString + "</error>");
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Cannot write out a HTTP XML exception : " + ioe.getMessage());
            }
        } else {
            String protocol = "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(binding) ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
            SOAPMessage fault = WsUtil.getSOAPFault(protocol, faultString);
            if (fault != null) {
                resp.setContentType("text/xml");
                try {
                    fault.writeTo((OutputStream)resp.getOutputStream());
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "cannot write SOAPFault to the HTTP response", ex);
                }
            }
        }
    }

    public static SOAPMessage getSOAPFault(String protocol, String faultString) {
        if (protocol == null) {
            protocol = "SOAP 1.1 Protocol";
        }
        try {
            MessageFactory factory = MessageFactory.newInstance((String)protocol);
            if (factory == null) {
                factory = MessageFactory.newInstance();
            }
            SOAPMessage message = factory.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultString(faultString);
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            String envelopeNamespace = envelope.getNamespaceURI();
            QName faultCode = new QName(envelopeNamespace, "Server", "env");
            fault.setFaultCode(faultCode);
            return message;
        }
        catch (SOAPException e) {
            logger.log(Level.WARNING, "Cannot create soap fault for " + faultString);
            return null;
        }
    }

    void writeInvalidContentType(HttpServletResponse response) throws SOAPException, IOException {
        response.setStatus(415);
        this.setContentTypeAndFlush(response);
    }

    void writeInvalidMethodType(HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("Invalid Method Type");
        out.println("</title></head>");
        out.println("<body>");
        out.println(message);
        out.println("</body>");
        out.println("</html>");
    }

    private void writeNotFoundErrorPage(HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("J2EE Web Services");
        out.println("</title></head>");
        out.println("<body>");
        out.println("<h1>404 Not Found: " + message + "</h1>");
        out.println("</body>");
        out.println("</html>");
    }

    private void setContentTypeAndFlush(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.flushBuffer();
        response.getWriter().close();
    }

    boolean hasSomeTextXmlContent(MimeHeaders headers) {
        return this.hasTextXmlContentType(headers) && this.getContentLength(headers) > 0;
    }

    private int getContentLength(MimeHeaders headers) {
        String[] contentLength = headers.getHeader("Content-Length");
        int length = 0;
        if (contentLength != null && contentLength.length > 0) {
            length = new Integer(contentLength[0]);
        }
        return length;
    }

    boolean hasTextXmlContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    boolean isMessageContextPropertySet(com.sun.xml.rpc.spi.runtime.SOAPMessageContext messageContext, String property) {
        Object prop = messageContext.getProperty(property);
        return prop != null && prop instanceof String && ((String)prop).equalsIgnoreCase("true");
    }

    MimeHeaders getHeaders(HttpServletRequest request) {
        Enumeration e = request.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    public WebServerInfo getWebServerInfo(DeploymentRequest request) throws ConfigException {
        String serverTarget = (String)request.getOptionalArguments().get("wsdlTargetHint");
        if (serverTarget == null) {
            return this.getWebServerInfoForDAS(request);
        }
        ConfigContext cc = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        if (cc == null) {
            return this.getWebServerInfoForDAS(request);
        }
        Config config = ServerHelper.getConfigForServer(cc, serverTarget);
        JMXConnectorConfig info = ServerHelper.getJMXConnectorInfo(cc, serverTarget);
        if (config == null || info == null) {
            return this.getWebServerInfoForDAS(request);
        }
        String host = info.getHost();
        return this.getWebServerInfo(cc, config, null, serverTarget, host);
    }

    private WebServerInfo getWebServerInfoForDAS(DeploymentRequest request) {
        WebServerInfo wsi = new WebServerInfo();
        wsi.setHttpVS(new VirtualServerInfo("http", request.getHttpHostName(), request.getHttpPort()));
        wsi.setHttpsVS(new VirtualServerInfo("https", request.getHttpsHostName(), request.getHttpsPort()));
        return wsi;
    }

    public WebServerInfo getWebServerInfo(String moduleID, HttpServletRequest request) throws ConfigException {
        ConfigContext cc = ApplicationServer.getServerContext().getConfigContext();
        Server server = ServerBeansFactory.getServerBean(cc);
        Config config = ServerBeansFactory.getConfigBean(cc);
        ApplicationRef ref = server.getApplicationRefByRef(moduleID);
        return this.getWebServerInfo(cc, config, ref.getVirtualServers(), null, null);
    }

    private WebServerInfo getWebServerInfo(ConfigContext cc, Config config, String virtualServers, String targetName, String targetHostName) throws ConfigException {
        HttpService httpService = config.getHttpService();
        VirtualServer[] vServers = null;
        ArrayList<HttpListener> httpListeners = new ArrayList<HttpListener>();
        if (virtualServers == null) {
            vServers = httpService.getVirtualServer();
            if (vServers != null) {
                for (int i = 0; i < vServers.length; ++i) {
                    String[] httpListenerIDs;
                    String httpListenersString;
                    VirtualServer vs = vServers[i];
                    if (vs.getId().equals("__asadmin") || (httpListenersString = vs.getHttpListeners()) == null || (httpListenerIDs = httpListenersString.split(",")) == null) continue;
                    for (int j = 0; j < httpListenerIDs.length; ++j) {
                        httpListeners.add(httpService.getHttpListenerById(httpListenerIDs[j]));
                    }
                }
            }
        } else {
            String[] virtualServerNames = virtualServers.split(",");
            if (virtualServerNames != null) {
                for (int i = 0; i < virtualServerNames.length; ++i) {
                    String[] httpListenerIDs;
                    VirtualServer vs = httpService.getVirtualServerById(virtualServerNames[i]);
                    String httpListenersString = vs.getHttpListeners();
                    if (httpListenersString == null || (httpListenerIDs = httpListenersString.split(",")) == null) continue;
                    for (int j = 0; j < httpListenerIDs.length; ++j) {
                        httpListeners.add(httpService.getHttpListenerById(httpListenerIDs[i]));
                    }
                }
            }
        }
        WebServerInfo wsi = new WebServerInfo();
        for (int i = 0; i < httpListeners.size(); ++i) {
            HttpListener hl = (HttpListener)httpListeners.get(i);
            if (!hl.isEnabled()) continue;
            if (targetHostName == null && ((targetHostName = hl.getServerName()) == null || targetHostName.length() == 0)) {
                targetHostName = this.getDefaultHostName();
            }
            try {
                targetHostName = InetAddress.getByName(targetHostName).getCanonicalHostName();
            }
            catch (UnknownHostException unex) {
                throw new ConfigException(unex.getMessage(), unex);
            }
            String redirectPortNb = hl.getRedirectPort();
            String portNb = redirectPortNb != null ? redirectPortNb : hl.getPort();
            if (targetName == null) {
                targetName = ApplicationServer.getServerContext().getInstanceName();
            }
            PropertyResolver pr = new PropertyResolver(cc, targetName);
            String resolvedPort = pr.resolve(portNb);
            int port = Integer.parseInt(resolvedPort);
            if (hl.isSecurityEnabled()) {
                wsi.setHttpsVS(new VirtualServerInfo("https", targetHostName, port));
            } else {
                wsi.setHttpVS(new VirtualServerInfo("http", targetHostName, port));
            }
            if (wsi.getHttpVS() != null && wsi.getHttpsVS() != null) break;
        }
        return wsi;
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            deploymentLogger.log(Level.FINEST, "mbean.get_local_host_error", uhe);
            deploymentLogger.log(Level.INFO, "mbean.use_default_host");
        }
        return defaultHostName;
    }

    public static Logger getDefaultLogger() {
        return logger;
    }

    public static LocalStringManagerImpl getDefaultStringManager() {
        return localStrings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateEjbEndpoint(WebServiceEndpoint ejbEndpoint) {
        EjbDescriptor ejbDescriptor = ejbEndpoint.getEjbComponentImpl();
        EjbBundleDescriptor bundle = ejbDescriptor.getEjbBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(ejbDescriptor);
        if (endpoints.size() == 1) {
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                if (ejbEndpoint.getServiceEndpointInterface().equals(ejbDescriptor.getWebServiceEndpointInterfaceName())) return;
                String msg = "Ejb " + ejbDescriptor.getName() + " service endpoint interface does not match " + " port component " + ejbEndpoint.getEndpointName();
                throw new IllegalStateException(msg);
            }
            String msg = "Ejb " + ejbDescriptor.getName() + " must declare <service-endpoint> interface";
            throw new IllegalStateException(msg);
        }
        if (endpoints.size() <= 1) return;
        String msg = "Ejb " + ejbDescriptor.getName() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
        throw new IllegalStateException(msg);
    }

    public void updateServletEndpointRuntime(WebServiceEndpoint endpoint) {
        endpoint.saveServletImplClass();
        WebComponentDescriptor webComp = endpoint.getWebComponentImpl();
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComp);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + endpoint.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (endpoint.getEndpointAddressUri() == null) {
            Set urlPatterns = webComp.getUrlPatternsSet();
            if (urlPatterns.size() == 1) {
                String uri = (String)urlPatterns.iterator().next();
                endpoint.setEndpointAddressUri(uri);
                Collection constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
                for (SecurityConstraint next : constraints) {
                    UserDataConstraint dataConstraint = next.getUserDataConstraint();
                    String guarantee = dataConstraint != null ? dataConstraint.getTransportGuarantee() : null;
                    if (guarantee == null || !guarantee.equals("INTEGRAL") && !guarantee.equals("CONFIDENTIAL")) continue;
                    endpoint.setTransportGuarantee(guarantee);
                    break;
                }
            } else {
                String msg = "Endpoint " + endpoint.getEndpointName() + " has not been assigned an endpoint address " + " and is associated with servlet " + webComp.getCanonicalName() + " , which has " + urlPatterns.size() + " url patterns";
                throw new IllegalStateException(msg);
            }
        }
    }

    private boolean runWsGen(String implClass, boolean skipGenWsdl, String classPath, File stubsDir, File wsdlDir, QName sQname, QName port) {
        int numArgs = skipGenWsdl ? 7 : 14;
        String[] wsgenArgs = new String[numArgs];
        int argIndex = 0;
        wsgenArgs[argIndex++] = "-cp";
        wsgenArgs[argIndex++] = classPath;
        wsgenArgs[argIndex++] = "-keep";
        if (!skipGenWsdl) {
            wsgenArgs[argIndex++] = "-wsdl";
            wsgenArgs[argIndex++] = "-r";
            wsgenArgs[argIndex++] = wsdlDir.getAbsolutePath();
            wsgenArgs[argIndex++] = "-servicename";
            wsgenArgs[argIndex++] = sQname.toString();
            wsgenArgs[argIndex++] = "-portname";
            wsgenArgs[argIndex++] = port.toString();
        }
        wsgenArgs[argIndex++] = "-d";
        wsgenArgs[argIndex++] = stubsDir.getAbsolutePath();
        wsgenArgs[argIndex++] = "-Xdonotoverwrite";
        wsgenArgs[argIndex++] = implClass;
        WSToolsObjectFactory wsTools = WSToolsObjectFactory.newInstance();
        try {
            return wsTools.wsgen((OutputStream)System.out, wsgenArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception occured in the wsgen process " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(URL httpUrl, File toFile) throws Exception {
        OutputStream os;
        block7: {
            InputStream is = null;
            os = null;
            try {
                int readCount;
                if (!toFile.createNewFile()) {
                    throw new Exception("Unable to create new File " + toFile.getAbsolutePath());
                }
                is = httpUrl.openStream();
                os = new FileOutputStream(toFile, true);
                byte[] buffer = new byte[10240];
                while ((readCount = is.read(buffer, 0, 10240)) != -1) {
                    ((FileOutputStream)os).write(buffer, 0, readCount);
                }
                Object var8_7 = null;
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.flush();
                    ((FileOutputStream)os).close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.flush();
            ((FileOutputStream)os).close();
        }
    }

    public Collection getWsdlsAndSchemas(File pkgedWsdl) throws Exception {
        ArrayList<SDDocumentSource> cumulative = new ArrayList<SDDocumentSource>();
        this.getWsdlsAndSchemas(pkgedWsdl, cumulative);
        URL id = pkgedWsdl.toURL();
        SDDocumentSource toRemove = null;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            toRemove = source;
        }
        if (toRemove != null) {
            cumulative.remove(toRemove);
        }
        return cumulative;
    }

    public void getWsdlsAndSchemas(File wsdl, ArrayList<SDDocumentSource> cumulative) throws Exception {
        String location;
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        String wsdlRoot = wsdl.getParent();
        this.parseRelativeImports(wsdl.toURL(), wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        for (Import next : schemaRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File file = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(file, cumulative);
        }
        for (Import next : wsdlRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File currentWsdlFile = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(currentWsdlFile, cumulative);
        }
    }

    private void addFileAndDecendents(File file, ArrayList<SDDocumentSource> cumulative) throws Exception {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        URL id = file.toURL();
        boolean alreadyProcessed = false;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            alreadyProcessed = true;
            break;
        }
        if (!alreadyProcessed) {
            cumulative.add(0, SDDocumentSource.create((URL)id));
            this.getWsdlsAndSchemas(file, cumulative);
        }
    }

    private void downloadWsdlsAndSchemas(WebService ws, URL httpUrl, File wsdlDir) throws Exception {
        wsdlDir.mkdirs();
        String fileName = httpUrl.toString().substring(httpUrl.toString().lastIndexOf("/") + 1);
        File toFile = new File(wsdlDir.getAbsolutePath() + File.separator + fileName);
        this.downloadFile(httpUrl, toFile);
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        this.parseRelativeImports(httpUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        String urlWithoutFileName = httpUrl.toString().substring(0, httpUrl.toString().lastIndexOf("/"));
        for (Import next : schemaRelativeImports) {
            String location = next.getLocation();
            if ((location = location.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1) {
                File newDir = new File(wsdlDir.getAbsolutePath() + File.separator + location.substring(0, location.lastIndexOf(File.separator)));
                newDir.mkdirs();
            }
            this.downloadFile(new URL(urlWithoutFileName + "/" + next.getLocation()), new File(wsdlDir.getAbsolutePath() + File.separator + location));
        }
        for (Import next : wsdlRelativeImports) {
            String newWsdlLocation = next.getLocation();
            File newWsdlDir = (newWsdlLocation = newWsdlLocation.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1 ? new File(wsdlDir.getAbsolutePath() + File.separator + newWsdlLocation.substring(0, newWsdlLocation.lastIndexOf(File.separator))) : wsdlDir;
            this.downloadWsdlsAndSchemas(ws, new URL(urlWithoutFileName + "/" + next.getLocation()), newWsdlDir);
        }
    }

    private String addJarsToClassPath(String cp, String dirName) throws IASDeploymentException {
        try {
            File dir = new File(dirName);
            if (dir.exists()) {
                Iterator fileSetIter = FileUtil.getAllFilesUnder(dir, new JarFilter(), false).iterator();
                while (fileSetIter.hasNext()) {
                    cp = cp + File.pathSeparator + ((File)fileSetIter.next()).getAbsolutePath();
                }
            }
        }
        catch (IOException ioex) {
            throw new IASDeploymentException("IOException : " + ioex.getMessage() + " when trying to get list of files under " + dirName);
        }
        return cp;
    }

    private String addModuleDirsToClassPath(String cp, String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            cp = cp + File.pathSeparator + dir.getAbsolutePath();
        }
        return cp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getWsgenClassPath(File classesDir, String webinfLibDir, String appLibDirPath, String moduleDir, Application app) throws IASDeploymentException {
        String classpath = classesDir.getAbsolutePath();
        if (webinfLibDir != null) {
            classpath = this.addJarsToClassPath(classpath, webinfLibDir);
        }
        if (appLibDirPath != null) {
            classpath = this.addJarsToClassPath(classpath, appLibDirPath);
            classpath = this.addJarsToClassPath(classpath, new File(appLibDirPath).getParentFile().getAbsolutePath());
        }
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            String moduleUri = md.getArchiveUri();
            String parentPath = new File(appLibDirPath).getParentFile().getAbsolutePath();
            String moduleRoot = DeploymentUtils.getEmbeddedModulePath(parentPath, moduleUri);
            classpath = this.addModuleDirsToClassPath(classpath, moduleRoot);
        }
        FileInputStream is = null;
        try {
            try {
                Manifest ms;
                Attributes attrMap;
                String mfCp;
                File mfFile = new File(moduleDir + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
                if (mfFile.exists() && (mfCp = (attrMap = (ms = new Manifest(is = new FileInputStream(mfFile))).getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null && mfCp.length() != 0) {
                    StringTokenizer strTok = new StringTokenizer(mfCp, " \t");
                    while (strTok.hasMoreTokens()) {
                        String givenCP = strTok.nextToken();
                        if (!givenCP.startsWith(File.separator)) {
                            givenCP = new File(moduleDir).getParent() + File.separator + givenCP;
                        }
                        classpath = classpath + File.pathSeparator + givenCP;
                    }
                }
                Object var15_15 = null;
                if (is == null) return classpath;
            }
            catch (Exception e) {
                throw new IASDeploymentException("Exception : " + e.getMessage() + " when trying to process MANIFEST file under " + moduleDir);
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException t) {}
        is.close();
        return classpath;
    }

    public void genWSInfo(Application app, DeploymentRequest request) throws IASDeploymentException {
        Set bundles = app.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            WebServicesDescriptor wsDesc = bundle.getWebServices();
            for (WebService ws : wsDesc.getWebServices()) {
                File wsdlFile;
                String wsdlFileUri;
                File classesDir;
                File moduleDir = request.getDeployedDirectory();
                File wsdlDir = request.getGeneratedXMLDirectory();
                File stubsDir = request.getStubsDirectory();
                if (request.isApplication()) {
                    String subDirName = DeploymentUtils.getRelativeEmbeddedModulePath(moduleDir.getAbsolutePath(), bundle.getModuleDescriptor().getArchiveUri());
                    moduleDir = new File(moduleDir, subDirName);
                    wsdlDir = new File(wsdlDir, subDirName);
                }
                String webinfLibDir = null;
                if (ModuleType.WAR.equals(bundle.getModuleType())) {
                    classesDir = new File(moduleDir, "WEB-INF" + File.separator + "classes");
                    webinfLibDir = moduleDir.getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "lib";
                } else {
                    if (!ModuleType.EJB.equals(bundle.getModuleType())) continue;
                    classesDir = moduleDir;
                }
                wsdlDir = new File(wsdlDir, bundle.getWsdlDir().replaceAll("/", "\\" + File.separator));
                this.checkCatalog(bundle, ws, moduleDir);
                if (ws.hasWsdlFile()) {
                    if (ws.getWsdlFileUri().startsWith("http")) {
                        try {
                            this.downloadWsdlsAndSchemas(ws, new URL(ws.getWsdlFileUri()), wsdlDir);
                        }
                        catch (Exception e) {
                            throw new IASDeploymentException(e.toString(), e);
                        }
                        wsdlFileUri = ws.getWsdlFileUri().substring(ws.getWsdlFileUri().lastIndexOf("/") + 1);
                        wsdlFile = new File(wsdlDir, wsdlFileUri);
                    } else {
                        wsdlFileUri = ws.getWsdlFileUri();
                        wsdlFile = wsdlFileUri.startsWith("/") ? new File(wsdlFileUri) : new File(moduleDir, wsdlFileUri);
                        if (!wsdlFile.exists()) {
                            throw new IASDeploymentException("WebService " + ws.getName() + " wsdl file " + ws.getWsdlFileUri() + " not found in archive " + bundle.getModuleDescriptor().getArchiveUri());
                        }
                    }
                } else {
                    wsdlFileUri = JAXBRIContext.mangleNameToClassName((String)ws.getName()) + ".wsdl";
                    wsdlDir.mkdirs();
                    wsdlFile = new File(wsdlDir, wsdlFileUri);
                }
                for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
                    Class<?> implClass;
                    boolean jaxwsEndPtFound = false;
                    boolean jaxrpcEndPtFound = false;
                    String implClassName = endpoint.implementedByEjbComponent() ? endpoint.getEjbComponentImpl().getEjbClassName() : endpoint.getWebComponentImpl().getWebComponentImplementation();
                    try {
                        implClass = app.getClassLoader().loadClass(implClassName);
                    }
                    catch (Exception e) {
                        throw new IASDeploymentException("WebService " + ws.getName() + "implementation " + implClassName + " not found in archive " + bundle.getModuleDescriptor().getArchiveUri());
                    }
                    if (implClass == null) continue;
                    if (implClass.getAnnotation(WebServiceProvider.class) != null) {
                        if (jaxrpcEndPtFound) {
                            throw new IASDeploymentException("WebService " + ws.getName() + "has a JAXWS and a JAXRPC endpoint; this is not supported now");
                        }
                        jaxwsEndPtFound = true;
                        continue;
                    }
                    if (implClass.getAnnotation(javax.jws.WebService.class) != null) {
                        if (jaxrpcEndPtFound) {
                            throw new IASDeploymentException("WebService " + ws.getName() + "has a JAXWS and a JAXRPC endpoint; this is not supported now");
                        }
                        jaxwsEndPtFound = true;
                        String wsgenClassPath = this.getWsgenClassPath(classesDir, webinfLibDir, request.getDeployedDirectory().getAbsolutePath() + File.separator + app.getLibraryDirectory(), moduleDir.getAbsolutePath(), app);
                        boolean wsgenDone = this.runWsGen(implClassName, wsdlFile.exists(), wsgenClassPath, stubsDir, wsdlDir, endpoint.getServiceName(), endpoint.getWsdlPort());
                        if (!wsgenDone) {
                            if (!wsdlFile.exists()) {
                                throw new IASDeploymentException("WSGEN FAILED");
                            }
                            logger.log(Level.WARNING, "wsgen failed - proceeding under the assumption that the user packaged all required objects properly");
                        }
                        try {
                            endpoint.getWebService().setWsdlFileUrl(wsdlFile.toURI().toURL());
                        }
                        catch (MalformedURLException mue) {
                            throw new IASDeploymentException("WSGEN Failed");
                        }
                        logger.log(Level.INFO, "wsgen successful");
                        continue;
                    }
                    if (jaxwsEndPtFound) {
                        throw new IASDeploymentException("WebService " + ws.getName() + "has a JAXWS and a JAXRPC endpoint; this is not supported now");
                    }
                    jaxrpcEndPtFound = true;
                    ws.getWebServicesDescriptor().setSpecVersion("1.1");
                }
            }
        }
    }

    public URL resolveCatalog(File catalogFile, String wsdlFile, WebService ws) throws IASDeploymentException {
        try {
            URL retVal = null;
            EntityResolver resolver = XmlUtil.createEntityResolver((URL)catalogFile.toURL());
            InputSource source = resolver.resolveEntity(null, wsdlFile);
            if (source != null) {
                String mappedEntry = source.getSystemId();
                if (mappedEntry.startsWith("file:")) {
                    File f = new File(mappedEntry.substring(mappedEntry.indexOf(":") + 1));
                    if (!f.exists()) {
                        throw new IASDeploymentException("File " + mappedEntry + " not found");
                    }
                    retVal = f.toURI().toURL();
                    if (ws != null) {
                        ws.setWsdlFileUri(f.getAbsolutePath());
                        ws.setWsdlFileUrl(retVal);
                    }
                } else if (mappedEntry.startsWith("http")) {
                    retVal = new URL(mappedEntry);
                    if (ws != null) {
                        ws.setWsdlFileUrl(retVal);
                    }
                }
            }
            return retVal;
        }
        catch (Throwable t) {
            throw new IASDeploymentException("Exception while processing catalog " + catalogFile.getAbsolutePath() + "; Reason " + t.getMessage());
        }
    }

    private void checkCatalog(BundleDescriptor bundle, WebService ws, File moduleDir) throws IASDeploymentException {
        File catalogFile = new File(moduleDir, bundle.getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (!catalogFile.exists()) {
            return;
        }
        this.resolveCatalog(catalogFile, ws.getWsdlFileUri(), ws);
    }

    public static Class generateAndLoad(ClassGeneratorFactory cgf, ClassLoader loader) {
        cgf.evaluate();
        Properties props = new Properties();
        if (logger.isLoggable(Level.FINE)) {
            props.put("com.sun.corba.codegen.debug.dumpAfterSetupVisitor", "true");
            props.put("com.sun.corba.codegen.debug.traceByteCodeGeneration", "true");
            props.put("com.sun.corba.codegen.debug.useAsmVerifier", "true");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                Wrapper._sourceCode(ps, props);
                logger.log(Level.FINE, baos.toString());
            }
            catch (Exception e) {
                logger.log(Level.FINE, "exception generating src", e);
            }
        }
        return Wrapper._generate(loader, null, props);
    }

    public void doPostConstruct(Class impl, Object implObj) {
        this.invokeServiceMethod(PostConstruct.class, impl, implObj);
    }

    public void doPreDestroy(WebServiceEndpoint ep, ClassLoader loader) {
        try {
            Class<?> impl = Class.forName(ep.getServletImplClass(), true, loader);
            this.invokeServiceMethod(PreDestroy.class, impl, impl.newInstance());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Class " + ep.getServletImplClass() + "not found during PreDestroy processing", ex);
        }
        if (!ep.hasHandlerChain()) {
            return;
        }
        for (WebServiceHandlerChain thisHc : ep.getHandlerChain()) {
            for (WebServiceHandler thisHandler : thisHc.getHandlers()) {
                try {
                    Class<?> handlerClass = Class.forName(thisHandler.getHandlerClass(), true, loader);
                    this.invokeServiceMethod(PreDestroy.class, handlerClass, handlerClass.newInstance());
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "Handler class " + thisHandler.getHandlerClass() + "not found during PreDestroy processing", ex);
                }
            }
        }
    }

    private void invokeServiceMethod(Class annType, Class impl, final Object implObj) {
        Method[] methods;
        for (final Method method : methods = impl.getDeclaredMethods()) {
            if (method.getAnnotation(annType) == null) continue;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        method.invoke(implObj, new Object[0]);
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failure while calling PostConstruct/PreDestroy method", e);
            }
            break;
        }
    }

    private boolean matchQNamePatterns(QName cfgQName, QName givenPattern) {
        if (givenPattern.getNamespaceURI().equals(cfgQName.getNamespaceURI())) {
            String expr = givenPattern.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(expr, cfgQName.getLocalPart());
        }
        return false;
    }

    private boolean patternsMatch(WebServiceHandlerChain hc, QName svcName, QName portName, String bindingId) {
        QName portPattern;
        QName svcPattern;
        if (hc.getServiceNamePattern() != null && svcName != null && !this.matchQNamePatterns(svcName, svcPattern = QName.valueOf(hc.getServiceNamePattern()))) {
            return false;
        }
        if (hc.getPortNamePattern() != null && portName != null && !this.matchQNamePatterns(portName, portPattern = QName.valueOf(hc.getPortNamePattern()))) {
            return false;
        }
        if (hc.getProtocolBindings() != null && bindingId != null) {
            String givenBindings = hc.getProtocolBindings();
            if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http") && (givenBindings.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || givenBindings.indexOf("##XML_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || givenBindings.indexOf("##SOAP11_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || givenBindings.indexOf("##SOAP12_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || givenBindings.indexOf("##SOAP11_HTTP_MTOM") != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || givenBindings.indexOf("##SOAP12_HTTP_MTOM") != -1)) {
                return true;
            }
        }
        return true;
    }

    private List<Handler> processConfiguredHandlers(List<WebServiceHandler> handlersList, Set<String> roles) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        for (WebServiceHandler h : handlersList) {
            Class<?> handlerClass;
            Handler handler = null;
            HashMap params = new HashMap();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                handlerClass = Class.forName(h.getHandlerClass(), true, loader);
                handler = (Handler)handlerClass.newInstance();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Unable to load handler class " + h.getHandlerClass());
                t.printStackTrace();
                continue;
            }
            try {
                new InjectionManagerImpl().injectInstance(handler);
            }
            catch (InjectionException e) {
                logger.severe("Handler " + h.getHandlerClass() + " instance injection failed : " + e.getMessage());
                continue;
            }
            this.doPostConstruct(handlerClass, handler);
            Collection rolesColl = h.getSoapRoles();
            roles.addAll(rolesColl);
            handlerChain.add(handler);
        }
        return handlerChain;
    }

    public void configureJAXWSServiceHandlers(WebServiceEndpoint ep, String bindingId, WSBinding bindingObj) {
        if (!ep.hasHandlerChain()) {
            return;
        }
        List handlerChainList = ep.getHandlerChain();
        ArrayList<Handler> finalHandlerList = new ArrayList<Handler>();
        HashSet<String> roles = new HashSet<String>();
        for (WebServiceHandlerChain hc : handlerChainList) {
            if (!this.patternsMatch(hc, ep.getServiceName(), ep.getWsdlPort(), bindingId)) continue;
            List<Handler> handlerInfo = this.processConfiguredHandlers(hc.getHandlers(), roles);
            finalHandlerList.addAll(handlerInfo);
        }
        bindingObj.setHandlerChain(finalHandlerList);
        if (bindingObj instanceof SOAPBinding) {
            ((SOAPBinding)bindingObj).setRoles(roles);
        }
    }

    public void configureJAXWSClientHandlers(javax.xml.ws.Service svcClass, ServiceReferenceDescriptor desc) {
        HandlerResolverImpl resolver = new HandlerResolverImpl();
        HashSet<String> roles = new HashSet<String>();
        Iterator ports = svcClass.getPorts();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            LinkedList handlerChainList = desc.getHandlerChain();
            for (WebServiceHandlerChain hc : handlerChainList) {
                if (!this.patternsMatch(hc, desc.getServiceName(), nextPort, null)) continue;
                ArrayList<String> protocols = new ArrayList<String>();
                if (hc.getProtocolBindings() == null) {
                    protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                } else {
                    String specifiedProtocols = hc.getProtocolBindings();
                    if (specifiedProtocols.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || specifiedProtocols.indexOf("##XML_HTTP") != -1) {
                        protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || specifiedProtocols.indexOf("##SOAP11_HTTP") != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || specifiedProtocols.indexOf("##SOAP12_HTTP") != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || specifiedProtocols.indexOf("##SOAP11_HTTP_MTOM") != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || specifiedProtocols.indexOf("##SOAP12_HTTP_MTOM") != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                    }
                }
                List<WebServiceHandler> handlersList = hc.getHandlers();
                for (WebServiceHandler thisOne : handlersList) {
                    Collection portNames = thisOne.getPortNames();
                    if (portNames.isEmpty() || portNames.contains(nextPort.getLocalPart())) continue;
                    handlersList.remove(thisOne);
                }
                List<Handler> handlerInfo = this.processConfiguredHandlers(handlersList, roles);
                Iterator s = protocols.iterator();
                while (s.hasNext()) {
                    PortInfoImpl portInfo = new PortInfoImpl(BindingID.parse((String)((String)s.next())), nextPort, desc.getServiceName());
                    resolver.setHandlerChain(portInfo, handlerInfo);
                }
            }
        }
        svcClass.setHandlerResolver((HandlerResolver)resolver);
    }

    public boolean getMtom(WebServiceEndpoint ep) {
        String currentBinding = ep.getProtocolBinding();
        if (ep.getMtomEnabled() == null && ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding))) {
            return true;
        }
        return new Boolean(ep.getMtomEnabled()) != false && ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(currentBinding) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding));
    }

    public static SOAPMessage getMessage(SOAPMessageContext c) {
        return c.getMessage();
    }

    private static synchronized SOAPMessage getMessage(javax.xml.ws.handler.soap.SOAPMessageContext c, boolean nameKnown) {
        SOAPMessage message = null;
        if (message == null) {
            message = c.getMessage();
        }
        return message;
    }

    public static synchronized SOAPMessage getMessage(javax.xml.ws.handler.soap.SOAPMessageContext c) {
        return WsUtil.getMessage(c, true);
    }

    public static synchronized SOAPMessage getMessageWithName(javax.xml.ws.handler.soap.SOAPMessageContext c) {
        return WsUtil.getMessage(c, false);
    }

    public static boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
        if (policyMap == null || wsdlPort == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            if (policy != null && policy.contains(SECURITY_POLICY_NAMESPACE_URI)) {
                return true;
            }
            for (WSDLBoundOperation wbo : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName(), (QName)wbo.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy != null && policy.contains(SECURITY_POLICY_NAMESPACE_URI)) {
                    return true;
                }
                policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                if (policy != null && policy.contains(SECURITY_POLICY_NAMESPACE_URI)) {
                    return true;
                }
                policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                if (policy != null && policy.contains(SECURITY_POLICY_NAMESPACE_URI)) {
                    return true;
                }
                policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                if (policy == null || !policy.contains(SECURITY_POLICY_NAMESPACE_URI)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            return false;
        }
        return false;
    }

    class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

