/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.Type;
import com.sun.corba.ee.spi.codegen.Wrapper;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import sun.rmi.rmic.IndentingWriter;

public class ServiceInterfaceGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServiceInterfaceGenerator.class);
    private static Logger _logger = null;
    Class sib = null;
    String serviceIntfName;
    String packageName;
    String serviceIntfSimpleName;
    Method[] intfMethods;

    public ServiceInterfaceGenerator(ClassLoader cl, Class sib) throws GeneratorException, ClassNotFoundException {
        this.sib = sib;
        this.serviceIntfSimpleName = this.getServiceIntfName();
        this.packageName = this.getPackageName();
        this.serviceIntfName = this.packageName + "." + this.serviceIntfSimpleName;
        this.intfMethods = this.calculateMethods(sib, this.removeDups(sib.getMethods()));
    }

    public String getServiceIntfName() {
        String serviceIntfSimpleName = this.sib.getSimpleName();
        if (serviceIntfSimpleName.endsWith("EJB")) {
            return serviceIntfSimpleName.substring(0, serviceIntfSimpleName.length() - 3);
        }
        return serviceIntfSimpleName + "SEI";
    }

    public String getPackageName() {
        return this.sib.getPackage().getName() + ".internal.jaxws";
    }

    public String getGeneratedClass() {
        return this.serviceIntfName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    private Method[] calculateMethods(Class sib, Method[] initialList) {
        boolean webMethodAnnotationUsed = false;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : initialList) {
            WebMethod wm = m.getAnnotation(WebMethod.class);
            if (wm != null && !webMethodAnnotationUsed) {
                webMethodAnnotationUsed = true;
                list.clear();
            }
            if (wm != null) {
                list.add(m);
                continue;
            }
            if (webMethodAnnotationUsed || m.getDeclaringClass().equals(Object.class)) continue;
            list.add(m);
        }
        return list.toArray(new Method[0]);
    }

    public ClassGenerator evaluate() {
        Wrapper._clear();
        if (this.packageName != null) {
            Wrapper._package(this.packageName);
        }
        Wrapper._interface(1, this.serviceIntfName, new Type[0]);
        for (int i = 0; i < this.intfMethods.length; ++i) {
            this.printMethod(this.intfMethods[i]);
        }
        Wrapper._end();
        return Wrapper._classGenerator();
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        p.pln("");
        if (this.packageName != null) {
            p.pln("package " + this.packageName + ";");
        }
        p.pln("");
        p.plnI("public interface " + this.serviceIntfSimpleName + " {");
        p.pln("");
        for (int i = 0; i < this.intfMethods.length; ++i) {
            this.printMethod(p, this.intfMethods[i]);
        }
        p.pOln("}");
        p.close();
    }

    private void printMethod(Method m) {
        boolean throwsRemoteException = false;
        LinkedList<Type> exceptionList = new LinkedList<Type>();
        for (Class<?> exception : m.getExceptionTypes()) {
            exceptionList.add(Type.type(exception));
            if (!exception.getName().equals("java.rmi.RemoteException")) continue;
            throwsRemoteException = true;
        }
        if (!throwsRemoteException) {
            exceptionList.add(Wrapper._t("java.rmi.RemoteException"));
        }
        Wrapper._method(1025, Type.type(m.getReturnType()), m.getName(), exceptionList);
        int i = 0;
        Expression expr = null;
        for (Class<?> param : m.getParameterTypes()) {
            expr = Wrapper._arg(Type.type(param), "param" + i);
            ++i;
        }
        Wrapper._end();
    }

    private void printMethod(IndentingWriter p, Method m) throws IOException {
        p.pln("");
        p.p("public " + this.printType(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                p.p(", ");
            }
            p.p(this.printType(params[i]) + " param" + i);
        }
        p.p(") ");
        Class<?>[] exceptions = m.getExceptionTypes();
        boolean throwsRemoteException = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                p.p("throws ");
            } else {
                p.p(", ");
            }
            String nextEx = exceptions[i].getName();
            p.p(nextEx);
            if (!nextEx.equals("java.rmi.RemoteException")) continue;
            throwsRemoteException = true;
        }
        if (exceptions.length == 0) {
            p.p("throws java.rmi.RemoteException");
        } else if (!throwsRemoteException) {
            p.p(", java.rmi.RemoteException");
        }
        p.pln(";");
        p.pln("");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

