/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.CommonServerSecurityPipe;
import com.sun.enterprise.webservice.MonitoringPipe;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.assembler.ServerPipelineHook;
import com.sun.xml.ws.policy.PolicyMap;
import java.util.HashMap;

public class ServerPipeCreator
extends ServerPipelineHook {
    private WebServiceEndpoint endpoint;
    private boolean isHttpBinding;

    public ServerPipeCreator(WebServiceEndpoint ep) {
        this.endpoint = ep;
        this.isHttpBinding = "http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding());
    }

    public Pipe createMonitoringPipe(ServerPipeAssemblerContext ctxt, Pipe tail) {
        return new MonitoringPipe(ctxt, tail, this.endpoint);
    }

    public Pipe createSecurityPipe(PolicyMap map, SEIModel sei, WSDLPort port, WSEndpoint owner, Pipe tail) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("POLICY", map);
        props.put("SEI_MODEL", sei);
        props.put("WSDL_MODEL", port);
        props.put("ENDPOINT", owner);
        props.put("SERVICE_ENDPOINT", this.endpoint);
        props.put("NEXT_PIPE", tail);
        if (WsUtil.isSecurityEnabled(map, port)) {
            this.endpoint.setSecurePipeline();
        }
        return new CommonServerSecurityPipe(props, tail, this.isHttpBinding);
    }
}

