/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.util;

import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.logging.LogDomains;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.util.RequestUtil;

public final class I18NParseUtil {
    public static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static boolean _debugLog = _logger.isLoggable(Level.FINE);

    public static String parseParametersUsingLCInfo(Map map, String queryString, byte[] buf, LocaleCharsetMap[] lcMap, String hiddenFieldName, HttpServletRequest request) throws UnsupportedEncodingException {
        LinkedList queryStringKeys;
        String hiddenFieldValue;
        byte[] queryStringBytes = null;
        if (queryString != null && queryString.length() > 0) {
            queryStringBytes = queryString.getBytes();
        }
        if ((hiddenFieldValue = I18NParseUtil.processBufferWithHiddenField(map, queryStringBytes, hiddenFieldName, queryStringKeys = new LinkedList(), null, null)) != null) {
            if (_debugLog) {
                _logger.fine("Got charset from queryString, hidden field name = " + hiddenFieldName + ", hidden field value = " + hiddenFieldValue);
            }
            RequestUtil.parseParameters(map, buf, hiddenFieldValue);
            return hiddenFieldValue;
        }
        LinkedList bufKeys = new LinkedList();
        hiddenFieldValue = I18NParseUtil.processBufferWithHiddenField(map, buf, hiddenFieldName, bufKeys, queryStringBytes, queryStringKeys);
        if (hiddenFieldValue != null) {
            if (_debugLog) {
                _logger.fine("Got charset from POST data, hidden field name = " + hiddenFieldName + ", hidden field value = " + hiddenFieldValue);
            }
            return hiddenFieldValue;
        }
        String encoding = null;
        if (lcMap != null) {
            hiddenFieldValue = encoding = I18NParseUtil.getLocaleCharsetEncoding(request, lcMap);
        }
        if (encoding == null) {
            encoding = "ISO-8859-1";
            if (_debugLog) {
                _logger.fine("Using default encoding to parse params: " + encoding);
            }
        }
        I18NParseUtil.processLinkedList(map, queryStringBytes, queryStringKeys, encoding);
        I18NParseUtil.processLinkedList(map, buf, bufKeys, encoding);
        return hiddenFieldValue;
    }

    public static String processBufferWithHiddenField(Map map, byte[] buf, String hiddenFieldName, LinkedList keys, byte[] queryStringBytes, LinkedList queryStringKeys) throws UnsupportedEncodingException {
        int pos = 0;
        int ix = 0;
        int ox = 0;
        String key = null;
        String value = null;
        boolean foundHiddenField = false;
        String hiddenFieldValue = null;
        if (buf == null) {
            return null;
        }
        block6: while (ix < buf.length) {
            byte c = buf[ix++];
            switch ((char)c) {
                case '&': {
                    if (key != null) {
                        if (foundHiddenField) {
                            value = new String(buf, pos, ox - pos, hiddenFieldValue);
                            I18NParseUtil.putMapEntry(map, key, value);
                        } else if (key.equals(hiddenFieldName)) {
                            hiddenFieldValue = new String(buf, pos, ox - pos, "ISO-8859-1");
                            if (queryStringKeys != null) {
                                I18NParseUtil.processLinkedList(map, queryStringBytes, queryStringKeys, hiddenFieldValue);
                            }
                            I18NParseUtil.processLinkedList(map, buf, keys, hiddenFieldValue);
                            I18NParseUtil.putMapEntry(map, key, hiddenFieldValue);
                            foundHiddenField = true;
                        } else {
                            Object[] startEndPos = new Object[]{key, new Integer(pos), new Integer(ox)};
                            keys.add(startEndPos);
                        }
                        key = null;
                    }
                    pos = ix;
                    ox = ix;
                    continue block6;
                }
                case '=': {
                    if (key == null) {
                        key = new String(buf, pos, ox - pos, "ISO-8859-1");
                        ox = ix;
                        pos = ix;
                        continue block6;
                    }
                    buf[ox++] = c;
                    continue block6;
                }
                case '+': {
                    buf[ox++] = 32;
                    continue block6;
                }
                case '%': {
                    buf[ox++] = (byte)((I18NParseUtil.convertHexDigit(buf[ix++]) << 4) + I18NParseUtil.convertHexDigit(buf[ix++]));
                    continue block6;
                }
            }
            buf[ox++] = c;
        }
        if (key != null) {
            if (foundHiddenField) {
                value = new String(buf, pos, ox - pos, hiddenFieldValue);
                I18NParseUtil.putMapEntry(map, key, value);
            } else if (key.equals(hiddenFieldName)) {
                hiddenFieldValue = new String(buf, pos, ox - pos, "ISO-8859-1");
                if (queryStringKeys != null) {
                    I18NParseUtil.processLinkedList(map, queryStringBytes, queryStringKeys, hiddenFieldValue);
                }
                I18NParseUtil.processLinkedList(map, buf, keys, hiddenFieldValue);
                I18NParseUtil.putMapEntry(map, key, hiddenFieldValue);
                foundHiddenField = true;
            } else {
                Object[] startEndPos = new Object[]{key, new Integer(pos), new Integer(ox)};
                keys.add(startEndPos);
            }
        }
        return hiddenFieldValue;
    }

    public static void processLinkedList(Map map, byte[] buf, LinkedList keys, String encoding) throws UnsupportedEncodingException {
        if (buf == null || keys == null) {
            return;
        }
        ListIterator keysIterator = keys.listIterator(0);
        while (keysIterator.hasNext()) {
            Object[] startEndPos = (Object[])keysIterator.next();
            String key = (String)startEndPos[0];
            int startPos = (Integer)startEndPos[1];
            int endPos = (Integer)startEndPos[2];
            String value = new String(buf, startPos, endPos - startPos, encoding);
            I18NParseUtil.putMapEntry(map, key, value);
        }
        keys.clear();
    }

    public static String getLocaleCharsetEncoding(HttpServletRequest request, LocaleCharsetMap[] charsetMap) {
        if (charsetMap == null) {
            return null;
        }
        String requestLocale = request.getLocale().toString();
        if (requestLocale == null) {
            return null;
        }
        String userAgent = request.getHeader("user-agent");
        for (int i = 0; i < charsetMap.length; ++i) {
            String agent;
            LocaleCharsetMap element = charsetMap[i];
            String s = element.getAttributeValue("Locale");
            if (!s.equals(requestLocale) || (agent = element.getAttributeValue("Agent")) != null && agent.length() != 0 && userAgent != null && !agent.equals(userAgent)) continue;
            String encoding = element.getAttributeValue("Charset");
            if (_debugLog) {
                _logger.fine("Got charset in locale-charset-map, locale=" + requestLocale + ", agent=" + agent + ", charset=" + encoding);
            }
            return encoding;
        }
        return null;
    }

    private static void putMapEntry(Map map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = (String[])map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }
}

