/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import com.sun.enterprise.util.collection.Bucket;
import com.sun.enterprise.util.collection.SortedArrayListBucket;
import java.util.Iterator;

public class IntHashMap {
    int maxBuckets = 0;
    Bucket[] buckets;

    public IntHashMap() {
        this(89);
    }

    public IntHashMap(int maxBuckets) {
        this.maxBuckets = maxBuckets;
        this.buckets = new Bucket[maxBuckets];
        for (int i = 0; i < maxBuckets; ++i) {
            this.buckets[i] = new SortedArrayListBucket();
        }
    }

    public IntHashMap(Bucket[] buckets) {
        this.buckets = buckets;
        this.maxBuckets = buckets.length;
    }

    public void put(int key, Object object) {
        int index = Math.abs(key % this.maxBuckets);
        this.buckets[index].put(key, object);
    }

    public Object get(int key) {
        int index = Math.abs(key % this.maxBuckets);
        return this.buckets[index].get(key);
    }

    public boolean containsKey(int key) {
        return null != this.get(key);
    }

    public Object remove(int key) {
        int index = Math.abs(key % this.maxBuckets);
        return this.buckets[index].remove(key);
    }

    public void print() {
        for (int i = 0; i < this.maxBuckets; ++i) {
            System.out.println("Bucket[" + i + "]: " + this.buckets[i]);
        }
    }

    public IntHashMapIterator iterator() {
        return new IntHashMapIterator();
    }

    public static void main(String[] args) {
        int i;
        int count = 20;
        long time = 0L;
        long t1 = 0L;
        long t2 = 0L;
        String data = "SomeData_";
        IntHashMap map = new IntHashMap();
        for (i = 0; i < count; i += 5) {
            map.put(i, data + i);
        }
        for (i = 1; i < count; i += 3) {
            map.put(i, data + i);
        }
        for (i = 3; i < count; i += 4) {
            map.put(i, data + i);
        }
        for (i = -23; i < count; i += 4) {
            map.put(i, data + i);
        }
        for (int j = -25; j < 25; ++j) {
            System.out.println("Key: " + j + "; val: " + map.get(j));
        }
        t2 = System.currentTimeMillis();
        IntHashMapIterator iter = map.iterator();
        while (iter.hasNext()) {
            System.out.println("Got: " + iter.next());
        }
    }

    private class IntHashMapIterator
    implements Iterator {
        int bucketIndex = 0;
        Iterator iter = null;

        IntHashMapIterator() {
            this.iter = IntHashMap.this.buckets[0].iterator();
        }

        public boolean hasNext() {
            if (this.iter.hasNext()) {
                return true;
            }
            while (++this.bucketIndex < IntHashMap.this.maxBuckets) {
                this.iter = IntHashMap.this.buckets[this.bucketIndex].iterator();
                if (!this.iter.hasNext()) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
        }
    }
}

