/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.EntityManagerMethod;
import com.sun.enterprise.deployment.types.EntityManagerReference;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.util.EntityManagerFactoryWrapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.QueryWrapper;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerWrapper
implements EntityManager,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EntityManagerWrapper.class);
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private transient EntityManagerFactory entityManagerFactory;
    private transient J2EETransactionManager txManager;
    private transient ContainerFactory containerFactory;
    private transient EntityManager extendedEntityManager;
    private transient EntityManager nonTxEntityManager;

    public EntityManagerWrapper(EntityManagerReference referenceDescriptor) {
        this.unitName = referenceDescriptor.getUnitName();
        this.contextType = referenceDescriptor.getPersistenceContextType();
        this.emProperties = referenceDescriptor.getProperties();
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
        this.txManager = Switch.getSwitch().getTransactionManager();
        this.containerFactory = Switch.getSwitch().getContainerFactory();
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        J2EETransaction tx = null;
        try {
            tx = (J2EETransaction)this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
        if (tx == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        EntityManager delegate = null;
        if (this.nonTxEntityManager != null) {
            this.cleanupNonTxEntityManager();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            J2EETransaction tx = null;
            try {
                tx = (J2EETransaction)this.txManager.getTransaction();
            }
            catch (Exception e) {
                throw new IllegalStateException("exception retrieving tx", e);
            }
            if (tx != null) {
                delegate = tx.getExtendedEntityManager(this.entityManagerFactory);
                if (delegate == null && (delegate = tx.getTxEntityManager(this.entityManagerFactory)) == null) {
                    delegate = this.entityManagerFactory.createEntityManager(this.emProperties);
                    tx.addTxEntityManagerMapping(this.entityManagerFactory, delegate);
                }
            } else {
                delegate = this.nonTxEntityManager = this.entityManagerFactory.createEntityManager(this.emProperties);
            }
        } else {
            if (this.extendedEntityManager == null) {
                this.extendedEntityManager = this.containerFactory.lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("In EntityManagerWrapper::_getDelegate(). Logical entity manager  = " + this);
            _logger.fine("Physical entity manager = " + delegate);
        }
        return delegate;
    }

    private void cleanupNonTxEntityManager() {
        if (this.nonTxEntityManager != null) {
            this.nonTxEntityManager.close();
            this.nonTxEntityManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.PERSIST);
            }
            this._getDelegate().persist(entity);
            Object var4_3 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        Object object;
        block3: {
            this.doTransactionScopedTxCheck();
            Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
            try {
                if (callFlowAgent.isEnabled()) {
                    callFlowAgent.entityManagerMethodStart(EntityManagerMethod.MERGE);
                }
                object = this._getDelegate().merge(entity);
                Object var5_4 = null;
                if (!callFlowAgent.isEnabled()) break block3;
                callFlowAgent.entityManagerMethodEnd();
            }
            catch (Throwable throwable) {
                block4: {
                    Object var5_5 = null;
                    if (!callFlowAgent.isEnabled()) break block4;
                    callFlowAgent.entityManagerMethodEnd();
                }
                throw throwable;
            }
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REMOVE);
            }
            this._getDelegate().remove(entity);
            Object var4_3 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            returnValue = this._getDelegate().find(entityClass, primaryKey);
            Object var6_5 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_REFERENCE);
            }
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
            Object var6_5 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.doTxRequiredCheck();
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FLUSH);
            }
            this._getDelegate().flush();
            Object var3_2 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            block8: {
                try {
                    if (callFlowAgent.isEnabled()) {
                        callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY);
                    }
                    EntityManager delegate = this._getDelegate();
                    returnValue = delegate.createQuery(ejbqlString);
                    if (this.nonTxEntityManager == null) break block8;
                    Query queryDelegate = returnValue;
                    returnValue = QueryWrapper.createQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, ejbqlString);
                    this.nonTxEntityManager = null;
                }
                catch (RuntimeException re) {
                    if (this.nonTxEntityManager != null) {
                        this.cleanupNonTxEntityManager();
                    }
                    throw re;
                }
            }
            Object var7_7 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return returnValue;
    }

    public Query createNamedQuery(String name) {
        Query returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            block8: {
                try {
                    if (callFlowAgent.isEnabled()) {
                        callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
                    }
                    EntityManager delegate = this._getDelegate();
                    returnValue = delegate.createNamedQuery(name);
                    if (this.nonTxEntityManager == null) break block8;
                    Query queryDelegate = returnValue;
                    returnValue = QueryWrapper.createNamedQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, name);
                    this.nonTxEntityManager = null;
                }
                catch (RuntimeException re) {
                    if (this.nonTxEntityManager != null) {
                        this.cleanupNonTxEntityManager();
                    }
                    throw re;
                }
            }
            Object var7_7 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            block8: {
                try {
                    if (callFlowAgent.isEnabled()) {
                        callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING);
                    }
                    EntityManager delegate = this._getDelegate();
                    returnValue = delegate.createNativeQuery(sqlString);
                    if (this.nonTxEntityManager == null) break block8;
                    Query queryDelegate = returnValue;
                    returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString);
                    this.nonTxEntityManager = null;
                }
                catch (RuntimeException re) {
                    if (this.nonTxEntityManager != null) {
                        this.cleanupNonTxEntityManager();
                    }
                    throw re;
                }
            }
            Object var7_7 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            block8: {
                try {
                    if (callFlowAgent.isEnabled()) {
                        callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_CLASS);
                    }
                    EntityManager delegate = this._getDelegate();
                    returnValue = delegate.createNativeQuery(sqlString, resultClass);
                    if (this.nonTxEntityManager == null) break block8;
                    Query queryDelegate = returnValue;
                    returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultClass);
                    this.nonTxEntityManager = null;
                }
                catch (RuntimeException re) {
                    if (this.nonTxEntityManager != null) {
                        this.cleanupNonTxEntityManager();
                    }
                    throw re;
                }
            }
            Object var8_8 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            block8: {
                try {
                    if (callFlowAgent.isEnabled()) {
                        callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_STRING);
                    }
                    EntityManager delegate = this._getDelegate();
                    returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
                    if (this.nonTxEntityManager == null) break block8;
                    Query queryDelegate = returnValue;
                    returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultSetMapping);
                    this.nonTxEntityManager = null;
                }
                catch (RuntimeException re) {
                    if (this.nonTxEntityManager != null) {
                        this.cleanupNonTxEntityManager();
                    }
                    throw re;
                }
            }
            Object var8_8 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH);
            }
            this._getDelegate().refresh(entity);
            Object var4_3 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CONTAINS);
            }
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            Object var6_5 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (this.nonTxEntityManager != null) {
                    this.cleanupNonTxEntityManager();
                }
                if (!callFlowAgent.isEnabled()) break block6;
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    public void close() {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        if (callFlowAgent.isEnabled()) {
            callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLOSE);
            callFlowAgent.entityManagerMethodEnd();
        }
        throw new IllegalStateException();
    }

    public boolean isOpen() {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        if (callFlowAgent.isEnabled()) {
            callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_OPEN);
            callFlowAgent.entityManagerMethodEnd();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_TRANSACTION);
            }
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            Object var4_3 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            return entityTransaction;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (this.nonTxEntityManager != null) {
                    this.cleanupNonTxEntityManager();
                }
                if (!callFlowAgent.isEnabled()) break block6;
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK);
            }
            this._getDelegate().lock(entity, lockMode);
            Object var5_4 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLEAR);
            }
            this._getDelegate().clear();
            Object var3_2 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_DELEGATE);
            }
            EntityManager entityManager = this._getDelegate();
            Object var4_3 = null;
            if (this.nonTxEntityManager != null) {
                this.nonTxEntityManager = null;
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            return entityManager;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (this.nonTxEntityManager != null) {
                    this.nonTxEntityManager = null;
                }
                if (!callFlowAgent.isEnabled()) break block6;
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            Object var4_3 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            return flushModeType;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (this.nonTxEntityManager != null) {
                    this.cleanupNonTxEntityManager();
                }
                if (!callFlowAgent.isEnabled()) break block6;
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        try {
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_FLUSH_MODE);
            }
            this._getDelegate().setFlushMode(flushMode);
            Object var4_3 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (callFlowAgent.isEnabled()) {
                callFlowAgent.entityManagerMethodEnd();
            }
            throw throwable;
        }
    }

    public void joinTransaction() {
        this.doTxRequiredCheck();
        Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
        if (callFlowAgent.isEnabled()) {
            callFlowAgent.entityManagerMethodStart(EntityManagerMethod.JOIN_TRANSACTION);
            callFlowAgent.entityManagerMethodEnd();
        }
    }
}

