/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import tools.com.sun.enterprise.util.XMLValidationHandler;

public class TagLibFactory {
    private DocumentBuilder builder;
    private Context context;
    private FrameworkContext frameworkContext;
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private boolean uninitialised = false;
    private final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public TagLibFactory(Context context, FrameworkContext frameworkContext) {
        this.context = context;
        this.frameworkContext = frameworkContext;
    }

    public TagLibDescriptor[] getTagLibDescriptors(WebBundleDescriptor descriptor) {
        ArrayList<TagLibDescriptor> tmp = new ArrayList<TagLibDescriptor>();
        Enumeration taglibConfig = null;
        if (descriptor.getJspConfigDescriptor() == null) {
            return null;
        }
        taglibConfig = descriptor.getJspConfigDescriptor().getTagLibs();
        this.init();
        while (taglibConfig.hasMoreElements()) {
            TagLibConfigurationDescriptor taglibDescriptor = (TagLibConfigurationDescriptor)taglibConfig.nextElement();
            String taglibLocation = taglibDescriptor.getTagLibLocation();
            Document d = null;
            try {
                d = this.createDocument(taglibLocation, descriptor);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, this.smh.getLocalString(this.getClass().getName() + ".exception", "Continuing, though problem in creating taglib document. Cause: {0}", new Object[]{e.getMessage()}));
                if (!(e instanceof SAXParseException)) continue;
                LogRecord logRecord = new LogRecord(Level.SEVERE, this.smh.getLocalString(this.getClass().getName() + ".exception2", "XML Error line : {0} in [ {1} ]. {2}", new Object[]{((SAXParseException)e).getLineNumber(), taglibLocation, e.getLocalizedMessage()}));
                logRecord.setThrown(e);
                this.frameworkContext.getResultManager().log(logRecord);
                continue;
            }
            String version = this.getTLDSpecVersion(d);
            TagLibDescriptor taglib = null;
            taglib = new TagLibDescriptor(d, version, taglibLocation);
            tmp.add(taglib);
        }
        int count = tmp.size();
        TagLibDescriptor[] arr = new TagLibDescriptor[count];
        int i = 0;
        Iterator e = tmp.iterator();
        while (e.hasNext()) {
            arr[i] = (TagLibDescriptor)e.next();
            ++i;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.uninitialised) {
            TagLibFactory tagLibFactory = this;
            synchronized (tagLibFactory) {
                if (!this.uninitialised) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    String W3C_XML_SCHEMA = "http://www.w3c.org/2001/XMLSchema";
                    String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
                    factory.setNamespaceAware(true);
                    factory.setValidating(true);
                    factory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
                    factory.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
                    factory.setAttribute("http://apache.org/xml/features/allow-java-encodings", Boolean.TRUE);
                    factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    try {
                        this.builder = factory.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException e) {
                        this.logger.log(Level.SEVERE, e.getMessage());
                    }
                    XMLValidationHandler dh = new XMLValidationHandler(true);
                    XMLValidationHandler eh = new XMLValidationHandler(true);
                    this.builder.setErrorHandler(eh);
                    this.builder.setEntityResolver(dh);
                    this.uninitialised = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(String location, WebBundleDescriptor webd) throws IOException, SAXException {
        Document document = null;
        InputSource source = null;
        location = location.startsWith("/") ? location.substring(1) : "WEB-INF/" + location;
        ModuleDescriptor moduleDesc = webd.getModuleDescriptor();
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        String uri = null;
        uri = moduleDesc.isStandalone() ? archBase : archBase + File.separator + FileUtils.makeFriendlyFileName(moduleDesc.getArchiveUri());
        FileArchive arch = new FileArchive();
        arch.open(uri);
        InputStream is = arch.getEntry(location);
        try {
            if (is == null) {
                throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".exception1", "Wrong tld [ {0} ] specified in the web.xml of [ {1} ]", new Object[]{location, moduleDesc.getArchiveUri()}));
            }
            source = new InputSource(is);
            document = this.builder.parse(source);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTLDSpecVersion(Document doc) {
        String str = null;
        if (doc.getDoctype() == null) return doc.getElementsByTagName("taglib").item(0).getAttributes().getNamedItem("version").getNodeValue();
        NodeList nl = doc.getElementsByTagName("jsp-version");
        if (nl != null && nl.getLength() != 0) {
            return nl.item(0).getFirstChild().getNodeValue();
        }
        nl = doc.getElementsByTagName("jspversion");
        if (nl.getLength() == 0) return "1.1";
        return nl.item(0).getFirstChild().getNodeValue();
    }
}

