/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;

public class BusinessMethodFinal
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
            Set<String> localAndRemoteInterfaces = descriptor.getLocalBusinessClassNames();
            localAndRemoteInterfaces.addAll(descriptor.getRemoteBusinessClassNames());
            for (String localOrRemoteIntf : localAndRemoteInterfaces) {
                this.commonToBothInterfaces(localOrRemoteIntf, descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Proper declaration of business method(s) found."));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String intf, EjbDescriptor descriptor) {
        try {
            Class<?> intfClass = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
            for (Method remoteMethod : intfClass.getMethods()) {
                if (remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBObject") || remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject") || remoteMethod.getDeclaringClass().getName().equals("java.lang.Object")) continue;
                Class<?> beanClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                for (Method method : beanClass.getMethods()) {
                    Object[] remoteParams;
                    Object[] parms;
                    if (!method.getName().equals(remoteMethod.getName()) || !Arrays.equals(parms = method.getParameterTypes(), remoteParams = remoteMethod.getParameterTypes()) || !Modifier.isFinal(method.getModifiers())) continue;
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: final business method [ {0} ] was found, but business method cannot be declared as final.", new Object[]{method.getName()}));
                }
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{intf, descriptor.getEjbClassName(), descriptor.getName()}));
        }
    }
}

